#ifndef __ResultsTable_cpp__
#define __ResultsTable_cpp__

namespace BIOS {

	ResultsTable::ResultsTable(){
		values = NULL;
		rows = 0;
		cols=0;

	};

	ResultsTable::~ResultsTable(){
	
		for(int i=0; i<rows;i++)
			delete values[i];
		delete values;
	
		values = NULL;
		rows = 0;
		cols=0;
	};

	ResultsTable::ResultsTable(int rows, int cols)
	{
		nSamples = 1;
		this->rows=rows;
		this->cols=cols;
		values = new double*[rows];
		for(int i=0; i<rows;i++)
			values[i] = new double[cols];

		for (int r=0; r<rows;r++)		
			for (int c=0; c<cols;c++)
				values[r][c] = 0;

	};

	ostream& operator<<(ostream& out, ResultsTable& l)
	{
		out << l.colCaptions << endl;
		for (int r=0; r<l.rows;r++)
		{
			out << l.rowCaptions[r] << "\t";
			for (int c=0; c<l.cols;c++){
				out << l.values[r][c]/(double)l.nSamples << "\t";
				//out << l.values[r][c] << "\t";
			}
			out << endl;

		}
/*
		for (int tr=0; tr<2; tr++)
		{
		if (tr==0) out << "T: "; else out << "U: ";
		for (int i=0; i<l.getYDim();i++)
		{
		out << l.getValue(tr,i);
		if (i<(l.getYDim()-1)) out <<" "; else out <<"\n";
		}
		}
*/
		return out;
	}

};

#endif
