#ifndef __SNP_h__
#define __SNP_h__




namespace BIOS {
	

/*______________________________________________________*/

	typedef enum {// GenotypeTest
		maf=0, 
		HWE=1, 
		MendelianError=2,
		missingGenotype=3,
    heterozygosity=4,
	} GenotypeTest; 
	
	typedef int SNPPos;
	
	typedef int IndPos;
	
		
	typedef enum {// phaselgorithm
		onlyKnown=0, 
		maxFreq=1, 
		weighted=2
	} PhaseAlg; 

ostream& operator<<(ostream& out, PhaseAlg& pm)
       {
   switch (pm)
{
case 0: out << "only known\n"; break;
case 1: out << "max freq\n"; break;
case 2: out << "weighted\n"; break;
}
return out;
};

	typedef enum {// EMDistributions
		oneDistribution=0, 
		UTDistributions=1, 
	} EMDistributions;

	typedef enum {// EMRestriction
		noRestriction=0, 
		triosBasedRestriction=1
	} EMRestriction; 

ostream& operator<<(ostream& out, EMDistributions& pm)
       {
   switch (pm)
{
case 0: out << "oneDistribution\n"; break;
case 1: out << "UTDistributions\n"; break;
}
return out;
};

ostream& operator<<(ostream& out, EMRestriction& pm)
       {
   switch (pm)
{
case 0: out << "noRestriction\n"; break;
case 1: out << "triosBasedRestriction\n"; break;
}
return out;
};

	/*
	typedef enum {// phase is not known
		h12=0, 
		h13=1, 
		h23=2, 
		h14=3,
		h24=4,
		h34=5			
	} MultiallelicHetero; 
	
	
	typedef enum {
		m11=0,
		m12=1, 
		m22=2,
		m33=3, 
		m13=4, 
		m23=5,
		m44=6,
		m14=7,
		m24=8,
		m34=9	
	} MultiallelicHaplotypes; 
	
	
	typedef enum {
		g11=0,
		g12U=1, //unknown
		g22=2,
		g33=3, 
		g13U=4, 
		g23U=5,
		g44=6,
		g14U=7,
		g24U=8,
		g34U=9,
		g12=10,
		g21=11,
		g13=12,
		g31=13,
		g14=14,
		g41=15,
		g23=16,
		g32=17,
		g24=18,
		g42=19,
		g34=20,
		g43=21	
	} MultiallelicGenotypes; 

	*/
	typedef enum {
		NotChanged=0, // phase is not known
		MajorFirst=1, // phase is not known
		LeftRight=2, // phase is known
		LeftRightUsingTrios=3,// phase is inferred from trios
		random=4			
	} AlleleOrderType; 
	

ostream& operator<<(ostream& out, AlleleOrderType& pm)
       {
   switch (pm)
{
case 0: out << "not changed\n"; break;
case 1: out << "major first\n"; break;
case 2: out << "left/right\n"; break;
case 3: out << "left/right using trios\n"; break;
case 4: out << "random\n"; break;
}
return out;
};


	typedef enum {
		IsPhased=0, 
			KeepLeftRight=1, 
			ToOrder=2, 
			ResolveFromTU=3, 
			dHap=4, 
			ResolveFromPhasedChild=5, 
			ResolvePhaseFromFile=6,
			NR=7
	} PhaseType; 


	typedef enum {
			h1=0, 
			h2=1, 
			H=2		
	} SimpleGenotype; 

/*
	typedef enum {
			h1h1=0, 
			h1h2=1, 
			h1H=2,
			h2h1=3,
			h2h2=4,
			h2H=5,
			Hh1=6,
			Hh2=7,
			HH=8
			
	} PairedGenotype; 
	*/

	char vali[2];
	
	const char* PrintPhaseTypes();
	
	/*
	@memo Definition of type allele
	@doc
	Used to declare alleles in SNPs. They can have one of the values 0,1,2,3,4,
	representing missing, adenine, cytosine, guanine, thymine respectively.
    */
	
	
	// adenine     A=1;
	// cytosine     C=2;
	// guanine    G=3;
	// thymine   T=4;
	
typedef enum  {ad=1, ci=2, gu=3, ti=4, na=5} base;

	typedef enum  {A=1, C=2, G=3, T=4, NA=5, UNA=-5, UT=-4, UG=-3, UC=-2, UA=-1} allele; // U: unphased, N:non known
	
	//typedef enum  {LeftLeft=0, LeftRight=1, RightLeft=2, RightRight} ModeDir; // U: unphased, N:non known
	
	typedef enum  {Left=0, Right=1, All=2} ModePhase; // U: unphased, N:non known
	
	typedef enum  {left=0, right=1} HaplotypeType; // U: unphased, N:non known
	
	//	typedef enum  {left=0, right=1, leftright=2, rightleft=4, all=5} ModePair; // U: unphased, N:non known

 typedef enum  {ut=0, t=1, u=2} Transmission;

 typedef enum  {onlyHomo=0, onlyHetero=1, allHomozygosity=2} Homozygosity;
	
	typedef enum  {father=0, mother=1, offspring=2, everybody=3, parent=4, unrelated=5, relative=6} IndCategory;
	
	//typedef enum  {missing=0, homozygous1=1, homozygous2=2, homozygous3=3, homozygous4=4, heterozygous=5} GenotypeType;
	
	typedef enum {Known=0, Complete=1, Inferred=2} LDType ; // LD from known haplotypes, max and min respectively
	
	// project: onlt some SNPs, select: only some individuals or all
//	typedef enum  {Project=0, Select=1, None=3} RedType; 
	
	typedef double frequencies[9];
	
	typedef double sfrequencies[5];
	
    typedef double hprobs[4];
	
        typedef enum {DHAP=0, PHASE=1, SNPHAP=2, HTYPER=3, PLEM=4, PHASERECOMB=5, NR1=6, ML=7, MS=8, COSI=9, HAP=10, MLC=11, MAKEPED=12, MLHAP=13, MLCHAP=14, PED=15, WTCCC=16, IHAP=17, BEAGLE=18, BEAGLETRIOS=19} FormatType; // 
	
	//typedef enum {Missing=0, ABAB=1, ABAb=2, ABaB=3, ABab=4, AbAb=5, AbaB=6, Abab=7, aBaB=8, aBab=9, abab=10, Unphased=11} GenotypeCode ; // 
	
	
	
	bool IsACorrectAllele (char value);

 //bool isACorrectAllele (const char*value);
	
	allele ConvertAllele (const char* value);
	
	
	string UnconvertAllele (allele a);
	
	
	double AddBayesAllele(double Total, BayesType Bayes, float distance=0, float alpha=4);
	
	
	double AddBayesHap(double Total, BayesType Bayes, float distance=0, unsigned short int hap=0, double MLfA=0.5, double MLfB=0.5, float alpha=4, int totalHaplotypes=4);

	double AddBayesMultimarkerHap(double Total, BayesType Bayes, float distance=0, float alpha=4, double totalHaplotypes=4);
	
	
	FormatType GetFormatType (char* Algorithm);

	int getTotalUnknownHaplotypes(int totalAlleles)  throw (MultiAllelic);

	int getTotalGenotypes(int totalAlleles)  throw (MultiAllelic);

	bool isAKnownHaplotype(int hapValue, int var, int totalAlleles);

	int getPosUnknownHaplotypes (int allelePos1, int allelePos2, int var, AmbiguousArray* genotypeTable);

	int getPosGenotype (int allelePos1, int allelePos2, int totalAlleles);

	int getAllelePos (int genotypePos, int var, bool first, AmbiguousArray* genotypeTable) throw (OutOfRange<int>);
	

bool isMissing(allele a);

SNPPos getTotalSNPs(char* filegou);

ostream& operator<<(ostream& out, allele& a)
       {
if (!isMissing(a)) out << (int)a; else out << '?';
return out;
}

	
} // end namespace

#endif

/* End of file: genotype.h */
