/* File: PhylogeneticDistance.h */

#ifndef __HapExtractionConfiguration_h__
#define __HapExtractionConfiguration_h__

//using namespace stats;

namespace BIOS {


/************************/
/* SNP'S MultimarkerMeasure DEFINITION */
/************************/


/**
        @memo HapExtractionConfiguration

	@doc
        Definition:

       Class used to store configuration used to get haplotypes from genotypes in a TrioCounters object

        @author Maria M. Abad
	@version 1.0
*/



 
class	HapExtractionConfiguration {

//

public:
PhaseAlg phaseAlg;
EMDistributions emDistributions;
EMRestriction emRestriction;
AlleleOrderType alleleOrderType;

/*********************************************************************/
/***     ASSOCIATED FUNCTIONS     ***/
/*********************************************************************/

public:


HapExtractionConfiguration(AlleleOrderType alleleOrderType=LeftRight, PhaseAlg phaseAlg=weighted, EMDistributions emDistributions=UTDistributions, EMRestriction emRestriction=triosBasedRestriction)
{
this->alleleOrderType=alleleOrderType;
this->phaseAlg=phaseAlg;
this->emDistributions=emDistributions;
this->emRestriction=emRestriction;
};

};



ostream& operator<<(ostream& out, HapExtractionConfiguration& hc)
{
out <<"\nAllele order type:\t"<< hc.alleleOrderType;
out <<"Phase alg:\t\t"<< hc.phaseAlg;
out <<"EM distribution:\t"<< hc.emDistributions;
out <<"EM restriction:\t\t"<< hc.emRestriction;
return out;
}

} // end namespace
#endif







