#ifndef __HaplotypeTUCounts_cpp__
#define __HaplotypeTUCounts_cpp__

void print(BIOS::HaplotypeTUCounts *h){
	cout << *h << endl;
}

void print2(BIOS::HaplotypeTUCounts *h){
	cout << "hola" << endl;
}

namespace BIOS {

	HaplotypeTUCounts::HaplotypeTUCounts(int size)
	{
		if (size==0) haplotype=NULL;
		else haplotype=new Haplotype(size);
		frequencyT=0;
		frequencyU=0;
		frequencyHomo=0;
	};
	

	/*_________________________________________________________________*/
	

			HaplotypeTUCounts::HaplotypeTUCounts(Haplotype* haplotype, float frequencyT, float frequencyU, float frequencyHomo)
			{
			this->haplotype=haplotype->clone();
			this->frequencyT=frequencyT;
			this->frequencyU=frequencyU;
			this->frequencyHomo=frequencyHomo;
			}
			
				/*_________________________________________________________________*/
	
			HaplotypeTUCounts::HaplotypeTUCounts(HaplotypeTUCounts& other)
			{
			  if ( other.haplotype != NULL)
					this->haplotype=other.haplotype->clone();
			  else
				 	haplotype = NULL;
			this->frequencyT=other.frequencyT;
			this->frequencyU=other.frequencyU;
			this->frequencyHomo=other.frequencyHomo;
			}
	
	/*_________________________________________________________________*/

	HaplotypeTUCounts::~HaplotypeTUCounts()
	{
//		cout << "calling destructor..." << endl;
		zap(haplotype);
	}

			/*_________________________________________________________________*/
	
	bool HaplotypeTUCounts::isTransmitted()
	{
		return frequencyT > 0;
	};

			/*_________________________________________________________________*/
	
	bool HaplotypeTUCounts::isNonTransmitted()
	{
		return frequencyU > 0;
	};

			/*_________________________________________________________________*/
	
	bool HaplotypeTUCounts::hasSameAllelesAs(HaplotypeTUCounts *h)
	{
 if (haplotype==NULL || h->haplotype==NULL) throw NullValue("HaplotypeTUCounts::hasSameAllelesAs(HaplotypeTUCounts *h)");
		return *(this->haplotype) == *(h->haplotype);
	}

			/*_________________________________________________________________*/
	
	bool HaplotypeTUCounts::operator==(HaplotypeTUCounts & h){
		//cout << " comparing HaplotypeTUCounts ..." << endl;
		if ( frequencyT != h.frequencyT || frequencyU != h.frequencyU || frequencyHomo != h.frequencyHomo)  
			return false;
		if (haplotype==NULL && h.haplotype==NULL) return true;
  if ((haplotype==NULL && h.haplotype!=NULL) || (haplotype==NULL && h.haplotype!=NULL))
   return false;
 //throw BadFormat("	bool HaplotypeTUCounts::operator==(HaplotypeTUCounts & h)");
		return * this->haplotype == * h.haplotype;
	}

			/*_________________________________________________________________*/
	
	bool HaplotypeTUCounts::operator!=(HaplotypeTUCounts & h)
	{
		//cout << "Calling differents HaplotypeTUCounts..." << endl;
		return ! (*this == h);
	}

			/*_________________________________________________________________*/
	
	void HaplotypeTUCounts::sumProps(HaplotypeTUCounts * h){
		this->frequencyT += h->frequencyT;
		this->frequencyU += h->frequencyU;
		this->frequencyHomo += h->frequencyHomo;
	}

			/*_________________________________________________________________*/
	
	void HaplotypeTUCounts::chop(HaplotypeTUCounts * & v1, HaplotypeTUCounts * & v2, int pos)
	{
		int lastPos = this->size() - 1;

		if ( pos < 0 || pos > lastPos){
			cerr << "Invalid chop" << endl;
			return;
		}
		
		int size1 = pos + 1;
		int size2 = this->size() - size1;

		v1 = new HaplotypeTUCounts(size1);
		v2 = new HaplotypeTUCounts(size2);

		// Copy data
		v1->frequencyT = frequencyT;
		v1->frequencyU = frequencyU;
		v1->frequencyHomo = frequencyHomo;

		v2->frequencyT = frequencyT;
		v2->frequencyU = frequencyU;
		v2->frequencyHomo = frequencyHomo;

		for (int i=0; i<size1; i++)
			v1->haplotype->setAllele( (*this)[i], i);

		for (int i=size1; i<size(); i++)
			v2->haplotype->setAllele( (*this)[i], i-size1);
	}
			/*_________________________________________________________________*/
	

	HaplotypeTUCounts * HaplotypeTUCounts::filter(int *pos, int length)
	{
		int lastPos = this->size() - 1;

		// Check all positions are valid
		for(int i=0; i<length; i++)
			if ( pos[i] < 0 || pos[i] > lastPos){
				//cerr << "Invalid HaplotypeTUCounts::newHaplotypeFromPositions" << endl;
				throw OutOfBounds(size(), pos[i], "HaplotypeTUCounts::filter (int *pos, int length)");
				return NULL;
			}			

		// create new haplotype
		HaplotypeTUCounts * h = new HaplotypeTUCounts(length);
		h->frequencyT = frequencyT;
		h->frequencyU = frequencyU;
		h->frequencyHomo = frequencyHomo;


		// Copy alleles values
		for (int i=0; i<length; i++)
			h->haplotype->setAllele( (*this)[ pos[i] ], i);

		return h;

	}

				/*_________________________________________________________________*/
	
Haplotype* HaplotypeTUCounts::getHaplotype()
	{
		return haplotype;
	}

			/*_________________________________________________________________*/
	
	base& HaplotypeTUCounts::operator[] (int position) 
	{
		//base& ini=(*this->haplotype->alleleArray);
		//return (base&)ini;
		return (*(this->haplotype->alleleArray+position));
	} 

			/*_________________________________________________________________*/
	
	int HaplotypeTUCounts::size()
	{ 
	  	if ( haplotype != NULL)
			return haplotype->size();
		else
		  	return 0;
	};

			/*_________________________________________________________________*/
	
	int HaplotypeTUCounts::getCommonPositions(HaplotypeTUCounts* hap, intList* positions) 
	{
		if (hap->size()!=this->size()) throw OutOfBounds(hap->size(), this->size(), "2. HaplotypeTUCounts::getCommonPositions"); 
		int commonPositions=0;
		for (intList::iterator it=positions->begin(); it!=positions->end(); it++)
		if (*it>=this->size() || *it<0) throw OutOfBounds(*it, this->size(), "2. HaplotypeTUCounts::getCommonPositions"); 
		//else if (this->getElement(*it)!= hap->getElement(*it)) return commonPositions; 
		else 
		if ((*this)[*it]!= (*hap)[*it]) return commonPositions; 
		else commonPositions++;
		return commonPositions;
	}
	
				/*_________________________________________________________________*/
	
void HaplotypeTUCounts::print()
	{
		cout << *this <<endl; 
	};


};

#endif
