#ifndef __HaplotypeTUCounts_h__
#define __HaplotypeTUCounts_h__

namespace BIOS {
	
	/**
	* HaplotypeTUCounts: A list of alleles
	*/
	
		class HaplotypeTUCounts;
	typedef Set<HaplotypeTUCounts*>::Class SetOfHaplotypeTUCounts; 
	
	
	class HaplotypeTUCounts{
		private:

  Haplotype* haplotype;

		public:
		
			/**
			* Constructor
			*/		
			HaplotypeTUCounts(int size=0);

			HaplotypeTUCounts(Haplotype* haplotype, float frequencyT, float frequencyU, float frequencyHomo);
			
			HaplotypeTUCounts(HaplotypeTUCounts& other);

			~HaplotypeTUCounts();

			Haplotype* getHaplotype();

	//		float frequency; // deprecated

	//		bool transmitted; // deprecated
		
			//! Specifies the HaplotypeTUCounts's transmission frequency in a sample. 
			float frequencyT;

			//! Specifies the HaplotypeTUCounts's non transmission frequency in a sample. Deprecated. 
			float frequencyU;

			// number of haplotypes that came from homozygous genotype (=2xhomo genotypes)
			float frequencyHomo;

			int getCommonPositions(HaplotypeTUCounts* hap, intList* positions);

			base & operator[] (int position) ;

			int size();

			bool isTransmitted();
			
			bool isNonTransmitted();

			/**
			*	Compares two haplotypes. Only compares alleles, not frecuencies and other properties.
			*	@return true if both have the same alleles. false otherwise
			*/
			bool hasSameAllelesAs(HaplotypeTUCounts * h);

			/**
			*	Compares two haplotypes, inluding all properties
			*	@return true if haplotypes are equal
			*/
			bool operator==(HaplotypeTUCounts & h);

			/**
			*	Compares two haplotypes, inluding all properties
			*	@return true if haplotypes are different
			*/
			bool operator!=(HaplotypeTUCounts & h);


			/**
			*	Adds properties values of the given haplotype to the current one.
			*/			
			void sumProps(HaplotypeTUCounts * h);

			/**
			*	splits the haplotype in two new haplotypes
			*	@param v1 First half
			*	@param v2 Second half
			*	@param pos Position to chop the haplotype. Indexed from 0. Must be between 0 and size()-1
			*/
			void chop(HaplotypeTUCounts * & v1, HaplotypeTUCounts * & v2, int pos);

			/**
			*	Creates a new haplotype from the given one. The new haplotype has only the positions given in pos.
			*	@param[in] pos Vector with the positions to extract
			*	@param[in] length Number of elements in vector position
			*	@return New HaplotypeTUCounts with the positions indicated.		
			*/			
			HaplotypeTUCounts * filter(int *pos, int length);


			HaplotypeTUCounts* fromString(string s){throw NonImplemented("HaplotypeTUCounts::fromString(string s)");};

			HaplotypeTUCounts* clone(){return new HaplotypeTUCounts(*this);};

			/**
			* Prints the HaplotypeTUCounts in the following manner: [ a0 a1 ... an ][frequency][T/U]
			* @param output Output stream
			* @param h Vector to print
			*/		
			friend ostream& operator<<(ostream& output,  HaplotypeTUCounts& h){
			  
			   
				output << "[";
				//cout <<"size is " << h.size() << "\n";
				for(int i=0; i< h.size()-1; i++)
					output << h[i] << " ";

				if( h.size() != 0 )
					output << h[h.size()-1];
				else
				  	output << " - ";
				output << "][" << h.frequencyT << "]";
				output << "[" << h.frequencyU << "]";
				output << "[" << h.frequencyHomo << "]";
			

				return output;
			}
/*
			static void print(HaplotypeTUCounts *h){
				for(int i=0; i< h->size()-1; i++)
					printf("%i ", (*h)[i]);
			}
	*/		
			void print();

 
	};



};

#endif
