

#ifndef __HaplotypeTUCountsTree_cpp__
#define __HaplotypeTUCountsTree_cpp__



namespace BIOS
{

	void HaplotypeTUCountsTree::updateFrequenciesFromLeaves()
	{
	  updateFrequenciesFromLeaves( begin() );
	}
	
	void HaplotypeTUCountsTree::updateFrequenciesFromLeaves( iterator it )
	{
	  	sibling_iterator iChildren;
	  
		float sumT=0, sumU=0; // sum of frequencies of the cildren
		HaplotypeTUCounts * h = *it; // haplotype pointed by this node


		if ( number_of_children(it) > 0) { // if not a leave
		  for (iChildren = begin(it); iChildren != end(it); iChildren++){
			 // update children frequencies
			 updateFrequenciesFromLeaves( iChildren );
			 // sum the children values
			 sumT += (*iChildren)->frequencyT;
			 sumU += (*iChildren)->frequencyU;
			 
		  }
		  
		  	// update current node
			h->frequencyT = sumT;
			h->frequencyU = sumU;
		}


	}


	PartitionHaplotypeTUCountsVector * HaplotypeTUCountsTree::getBestLeaves()
	{
		PartitionHaplotypeTUCountsVector * p = new PartitionHaplotypeTUCountsVector();
		HaplotypeTUCountsVector * hv;

		switch ( best_k )
		{

			case 0:
				hv = getHaplotypeLeaves ( best_nodes[0] );
				p->insertSubsetCopy ( hv );
				delete hv;
// 			  (*(p[0]))->collapse();
// 				HaplotypeTUCountsVector * h;
				( *p ) [0]->collapse();
// 				h->collapse();
				break;

			case 1:
				hv = getHaplotypeLeaves ( best_nodes[1] );
				p->insertSubsetCopy ( hv );
				delete hv;
				hv = getHaplotypeLeaves ( best_nodes[2] );
				p->insertSubsetCopy ( hv );
				delete hv;
				( *p ) [0]->collapse();
				( *p ) [1]->collapse();
				break;

			case 2:
				hv = getHaplotypeLeaves ( best_nodes[3] );
				p->insertSubsetCopy ( hv );
				delete hv;
				hv = getHaplotypeLeaves ( best_nodes[4] );
				p->insertSubsetCopy ( hv );
				delete hv;
				hv = getHaplotypeLeaves ( best_nodes[5] );
				p->insertSubsetCopy ( hv );
				delete hv;
				( *p ) [0]->collapse();
				( *p ) [1]->collapse();
				( *p ) [2]->collapse();
				break;
		}

		return p;
	}
	
	HaplotypeTUCountsVector * HaplotypeTUCountsTree::getHaplotypeLeaves ( iterator node )
	{
		HaplotypeTUCountsVector * v = new HaplotypeTUCountsVector();

		for(leaf_iterator l=begin_leaf(node); l != end_leaf(node); l++){
		  v->push_back ( *l );
		}

		return v;

	}	

	
	void HaplotypeTUCountsTree::print(){
	  kptree::print_subtreeOfPointers_bracketed( *this, begin() );
	  cout << endl;
	}
  

};
;  // Fin del Namespace

#endif

