#ifndef __HaplotypeTUCountsTree_h__
#define __HaplotypeTUCountsTree_h__


namespace BIOS
{

template <class T>
class TreeWithBestNodes
{
  public:
  	 	//! Nodes given the maximum statistic
		typename tree<T>::iterator best_nodes[6]; // [0] [1,2] [3,4,5]
		//! mapping for the best_nodes array
		bool best_nodes_found[6]; 
		//! Value of k given the best statistic: 0->[0]; 1->[1,2]; 3->[3,4,5] in the best nodes array.
		int best_k;
		
  public:
	void resetBestNodes()
	{
		for ( int i=0; i<6;i++ )
			this->best_nodes_found[i] = false;
	}		
	
	int maxPossibleK()
	{

		if ( best_nodes_found[3] )
			return 2;
		else
			if ( best_nodes_found[2] )
				return 1;
			else
				return 0;

	}	
		
};
		

class HaplotypeTUCountsTree: public tree<HaplotypeTUCounts *>, public TreeWithBestNodes<HaplotypeTUCounts *>
{
  
  public:
  	/**
		update frequencies in nodes based on the frequencies in the leaves.
	*/
	void updateFrequenciesFromLeaves();
	
  	/**
		update frequencies in nodes based on the frequencies in the leaves. Starting at node given.
		@param it Iterator to the node
	*/	
	void updateFrequenciesFromLeaves( iterator it );

		/**
		* Get a partition with the leaves of the best nodes.
		* For each subset given the best statistic, a new subset is created in the partition.
		* The haplotypes in the leaves are copies of the originals.
		* @return Partition with the leaves. Each subset in the partition corresponds to a subset in the tree.
		*/
		PartitionHaplotypeTUCountsVector * getBestLeaves();
		
		/**
		* Get the leaves from a node. Recursively.
		* @return All the leaves belonging to a node.
		*/
		HaplotypeTUCountsVector * getHaplotypeLeaves(iterator node);		
	
	
	void print();
};


};
;  // Fin del Namespace

#endif


