/* File: MultimarkerMeasure.h */

#ifndef __MultimarkerMeasureHapUAndTUnknownHaps_h__
#define __MultimarkerMeasureHapUAndTUnknownHaps_h__

//using namespace stats;

namespace BIOS {


/************************/
/* SNP'S MultimarkerMeasure DEFINITION */
/************************/


/**
        @memo MultimarkerMeasure for SNPs

	@doc
        Definition:
        A unordered pair of SNPs values for an individual and a genetic position.
        One has been transmitted from the father, one for the mother. Who transmits
        each one of them does not matter.

        Memory space: O(1). 

        @author Maria M. Abad
	@version 1.0
*/


 
class	MultimarkerMeasureHapUAndTUnknownHaps: public MultimarkerMeasureHapUAndT {



public:


//MultidimensionalTable<double>* haplotypeFreqsTab, * haplotypeFreqsTabU, *hapFreqsTab;



       
/*********************************************************************/
/***     ASSOCIATED FUNCTIONS     ***/
/*********************************************************************/


      public:


	MultimarkerMeasureHapUAndTUnknownHaps(SNPPos Pos[], SNPPos totalPos, TrioSample * samp, int gender=everyGender, int affectation=allAffectation, BayesType  Bay=MLE, float alphaBayes=0, float distance=0.0, PhaseAlg=weighted, EMAlg eMAlg=triosBased);
	
 //MultimarkerMeasureHapUAndTUnknownHaps(MultimarkerMeasureHapUAndTUnknownHaps& source);
 MultimarkerMeasureHapUAndTUnknownHaps();

 void set(MultimarkerMeasureHapUAndTUnknownHaps& source);

//MultimarkerMeasureHapUAndTUnknownHaps(MultimarkerMeasureHapUAndT& source);

MultimarkerMeasureHapUAndTUnknownHaps(TrioCounters* source, PhaseAlg phaseAlg=weighted, EMAlg emAlg=triosBased);

MultimarkerMeasureHapUAndTKnownHaps* convertToMultimarkerMeasureHapUAndTKnownHaps();

void setHaplotypeFreqs(PhaseAlg phaseAlg, EMAlg emAlg);

void setHaplotypeFreqs();

 void setHaplotypeFreqsTab(EMAlg emAlg);

 void empty()
{
// zap(haplotypeFreqs);
// zap(haplotypeFreqsU);
	};

// MultimarkerMeasureHapUAndTUnknownHaps* clone();

Pair<MultidimensionalTable<double>*>* getHaplotypeFreqsTab(int type, MultidimensionalTable<double>* genotypeAbsFreqsTab,  MultidimensionalTable<longLongList*>* pointersToPartnerGenotypes, EMAlg emAlg);

Pair<MultidimensionalTable<double>*>* getHaplotypeFreqsTab(EMAlg emAlg);


 //MultidimensionalTable<double>* setInitialEstimation(int type);

MultidimensionalTable<double>* getInitialEstimation(int type);

 MultimarkerMeasureHapUAndTUnknownHaps* getPermutation();


Pair<BidimensionalTable<double>*>* getMultiallelicFreqs(SNPPos a, SNPPos b);


};  // End of class MultimarkerMeasure
/*
ostream& operator<<(ostream& out, MultimarkerMeasureHapUAndTUnknownHaps& pm)
       {
cout << (MultimarkerMeasureHapUAndT&)pm;
if (pm.haplotypeFreqs!=NULL)
   out << *pm.haplotypeFreqs <<"\n";

if (pm.haplotypeFreqsU!=NULL)
   out << *pm.haplotypeFreqsU << "\n";


return out;
};
*/


};  // End of Namespace

#endif

/* End of file: MultimarkerMeasure.h */




