/* File: ParentalGenotypesUsingPointers.h */

#ifndef __ParentalGenotypesUsingPointers_cpp__
#define __ParentalGenotypesUsingPointers_cpp__

//using namespace stats;

namespace BIOS {


/************************/
/* SNP'S MultimarkerMeasure DEFINITION */
/************************/


/**
        @memo ParentalHaplotype 
	@doc
        Definition:

       Class used mainly to compute multimarker tdt or its many variants. In order to similarity measures to can be applied, haplotype counters (or freqs if EM-freq is used) for each couple must be independently kept. One trio may have more than one parentalHaplotype (freqs must sum 1). For this reason, attribute trioCount is required. 

       With this purpose, the class required is:
 

        @author Maria M. Abad Grau
	@version 1.0
*/


ParentalGenotypesUsingPointers::ParentalGenotypesUsingPointers()
{
outputSeparator='-'; delimiters=true; 
father=NULL; mother=NULL; 
trioCount=-1; 
};

/*____________________________________________________________ */

ParentalGenotypesUsingPointers::ParentalGenotypesUsingPointers(Genotype* father, Genotype* mother, int trioCount, char outputSeparator, bool delimiters)
{
this->outputSeparator=outputSeparator; this->delimiters=delimiters; 
this->trioCount=trioCount;
this->father=father;
this->mother=mother;
};

/*____________________________________________________________ */

ParentalGenotypesUsingPointers::ParentalGenotypesUsingPointers(ParentalGenotypesUsingPointers& other)
{
this->outputSeparator=other.outputSeparator; this->delimiters=other.delimiters; 
this->trioCount=other.trioCount;
this->father=other.father->clone();
this->mother=other.mother->clone();
};

/*____________________________________________________________ */

ParentalGenotypesUsingPointers::~ParentalGenotypesUsingPointers()
{
zap(father);
zap(mother);
};

/*____________________________________________________________ */

ParentalGenotypesUsingPointers* ParentalGenotypesUsingPointers::fromString(string s)
{
throw NonImplemented("static ParentalGenotypesUsingPointers* fromString(string s)");
};

/*____________________________________________________________ */

ParentalGenotypesUsingPointers* ParentalGenotypesUsingPointers::clone() {return new ParentalGenotypesUsingPointers(*this);};

/*____________________________________________________________ */

Genotype* ParentalGenotypesUsingPointers::getGenotype(bool isMother)
{
if (isMother) if (mother!=NULL) return mother; else return NULL;
else if (father!=NULL) return father;  else return NULL;
}


	
/*______________________________________________________*/
/*
 template<> Container<vector,  ParentalGenotypesUsingPointers>::iterator Container<vector,  ParentalGenotypesUsingPointers>::removeNode(Container<vector,  ParentalGenotypesUsingPointers>::iterator it, Container<vector,  ParentalGenotypesUsingPointers>::iterator it2){
return this->erase(it, it2);};


/*______________________________________________________*/

ostream& operator<<(ostream& out, struct ParentalGenotypesUsingPointers& pm)
       {
 if (pm.delimiters)  out << "Father: [";
 out << *pm.father << pm.outputSeparator;
 if (pm.delimiters)  out << "] Mother: [";
 out << *pm.mother << pm.outputSeparator;
 if (pm.delimiters) out <<"]: ";
out << pm.trioCount;
return out;
};

typedef Container<vector<ParentalGenotypesUsingPointers*>, ParentalGenotypesUsingPointers*>  ParentalGenotypesUsingPointersList;
/*______________________________________________________*/

   ostream& operator<<(ostream& out, ParentalGenotypesUsingPointersList& lista)
  {
out <<lista.leftDelimiter;
    ParentalGenotypesUsingPointersList::iterator p=lista.getFirst();
 while (p!=lista.end())
    {
         if (*p!=NULL) out << **p; else cout << "null value";
         p=lista.getNext(p); 
        if (p!=lista.end()) out <<"\n"; 
else 
{
out << lista.rightDelimiter;
out <<"\n";
}
    }
     out <<"\n";
 
    return out;
  }


};  // End of Namespace

#endif

/* End of file: MultimarkerMeasure.h */




