/* File: ParentalHaplotypesUsingPointers.h */

#ifndef __ParentalHaplotypesUsingPointers_h__
#define __ParentalHaplotypesUsingPointers_h__

//using namespace stats;

namespace BIOS {


/************************/
/* SNP'S MultimarkerMeasure DEFINITION */
/************************/


/**
        @memo ParentalHaplotype 
	@doc
        Definition:

       Class used mainly to compute multimarker tdt or its many variants. In order to similarity measures to can be applied, haplotype counters (or freqs if EM-freq is used) for each couple must be independently kept. One trio may have more than one parentalHaplotype (freqs must sum 1). For this reason, attribute trioCount is required. 

       With this purpose, the class required is:
 

        @author Maria M. Abad Grau
	@version 1.0
*/


	class ParentalHaplotypesUsingPointers
{
public:
char outputSeparator;
bool delimiters, printTransmitted, printUntransmitted;
// -1 in a hap means the genotype was missing
// -2 in a hap means is unphased
Haplotype* fatherT;
Haplotype* fatherU;
Haplotype* motherT;
Haplotype* motherU;
int trioCount;
double freq; 
bool operator==(ParentalHaplotypesUsingPointers& other) {throw NonImplemented("ParentalHaplotypesUsingPointers::operator==(ParentalHaplotypesUsingPointers& other)");};

/*_______________________________________________________*/

ParentalHaplotypesUsingPointers()
{
outputSeparator='-'; delimiters=true; printTransmitted=true; printUntransmitted=true;
fatherT=NULL; fatherU=NULL; motherT=NULL; motherU=NULL;
trioCount=-1; freq=0;
};
/*_______________________________________________________*/

ParentalHaplotypesUsingPointers(ParentalHaplotypesUsingPointers& other)
{
outputSeparator=other.outputSeparator; delimiters=other.delimiters; printTransmitted=other.printTransmitted; printUntransmitted=other.printUntransmitted;
fatherT=other.fatherT->clone(); fatherU=other.fatherU->clone(); motherT=other.motherT->clone(); motherU=other.motherU->clone();
trioCount=other.trioCount; freq=other.freq;
};
/*_______________________________________________________*/

ParentalHaplotypesUsingPointers(Haplotype* fatherT, Haplotype* fatherU, Haplotype* motherT, Haplotype* motherU, int trioCount, double freq, char outputSeparator, bool delimiters=true, bool printTransmitted=true, bool  printUntransitted=true)
{
this->outputSeparator=outputSeparator; this->delimiters=delimiters; this->printTransmitted=printTransmitted; this->printUntransmitted=printUntransitted;
this->freq=freq;
this->trioCount=trioCount;
this->fatherT=fatherT;
this->motherT=motherT;
this->fatherU=fatherU;
this->motherU=motherU;
};

/*_______________________________________________________*/

~ParentalHaplotypesUsingPointers()
{
zap(fatherT);
zap(motherT);
zap(fatherU);
zap(motherU);
};

/*_______________________________________________________*/

static ParentalHaplotypesUsingPointers* fromString(string s)
{
throw NonImplemented("static ParentalHaplotypesUsingPointers* fromString(string s)");
};

/*_______________________________________________________*/

ParentalHaplotypesUsingPointers* clone() {
return new ParentalHaplotypesUsingPointers(*this);
};

/*_______________________________________________________*/

Haplotype* getHap(bool mother, Transmission trans)
{
if (mother && trans==t) if (motherT!=NULL) return motherT; else return NULL;
if (mother && trans==u) if (motherU!=NULL) return motherU;  else return NULL;
if (!mother && trans==t) if (fatherT!=NULL) return fatherT;  else return NULL;
if (!mother && trans==u) if (fatherU!=NULL) return fatherU;  else return NULL;
}

};
	
/*______________________________________________________*/
/*
 template<> Container<vector,  ParentalHaplotypesUsingPointers>::iterator Container<vector,  ParentalHaplotypesUsingPointers>::removeNode(Container<vector,  ParentalHaplotypesUsingPointers>::iterator it, Container<vector,  ParentalHaplotypesUsingPointers>::iterator it2){
return this->erase(it, it2);};


/*______________________________________________________*/

ostream& operator<<(ostream& out, struct ParentalHaplotypesUsingPointers& pm)
       {
 if (pm.delimiters)  out << "Father T-U: [";
 out << *pm.fatherT << pm.outputSeparator << *pm.fatherU;
 if (pm.delimiters)  out << "]\nMother T-U: [";
 out << *pm.motherT << pm.outputSeparator << *pm.motherU;
 if (pm.delimiters) out <<"]: ";
out << pm.trioCount;
 if (pm.delimiters) out << "(";
out << pm.freq;
 if (pm.delimiters) out <<")";


return out;
};

typedef Container<vector<ParentalHaplotypesUsingPointers*>, ParentalHaplotypesUsingPointers*>  ParentalHaplotypesUsingPointersList;
/*______________________________________________________*/

   ostream& operator<<(ostream& out, ParentalHaplotypesUsingPointersList& lista)
  {
out <<lista.leftDelimiter;
    ParentalHaplotypesUsingPointersList::iterator p=lista.getFirst();
 while (p!=lista.end())
    {
         if (*p!=NULL) out << **p; else cout << "null value";
         p=lista.getNext(p); 
        if (p!=lista.end()) out <<"\n"; 
else 
{
out << lista.rightDelimiter;
out <<"\n";
}
    }
     out <<"\n";
 
    return out;
  }


};  // End of Namespace

#endif

/* End of file: MultimarkerMeasure.h */




