#ifndef __SetOfPartitions_cpp__
#define __SetOfPartitions_cpp__


void print (BIOS::SetOfPartitions *s)
{
  cout << *s << endl;
}

namespace BIOS
{



  template <>
  void VectorOfPartitionHaplotypeTUCountsVectors::removeObjects (VectorOfPartitionHaplotypeTUCountsVectors::iterator it, VectorOfPartitionHaplotypeTUCountsVectors::iterator it2)
  {
    this->erase (it, it2);
  };


  HaplotypeTUCountsVector * SetOfPartitions::getSubSet (int partition, int subset)
  {
    return (* ( (*this) [partition] )	) [subset];
  };

  int SetOfPartitions::getSplitMarker (int partition, int subset)
  {
    return ( (*this) [partition] )->splitMarkers[subset];
  };

  SetOfPartitions*  SetOfPartitions::splitVector (HaplotypeTUCountsVector* v, int k, bool toLeft)
  {

    if ( k < 1 )
    {
      cerr << "Invalid value of k in 'static SetOfPartitions* splitVector(HaplotypeTUCountsVector* v, int k)'" << endl;
      throw;
    }

    SetOfPartitions *partitions = new SetOfPartitions;
    SetOfPartitions *old;

    // Insert whole vector as a partition
    PartitionHaplotypeTUCountsVector * p1 = new PartitionHaplotypeTUCountsVector;

    HaplotypeTUCountsVector *v_copy = new HaplotypeTUCountsVector;
    for ( int h = 0; h < v->size(); h++)
      v_copy->push_back ( (*v) [h] );

    //p1->push_back( v_copy );
    p1->insertSubset ( v_copy, -1); // Insert v, which has not been divided (-1)
    partitions->push_back ( p1 );



    // Recusirvely split until desired k level
    for ( int kk=2; kk <= k; kk++)
    {
		//cout << "k, " <<  kk <<  " size: " << partitions->size() << endl;
      old = partitions;
      partitions = partitions->split (toLeft);
      delete old;
    }

    return partitions;

  };

  SetOfPartitions * SetOfPartitions::split (bool toLeft)
  {

    int number_of_subsets; // Number of subsets in each partition
    int split_marker; // Last marker by which the subset was divided
    int next_split_marker;

    SetOfPartitions * setPartitions = new SetOfPartitions;
    // For each partition
    for (int partition_i=0; partition_i< this->size(); partition_i++)
    {

      number_of_subsets = (*this) [partition_i]->size(); // Number of subsets in partition i

      // For each subset of haplotypes inside the partition
      for (int subset_J=0; subset_J< number_of_subsets; subset_J++)
      {
        // split subset
        HaplotypeTUCountsVector *v1, *v2;
        split_marker = this->getSplitMarker (partition_i, subset_J);
        next_split_marker = this->getSubSet (partition_i, subset_J)->split (v1,v2, split_marker, toLeft);

        if ( next_split_marker != -1 )
        {
          // If the subset could be divided, then create a partition

          PartitionHaplotypeTUCountsVector *partition = new PartitionHaplotypeTUCountsVector;
          // Insert split and the rest
          //partition->push_back(v1);
          //partition->push_back(v2);
          partition->insertSubset (v1, next_split_marker);
          partition->insertSubset (v2, next_split_marker);

          for (int others=0; others< number_of_subsets; others++)
            if ( others != subset_J )
              partition->insertSubsetCopy ( this->getSubSet (partition_i, others), this->getSplitMarker (partition_i, others) );
          //partition->push_back(  this->getSubSet(partition_i, subset_J)  );

          // Insert partition in sp
          setPartitions->push_back ( partition );
        }


      }
    }

    return setPartitions;

  };

  void HaplotypeTUCountsVector::print()
  {
    cout << *this ;
  }
  void PartitionHaplotypeTUCountsVector::print()
  {
    cout << *this ;
  }

  void SetOfPartitions::print()
  {
    cout << *this ;
    // cout << "Number of partitions: " <<  size() << endl;

    //   for (int i=0; i< size(); i++)
    //   	cout << "partition " << i  << ": " <<
    //   	endl << "============" << endl
    //   	       << *((*this)[i]) <<
    //   	 "============" << endl;
  }

	TDTtable * SetOfPartitions::getTDTtableForMinPval(int k, double &minPval)
	{
		TDTtable *out; 
		double tdt_z,  tdt_p,  tdt_p_min;

		for (int p=0; p < size(); p++){	

			TDTtable *t = new TDTtable( (*this)[p] ) ;
			
			tdt_z = t->getStatistic();

			

			tdt_p = pdfTestChiSquare( tdt_z , k - 1); // Get p

			if ( p==0){
				// Initialice
				tdt_p_min = tdt_p;
				out = t;
			}
			else{
				// Rest of iterations
				if ( tdt_p < tdt_p_min){
					tdt_p_min = tdt_p;	
					delete out;
					out = t;
					
				}
				else{
					delete t;
				}
			}

		}
		minPval = tdt_p_min;
	
		return out;
	};

	TDTtable * SetOfPartitions::getTDTtableForMaxZ(double &z)
	{

		TDTtable *out; 
		double z_max;

		for (int p=0; p < size(); p++){	

			TDTtable *t = new TDTtable( (*this)[p] ) ;
			
			z = t->getStatisticZ();

			

			

			if ( p==0){
				// Initialice
				 z_max = z;
				out = t;
			}
			else{
				// Rest of iterations
				if ( z > z_max){
					z_max = z;
					delete out;
					out = t;
					
				}
				else{
					delete t;
				}
			}

		}		
	
		return out;
	};

};

#endif
