#ifndef __SetOfPartitions_h__
#define __SetOfPartitions_h__

namespace BIOS {

	class TDTtable;

	typedef Vector<PartitionHaplotypeTUCountsVector*>::Class VectorOfPartitionHaplotypeTUCountsVectors;

	/**
	* List of partitions
	*/

	class SetOfPartitions: public VectorOfPartitionHaplotypeTUCountsVectors
	{
		public:

			/**
			* Constructor
			*/	
			SetOfPartitions (){};

			/**
			* Destructor 
			* Deletes also the objects pointed in the vector.
			*/	
			~SetOfPartitions(){
				for (int i=0; i< size(); i++)
					delete (*this)[i];
			};

			/**
			* Create a new set of partitions by dividing the given vector at the given k level
			* @param v Vector to split 
			* @param k Level to which split. k is the number of subsets in each partition
			* @param toLeft Indicates the order in which to process the splitting process. When toLeft is true, the alleles are compared from left to right.
			*/	
			static SetOfPartitions*  splitVector(HaplotypeTUCountsVector* v, int k, bool toLeft=false);


			/**
			*	Splits the given set a new level. 
			* 	@return New set of partitions 
			*	@param toLeft Indicates the order in which to process the splitting process. When toLeft is true, the alleles are compared from left to right.
			*/
			SetOfPartitions * split(bool toLeft=false);

			/**
			* Get a specific subset from a partition 
			* @param partition Partition index
			* @param subset Subset index inside the partition specified before
			* @ return List of haplotypes in the subset 
			*/
			HaplotypeTUCountsVector * getSubSet(int partition, int subset);

			/**
			* Get the position by which the subset was splitted
			* @param partition Partition index
			* @param subset Subset index inside the partition specified before
			* @return marker in which the haplotypes were splitted
			*/
			int getSplitMarker(int partition, int subset);
		
			/**
			*	Print the set to specific output
			*/
			friend ostream& operator<<(ostream& output, const SetOfPartitions& sp){

				output << "Number of partitions: " <<  sp.size() << endl;

				for (int i=0; i< sp.size(); i++)
					output << "partition " << i  << ": " << 
					endl << "============" << endl
					<< *(sp[i]) <<
					 "============" << endl;

				return output;

			};

			TDTtable * getTDTtableForMinPval(int k, double &minPval);
			TDTtable * getTDTtableForMaxZ(double &z);

			void print();







			

		
	};

};

#endif
