#ifndef __TDTtable_cpp__
#define __TDTtable_cpp__




/*_____________________________________________________________*/

void print ( BIOS::TDTtable *t )
{
	cout << *t << endl;
}


/*_____________________________________________________________*/


namespace BIOS
{

	TDTtable::TDTtable ( int cols, double minFreq, bool HWE ) :BidimensionalTable<double> ( 3,cols )
	{
// the third row is to store homozygous haplotype counts
		partition = NULL;
		this->minFreq=minFreq;
		this->HWE=HWE;
	};

	/*_____________________________________________________________________________________________________________*/


	TDTtable::TDTtable ( const TDTtable& other ) :BidimensionalTable<double> ( ( TDTtable& ) other )
	{
// the third row is to store homozygous haplotype counts
		partition=NULL;
		if ( other.partition!=NULL ) partition = other.partition->clone();
		this->minFreq=other.minFreq;
		this->HWE=other.HWE;
	};

	/*_____________________________________________________________________________________________________________*/


	TDTtable* TDTtable::clone()
	{
		return new TDTtable ( *this );
	}

	/*_____________________________________________________________________________________________________________*/


	TDTtable::~TDTtable()
	{
		zap ( partition );
	}

	/*_____________________________________________________________________________________________________________*/


	TDTtable::TDTtable ( PartitionHaplotypeTUCountsVector * p, double minFreq, bool HWE )
			:BidimensionalTable<double> ( 3, p->size() )
	{
		if ( p==NULL ) throw NullValue ( " TDTtable::TDTtable (PartitionHaplotypeTUCountsVector * p, double minFreq, bool HWE)" );
		this->minFreq=minFreq;
		this->HWE=HWE;
		HaplotypeSet* hs;
		this->partition=new PartitionAsSetSampleOfHaplotypes ( '\t', '[',']' );
		HaplotypeTUCountsVector* hv;
		HaplotypeTUCounts* hc;
		for ( PartitionHaplotypeTUCountsVector::iterator it=p->begin(); it<p->end(); it++ )
		{
			hs=new HaplotypeSet ( '\t', '[',']' );
			hv=p->getElement ( it );
			for ( HaplotypeTUCountsVector::iterator it2=hv->begin(); it2<hv->end(); it2++ )
   	{
				hc=hv->getElement ( it2 );
				hs->insertHardElement ( hc->getHaplotype() );
				addValue ( 0, p->getPosition ( it ), hc->frequencyT );
				addValue ( 1, p->getPosition ( it ), hc->frequencyU );
				addValue ( 2, p->getPosition ( it ), hc->frequencyHomo );
			}
			if (hs->size()>0) this->partition->insertElement ( hs );
		}
		filter();
		if ( !HWE && getTotalTransmissionCount ( ut ) ==0 ) {zap ( partition ); zap ( table ); zap ( dimensionList );return;};
	};

	/*_____________________________________________________________________________________________________________*/

	TDTtable::TDTtable ( HaplotypeTUCountsVector * p, int* positions, int length, double minFreq, bool HWE )
			:BidimensionalTable<double> ( 3,p->size() )
	{
		// *positions and length are not used and they should be removed.
		try
		{
			if ( p==NULL ) throw NullValue ( " TDTtable::TDTtable (HaplotypeTUCountsVector * p, double minFreq, bool HWE)" );

			this->minFreq=minFreq;
			this->HWE=HWE;
			HaplotypeSet* hs;
			partition=new PartitionAsSetSampleOfHaplotypes ( '\t', '[',']' );
			HaplotypeTUCounts* hc;
			Haplotype* h;
			PartitionAsSetSampleOfHaplotypes::iterator it2;
			for ( HaplotypeTUCountsVector::iterator it=p->begin(); it<p->end(); it++ )
 		{
				hs=new HaplotypeSet ( '\t', '[',']' );
				hc=p->getElement ( it );
				hs->insertHardElement(  hc->getHaplotype() );

				addValue ( 0, p->getPosition ( it ), hc->frequencyT );
				addValue ( 1, p->getPosition ( it ), hc->frequencyU );
				addValue ( 2, p->getPosition ( it ), hc->frequencyHomo );
				
				partition->insertElement ( hs );
			}
  
		filter();
			if ( !HWE && getTotalTransmissionCount ( ut ) ==0 ) {zap ( partition ); zap ( table ); zap ( dimensionList );return;};
		}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from TDTtable::TDTtable(HaplotypeTUCountsVector * p, int* positions, int length, double minFreq, bool HWE)) " ); throw;};
	};


	/*_____________________________________________________________________________________________________________*/
	/*
			TDTtable::TDTtable(HaplotypeTUCountsVector * p, int* positions, int length, double minFreq, bool HWE)
				:BidimensionalTable<double>(3,p->size())
			{
	try
	{
						this->minFreq=minFreq;
									this->HWE=HWE;
	 HaplotypeSet* hs;
	partition=new PartitionAsSetSampleOfHaplotypes('\t', '[',']');
	 HaplotypeTUCounts* hc;
	 Haplotype* h;
	 int pos;
	 PartitionAsSetSampleOfHaplotypes::iterator it2;
	 for (HaplotypeTUCountsVector::iterator it=p->begin(); it<p->end(); it++)
	  {
	  hs=new HaplotypeSet('\t', '[',']');
	  hc=p->getElement(it);
	  if (positions!=NULL) h=hc->getHaplotype()->filter(positions, length);
	  else h=hc->getHaplotype()->clone();
	  hs->insertElement(h);
		partition->insertElement(hs);
	  it2=partition->findElementContainingEqualInternalElement(h);
	  addValue(0, partition->getPosition(it2), hc->frequencyT);
	  addValue(1, partition->getPosition(it2), hc->frequencyU);
	  addValue(2, partition->getPosition(it2), hc->frequencyHomo);
	  }
	  filter();
	}
	catch (BasicException& be){be.addMessage("\ncalled from TDTtable::TDTtable(HaplotypeTUCountsVector * p, int* positions, int length, double minFreq, bool HWE)) "); throw;};
	};



	/*______________________________________________________________________________________________*/


	TDTtable* TDTtable::getFilteredTable()
	{
// for !HWE it removes those columns that does not have any T or U transmission at all or is under minFreq
		try
		{
			int totalHaps=this->getYDim();
			for ( int i=0; i<this->getYDim(); i++ )
				if ( ( !HWE && ( getHeteroHapCount ( i ) ==0 || getHeteroHapCount ( i ) <minFreq ) ) || ( HWE && ( getValue ( 2,i ) ==0 || getValue ( 2,i ) <minFreq ) ) ) 
					totalHaps--;
			if ( totalHaps==0 ) return NULL;
			TDTtable* result=new TDTtable ( totalHaps );
			result->partition=new PartitionAsSetSampleOfHaplotypes ( '\t', '[',']' );
			int pos=0;
			for ( int i=0; i<getYDim(); i++ )
				if ( ( !HWE && getHeteroHapCount ( i ) >0 && getHeteroHapCount ( i ) >=minFreq ) || ( HWE && ( getValue ( 2,i ) >0 && getValue ( 2,i ) >=minFreq ) ) )
				{
					result->partition->insertHardElement ( this->partition->getElement ( i ) );
					result->setValue ( 0, pos, getValue ( 0, i ) );
					result->setValue ( 1, pos, getValue ( 1, i ) );
					result->setValue ( 2, pos, getValue ( 2, i ) );
					pos++;
				}
			if ( pos!=totalHaps ) throw OutOfBounds ( totalHaps, pos, "TDTtable::getFilteredTable(int minFreq, bool HWE)" );
			return result;
		}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from TDTtable* TDTtable::getFilteredTable()) " ); throw;};
	};


	/*__________________________________________________________________________________________*/


	void TDTtable::filter()
	{
		try
		{
   if (partition->size()==0)  {zap ( partition ); zap ( table ); zap ( dimensionList ); return;};
			TDTtable* f=this->getFilteredTable();
//if (partition!=NULL) cout <<"partition is: " << *partition <<"\n";
			if ( f==NULL ) {zap ( partition ); zap ( table ); zap ( dimensionList ); return;}
			//  if (partition==NULL) return;
			zap(this->partition);
			this->partition=f->partition->clone();
			this->empty();
			zap ( this->dimensionList );
			this->set ( 3,f->getYDim() );
			for ( int i=0; i<f->getYDim();i++ )
			{
				setValue ( 0,i,f->getValue ( 0,i ) );
				setValue ( 1,i,f->getValue ( 1,i ) );
				setValue ( 2,i,f->getValue ( 2,i ) );
			}
//cout <<"this dedddis:\n";
//cout <<* this <<"\n";
			zap ( f );
		}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from void TDTtable::filter()) " ); throw;};
	}

	/*________________________________________________________________________________________________*/
	/*
	  void TDTtable::update (HaplotypeTUCountsVector* hapCounts, VectorOfParentalHaplotypes* parentalHaplotypesList, bool useDistances=true)
	  {
	    TDTtable* oldData=this->clone();
	    BidimensionalTable<double>::empty(); // zaparr(table);
	    MultidimensionalTable<double>::set(); // create an empty table
	//    cout <<*oldData <<"\n";
	    double minDistance=-1, tempMin;
	    intSet* minPos=NULL;//=new intSet();// it will store all positions with same minimum distance
	    int selectedPos;
	    zap (this->partition);
	    this->partition=oldData->partition->clone();
	    for (HaplotypeTUCountsVector::iterator it=hapCounts->begin(); it<hapCounts->end(); it++)
	    {
	      minPos=oldData->partition->getPositionsWithMinDistance (*hapCounts->getElement (it)->getHaplotype() );
	      if (minPos->size() ==0) throw BadFormat ("TDTtable::update(HaplotypeTUCountsVector* hapCounts)");
	      selectedPos=rand()%minPos->size();
	    //  for (intSet::iterator it3=minPos->begin(); it3!=minPos->end(); it3++)
	      {
	        addValue (0, minPos->getElement (selectedPos), hapCounts->getElement (it)->frequencyT);
	        addValue (1, minPos->getElement (selectedPos), hapCounts->getElement (it)->frequencyU);
	        addValue (2, minPos->getElement (selectedPos), hapCounts->getElement (it)->frequencyHomo);
	      }
	      zap (minPos);
	    }
	    zap (oldData);
	    filter();
	    if (parentalHaplotypesList!=NULL) removeSemiHomo(parentalHaplotypesList);
	  }

	  
		  
	  
	  /*_____________________________________________________________*/

	  TDTtable * TDTtable::newFromTree(HaplotypeTUCountsTree *tree)
	  {
		 
		 PartitionHaplotypeTUCountsVector * p = tree->getBestLeaves(); // p contains groups of leaves
		 this->copyFrequenciesTo(p); // update p frequencies with values in table
		 TDTtable *t = new TDTtable(p, 0, false); // create a new table with the groups in p
		 p->free(); // free memory
		 delete p;	
		 
		 return t; 
		 
	  }

  /*_____________________________________________________________*/


	void TDTtable::update ( VectorOfParentalHaplotypes* parentalHaplotypesList, bool useDistances, bool treeDT, int position, bool toLeft )
	{
	  try
	  {
		 //BIOS::print (parentalHaplotypesList->getPositions(), parentalHaplotypesList->getLength());
		 //exit(0);
		 TDTtable* oldData=this->clone();
		 BidimensionalTable<double>::empty(); // zaparr(table);
		 MultidimensionalTable<double>::set(); // create an empty table
		 double minDistance=-1, tempMin;
		 int selectedPosT, selectedPosU;
		 intSet* minPosT, *minPosU, *minPosT2, *minPosU2;
		 Haplotype* ht, *hu, *closestHt, *closestHu;
		 ParentalHaplotypesUsingPointers* element;
		 //oldData->partition->print();
		 //PartitionAsSetSampleOfHaplotypes::iterator posT, posU;
//cout <<"list:" << *parentalHaplotypesList <<"\n";
		 for ( VectorOfParentalHaplotypes::iterator it=parentalHaplotypesList->begin(); it!=parentalHaplotypesList->end(); it++ )
		 {
			element=parentalHaplotypesList->getElement ( it );
			for ( int parent=0; parent<2;parent++ )
			{
			  ht=element->getHap ( parent, t );
			  hu=element->getHap ( parent, u );
			  minPosT=oldData->partition->getPositionsWithInternalMinDistance ( ht, position, toLeft );
			  minPosU=oldData->partition->getPositionsWithInternalMinDistance ( hu, position, toLeft );
			  selectedPosT=minPosT->getElement ( rand() %minPosT->size() );
			  selectedPosU=minPosU->getElement ( rand() %minPosU->size() );
			  if ( !useDistances || treeDT)
			  {
				 minPosT2=oldData->partition->getElement ( selectedPosT )->getPositionsWithMinDistance ( ht , position, toLeft);
				 minPosU2=oldData->partition->getElement ( selectedPosU )->getPositionsWithMinDistance ( hu , position, toLeft);
				 closestHt=oldData->partition->getElement ( selectedPosT )->getElement ( minPosT2->getElement ( 0 ) );
				 closestHu=oldData->partition->getElement ( selectedPosU )->getElement ( minPosU2->getElement ( 0 ) );
				 if (!useDistances) 
				 {
					if ( ht->getDistance ( closestHt ) !=0 )
					  selectedPosT=rand() %oldData->partition->size(); // not exactly the same haplotype
					  if ( hu->getDistance ( closestHu ) !=0 )
						 selectedPosU=rand() %oldData->partition->size(); // not exactly the same haplotype
				 }   
				 zap ( minPosT2 );
				 zap ( minPosU2 );
			  }
			  if ( selectedPosT !=selectedPosU || (treeDT && closestHt!=closestHu)) // only hetero 
			  {
				 addValue ( 0, selectedPosT, 1 );
				 addValue ( 1, selectedPosU, 1 );
			  }
			  else addValue ( 2, selectedPosT, 2 );
			  zap ( minPosT ); zap ( minPosU );
			}
		 }
		 delete oldData;
	  }
	  catch ( BasicException& be ) {be.addMessage ( "\ncalled from  void TDTtable::update (VectorOfParentalHaplotypes* parentalHaplotypesList)" ); throw;};
	}

	/*________________________________________________________________________________________________*/

	/*
			void TDTtable::Fill(PartitionHaplotypeTUCountsVector * p)
			{
				if ( getYDim() != p->size() ){
					cerr << "TDTtable: The table could not be filled. The number of columns and the number of subsets does not match " << endl;
					return;
				}
				//
				// Fill table
				//
				double t_freq, u_freq;

				// Fill each column
				for (int i=0; i < p->size(); i++){

					t_freq = (*p)[i]->getTransmittedFreqSum();
					u_freq =  (*p)[i]->getFreqSum() - t_freq;
					this->setValue(0,i, t_freq);
					this->setValue(1,i, u_freq);

				}
				partition = NULL;

			};

	/*___________________________________________________________________________________________*/



	double TDTtable::getStatistic ( bool HWE )
	{
		double sum=0;
		for ( int i=0; i<getYDim();i++ )
		{
			double b, c;
			if ( !HWE )
			{
				b = getValue ( 0,i );
				c = getValue ( 1,i );
			}
			else
			{
				b = getValue ( 2,i ) /2;
				c = getValue ( 0,i ) +getValue ( 1,i );
			}
			if ( ( b+c ) >0 ) sum += std::pow ( b-c , ( double ) 2 ) / ( double ) ( b+c );
		}
		if ( HWE ) return sum;
		else return sum* ( getYDim()-1 ) / ( double ) getYDim();
	};

	/*__________________________________________________________________________________*/


	double TDTtable::getStatisticZforColumn ( int i )
	{
		double p = 0.5; // proportion

		double a; // number of disease-associated haplotypes (sum of T frequencies)
		double n; // the total number of haplotypes (sum of frequencies)
		double z;

		// Calculate a
		a = getValue ( 0,i );

		// Calculate n
		n= a + getValue ( 1,i );

		// Calculate z statistic
		if ( n == 1 )
			z = 0;
		else
			z = ( a - n*p ) / ( sqrt ( n*p* ( 1.0-p ) ) ) ;

		return z;

	}

	/*_____________________________________________________________*/

	double TDTtable::getStatisticZ()
	{
		double proportion = 0.5;

		double z=0;
		double z_i=0;

		// For each column, calculate z statistic

		for ( int i=0; i<getYDim();i++ )   //i is the column index
		{


			z_i = getStatisticZforColumn ( i );
			if ( z_i > 0 )
				z += z_i;

		}
		return z;

//partition->getZstatistic(0.5);
		// For each haplotype set, Calculate z statistic and p value for the set
//     for ( int i=0; i< size(); i++)
//     {
//       HaplotypeTUCountsVector * hv = (*this) [i];
//       z_i = hv->getZstatistic (proportion);
//       if ( z_i > 0)
//         z += z_i;
//     }

		return z;
	}

	/*_____________________________________________________________*/

	double TDTtable::getWeightedStatistic ( doubleList* weights )
	{
		if ( weights->size() != getYDim() ) throw NullValue ( "TDTtable::getWeightedStatistic(doubleList* weights)" );
		double sum=0;

		for ( int i=0; i<getYDim();i++ )
		{
			double b, c;
			b = getValue ( 0,i );
			c = getValue ( 1,i );
			if ( ( b+c ) >0 ) sum += weights->getElement ( i ) *std::pow ( b-c , ( double ) 2 ) / ( double ) ( b+c );
		}
		return sum;
		//return sum*(getYDim()-1)/(double)getYDim();
	};

	/*_____________________________________________________________*/

	doubleList* TDTtable::getHapFreqs()
	{
		doubleList* results=new doubleList();
		if ( getTotalTransmissionCount ( ut ) ==0 )
			throw ZeroValue ( "TDTtable::getHapFreqs()" );
		for ( int i=0; i<getYDim(); i++ )
			results->insertElement ( ( getValue ( 0,i ) +getValue ( 1,i ) ) / ( double ) getTotalTransmissionCount ( ut ) );
		return results;
	}

	/*_____________________________________________________________*/


	double TDTtable::getHeteroHapCount ( int hapPos, Transmission trans )
	{
		double result;
		switch ( trans )
		{
			case t: result=getValue ( 0, hapPos ); break;
			case u: result=getValue ( 1, hapPos ); break;
			case ut: result=getValue ( 0,hapPos ) +getValue ( 1,hapPos ); break;
		}
		return result;
	}


	/*_____________________________________________________________*/


	double TDTtable::getHomoHapCount ( int hapPos )
	{
		return getValue ( 2, hapPos );
	}
	/*_____________________________________________________________*/


	void TDTtable::removeSemiHomo ( VectorOfParentalHaplotypes* parentalHaplotypesList )
	{
		try
		{
			//   cout <<"before is:" << *this <<"\n";
			Haplotype* ht, *hu;
			ParentalHaplotypesUsingPointers* element;
			PartitionAsSetSampleOfHaplotypes::iterator posT, posU;
			for ( VectorOfParentalHaplotypes::iterator it=parentalHaplotypesList->begin(); it!=parentalHaplotypesList->end(); it++ )
			{
				element=parentalHaplotypesList->getElement ( it );
				for ( int parent=0; parent<2;parent++ )
				{
					ht=element->getHap ( parent, t );
					hu=element->getHap ( parent, u );
					if ( *ht!=*hu )
					{
						posT=partition->findElementContainingInternalElement ( ht );
						posU=partition->findElementContainingInternalElement ( hu );
						if ( posT==posU && posT!=partition->end() )
						{
							// cout << "haps: " << *ht << " and " << *hu << " belongs both to group " << partition->getPosition (posT) << "\n";

							setValue ( 0, partition->getPosition ( posT ), getValue ( 0, partition->getPosition ( posT ) )-1 );
							setValue ( 1, partition->getPosition ( posT ), getValue ( 1, partition->getPosition ( posT ) )-1 );
							addValue ( 2, partition->getPosition ( posT ), 2 );
							if ( getValue ( 0, partition->getPosition ( posT ) ) <0 || getValue ( 1, partition->getPosition ( posT ) ) <0 )
							{
								cout <<"current is:" << *this <<"\n";
								throw ZeroValue ( "void TDTtable::removeSemiHomo (VectorOfParentalHaplotypes* parentalHaplotypesList)" );
							}
						}
					}
				}
			}
// cout <<"final is:" << *this <<"\n";
// exit(0);
		}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from  void TDTtable::removeSemiHomo (VectorOfParentalHaplotypes* parentalHaplotypesList)" ); throw;};
	}

	/*_____________________________________________________________*/


	double TDTtable::getTotalTransmissionCount ( Transmission trans )
	{
		double result=0;
		for ( int i=0; i<getYDim(); i++ )
			switch ( trans )
			{
			case t: case u: result+=getValue ( trans-1,i ); break;
				case ut: result+=getValue ( 0,i ) +getValue ( 1,i ); break;
			}
		return result;
	}

	/*_____________________________________________________________*/


	double TDTtable::getTotalHeteroGenotypes()
	{
		return getTotalTransmissionCount ( ut ) / ( double ) 2;
	}

	/*_____________________________________________________________*/


	double TDTtable::getTotalHomoGenotypes()
	{
		return ( getTotalCounts()-getTotalTransmissionCount ( ut ) ) /2;
	}



	/*_____________________________________________________________*/


	doubleList* TDTtable::getCounts ( Transmission trans )
	{
		doubleList* results=new doubleList();
		for ( int i=0; i<getYDim(); i++ )
			switch ( trans )
			{
			case t: case u: results->insertElement ( getValue ( trans-1,i ) );break;
				case ut: results->insertElement ( getValue ( 0,i ) +getValue ( 1,i ) ); break;
			}
		return results;
	}

	/*_____________________________________________________________*/


	doubleList* TDTtable::getHomoCounts ()
	{
		doubleList* results=new doubleList();
		for ( int i=0; i<getYDim(); i++ )
    results->insertElement ( getValue ( 2,i ) );
		return results;
	}



	/*_____________________________________________________________*/

	/*
		double TDTtable::getPVal()
	  {
	cout <<"dinn\n";
	cout <<"st:" << getStatistic() <<"\n";
	  return pdfTestChiSquare(getStatistic(),getYDim()-1);
	  }

	/*_____________________________________________________________*/

	/*
		double TDTtable::getWeightedPVal(doubleList* weights)
	  {
	  double result=pdfTestWeightedChiSquareTDT(getWeightedStatistic(weights), weights);
	  return result;
	  }
	*/



	ostream& operator<< ( ostream& out, TDTtable& l )
	{
//cout <<"totaldims:" << l.getYDim();
		if ( l.partition!=NULL )
		{
			out << "\t" << *l.partition <<"\n";
			for ( int i=0; i<=l.getYDim();i++ )
				out <<"___\t";
			out <<"\n";
			for ( int tr=0; tr<3; tr++ )
			{
				if ( tr==0 ) out << "T:\t"; else if ( tr==1 ) out << "U: \t"; else out <<"H:\t";
				for ( int i=0; i<l.getYDim();i++ )
				{
					out << l.getValue ( tr,i );
					if ( i< ( l.getYDim()-1 ) ) out <<"\t"; else out <<"\n";
				}
			}
		}
		return out;
	}
	

	/*_____________________________________________________________*/

	int TDTtable::findColumn(Haplotype *h)
	{
// it returns the column position of the set of haplotypes where the haplotype h belongs to. -1 if not present

return partition->getPosition(partition->findElementContainingInternalElement (h));
	}
	
	/*_____________________________________________________________*/
	
	void TDTtable::copyFrequenciesTo(PartitionHaplotypeTUCountsVector * p)
	{
	  HaplotypeTUCountsVector* hv;
	  HaplotypeTUCounts* hc;
	  
	  
	  // for each haplotype in p 
	  for ( PartitionHaplotypeTUCountsVector::iterator it=p->begin(); it<p->end(); it++ )
	  {
		 hv=p->getElement ( it );
		 for ( HaplotypeTUCountsVector::iterator it2=hv->begin(); it2<hv->end(); it2++ )
		 {
			hc=hv->getElement ( it2 ); // <<- haplotype
			
			// Find haplotype in this 
			int column = findColumn( hc->getHaplotype() );
			
			// copy frequencies 
			if ( column != -1){
			  hc->frequencyT = getValue ( 0, column );
			  hc->frequencyU = getValue ( 1, column );
			  hc->frequencyHomo = getValue ( 2, column );
			}
			
		 }
		 
	  }
		
	  
	}

/*_____________________________________________________________*/

	void TDTtable::print()
	{
		cout << *this ;
	}

};

#endif
