#ifndef __TDTtable_h__
#define __TDTtable_h__

namespace BIOS {
	
  /**
     @memo TDTtable
     @doc
     Definition:
	Table to store T/U frecuencies for the TDT algorithm

     @author Jose Moreno
     @version 1.0
	
	*/	


class VectorOfParentalHaplotypes;
// typedef SingleAncestorGraph<DirectedArc, HaplotypeTUCounts*, void> TreeOfHaplotypeTUCounts;

	class TDTtable: public BidimensionalTable<double>{
    
  
  private:
  
  double minFreq;
  
  bool HWE;

		public:
		//! Vector of vector of haplotypes from which the table was created
		PartitionAsSetSampleOfHaplotypes * partition;


		/**
		*	Constructor
		*/		
		TDTtable(int cols, double minFreq=0, bool HWE=false);

		/**
		*	Destructor
		*/		
		~TDTtable();

    static TDTtable* fromString(string s){throw NonImplemented("static TDTtable* fromString(string s)");};

		/**
		*	Constructor from a partition
		* 	Creates a table from the T/U data in a partition
		*	The number of columns in the table will be the number of subsets in p.
		*	The number of rows will be tow. The first for the Transmitted haplotypes. The second for the Non transmitted.
		*	@param p Partition from which to fill the table
		*/		
		TDTtable(PartitionHaplotypeTUCountsVector* hapCounts, double minFreq=0, bool HWE=false);
		
		TDTtable(const TDTtable& other);

 		/**
		*	Constructor from a partition
		* 	Creates a table from the T/U data in a vector of haplotypes.
    * It creates a partition with one haplotype at each haplotypeVector in the partition
		*	The number of columns in the table will be the number of haplotypes in the vextor.
		*	The number of rows will be two. The first for the Transmitted haplotypes. The second for the Non transmitted.
		*	@param p HaplotypVector from which to fill the table
		*/		
		TDTtable(HaplotypeTUCountsVector* hapCounts, int* positions=NULL, int length=-1, double minFreq=0, bool HWE=false);

  TDTtable* clone();

  TDTtable* getFilteredTable();

  void filter();
		/**
		*	Fills the table based on the given partition.
		*	The table must have the same columns as the number of subsets in the partition 
		*	@param p Partition from which to fill the table
		*
		*/
		void Fill(PartitionHaplotypeTUCountsVector * p=NULL);
		
		/**
		* Modifies the partition given.
		* The frequencies for each haplotype in the partition will come from this table.
		*/
		void copyFrequenciesTo(PartitionHaplotypeTUCountsVector * p=NULL);
		
		/**
		* Find the column containing haplotype h
		* @param h haplotype to be found in this table.
		* @return column in the table. -1 if not found
		*/
		int findColumn(Haplotype *h);
		
	 /**
	 * Creates a tdttable from this and the given tree.
	 * Uses the best nodes of the tree to restrict the columns of this table.
	 * The nodes of the tree must be present in the table
	 * @param tree Tree of haplotypes used to restrict the columns in this table.
	 * @return A new table.
	 */
	 TDTtable * newFromTree(HaplotypeTUCountsTree *tree);		
// 	 TDTtable * newFromTree(TreeOfHaplotypeTUCounts *tree);		


  doubleList* getHapFreqs();
  
  void update(VectorOfParentalHaplotypes* parentalHaplotypesList, bool useDistances=true, bool treeDT=false, int position=0, bool toLeft=false);
  
//	void update(HaplotypeTUCountsVector* hapCounts, int iniPos, int length, bool left);

  double getStatistic(bool HWE=false);

	
  /**
   * Statistic for TreeDT
   * @return 
   */
  double getStatisticZ();
  double getStatisticZforColumn(int i);

  double getWeightedStatistic(doubleList* weights);

//  double getPVal();

//  double getWeightedPVal(doubleList* weights);

  doubleList* getCounts(Transmission transmission);

	doubleList* getHomoCounts ();

double getTotalHomoGenotypes();

double getTotalHeteroGenotypes();

 double getHomoHapCount (int hapPos);


	double getTotalTransmissionCount(Transmission trans);

	double getHeteroHapCount(int hapPos, Transmission trans=ut);
	
	void removeSemiHomo(VectorOfParentalHaplotypes* parentalHaplotypesList);


	
void print();

bool operator==(TDTtable& other) {throw NonImplemented("TDTtable::operator==(TDTtable& other)");};


	};
	
	


ostream& operator<<(ostream& out, TDTtable& l);



};

#endif
