/* File: PhylogeneticDistance.h */

#ifndef __TUCounts_h__
#define __TUCounts_h__

//using namespace stats;

namespace BIOS {


/************************/
/* SNP'S MultimarkerMeasure DEFINITION */
/************************/


/**
        @memo TUCounters for a given window in a TrioSample

	@doc
        Definition:

       Class used mainly to compute multimarker TU measures. In order to similarity measures to can be applied, haplotype counters (or freqs if EM-freq is used) for each couple must be independently kept 

       With this purpose, the data structures required is:
 
       Container<vector, ParentalHaplotypes> *parentalHaps   

        @author Maria M. Abad
	@version 1.0
*/


 
class	TUCounts: public GenericCounts {

private:

HapExtractionConfiguration* hapExtractionConfiguration;//how haps were extracted from genotytpes
//TrioCounters* trioCounters; // genotype counters, required to compute permutations
VectorOfParentalGenotypes* parentalGenotypes; // genotype counters, required to compute permutations
TUCounts** permutations;

//int totalPos; // total used positions (-1 if all positions from parentalGenotypes are used)
int* pos; // used positions (NULL if all positions from parentalGenotypes are used)

public:
  int totalPermutations;

HaplotypeTUCountsVector* haplotypeTUCountsVector; 

// ***** FOR treedtmeasure
//! Vector of haplotypes vector with repetitions and freq=1 per haplotype
HaplotypeTUCountsVector* expandedHaplotypeVector;

//! Copy used for permutations
HaplotypeTUCountsVector* copyHaplotypeTUCountsVector;

//! to keep track of the inner nodes created 
vector<HaplotypeTUCounts *> treeEmtpyNodes;
		
// *** end treedtmeasure
		
VectorOfParentalHaplotypes* parentalHaplotypesList; // used for some algorithms that require to know the combination of haplotypes that each family has



/*********************************************************************/
/***     ASSOCIATED FUNCTIONS     ***/
/*********************************************************************/

private:


//void set(SNPPos Pos[], SNPPos totalPos, TrioSample * samp, HapExtractionConfiguration* hapExtractionConfiguration, int totalPermutations);  



      public:

TUCounts();

//	TUCounts(SNPPos Pos[], SNPPos totalPos, TrioSample * samp, AlleleOrderType alleleOrderType=LeftRight, PhaseAlg=weighted, EMDistributions emDistributions=UTDistributions, EMRestriction emRestriction=triosBasedRestriction, int totalPermutations=100);

TUCounts(VectorOfParentalGenotypes* parentalGenotypes, HapExtractionConfiguration* hapExtractionConfiguration, HaplotypeTUCountsVector* haplotypeTUCountsVector, VectorOfParentalHaplotypes* parentalHaplotypesList, int totalPermutations=100);
TUCounts* filter(int pos, int length);

//TUCounts(char* filename, HapExtractionConfiguration* hapExtractionConfiguration, int totalPermutations);
	
 TUCounts(TUCounts& source);
 
 int getTotalPos();

int* getPositions();
 
 //TUCounts(char*filename);

 virtual TUCounts* clone();

virtual ~TUCounts();

virtual void empty();

HapExtractionConfiguration* getHapExtractionConfiguration();

//TrioCounters* getTrioCounters();

VectorOfParentalGenotypes* getParentalGenotypes();

void setPermutations();
 
int getTotalPermutations();

TUCounts** getPermutations();

TUCounts* filter(int *relativePositions, int size);


/**
 * Creates a new TUCounts with the left half positions, inverting the order.
 * For example, given a TUCounts with haplotypeTUCountsVector of 10 positions {0,1,...,9}
 * the returned haplotypeTUCountsVector will have positions {4,3,2,1,0}
 * @return The new created TUCounts
 */
TUCounts* filterLeftHalf();

/**
 * Creates a new TUCounts with the right half positions.
 * For example, given a TUCounts with haplotypeTUCountsVector of 10 positions {0,1,...,9}
 * the returned haplotypeTUCountsVector will have positions {5,6,7,8,9}
 * @return The new created TUCounts
 */
TUCounts* filterRightHalf();



//virtual bool isEmpty();

/*____________________*/

/* MEASURES */
/*
TDTMeasure* getTDTMeasure(double minFreq=10, bool permutations=false);
G2Measure* getG2Measure(double minFreq=10);
//TDT1TMeasure * getTDT1TMeasure(double minFreq=10);
//TDT1UMeasure* getTDT1UMeasure(double minFreq=10);
TDTPMeasure* getTDTPMeasure(bool permutations=false);
YateTDTMeasure* getYateTDTMeasure(double alpha, bool basicYate);
LaplaceTDTMeasure* getLaplaceTDTMeasure(double alpha);
EntropyTDTMeasure* getEntropyTDTMeasure(double minFreq=10, bool permutations=false);
LengthContrastMeasure* getLengthContrastMeasure();
SignedRankMeasure* getSignedRankMeasure();
ScoreTDTMeasure* getScoreTDTMeasure(double minFreq=10, bool HWE=false);
HWEMeasure* getHWEMeasure(double minFreq=10, bool permutations=false);
	/**
	*	Calculates the p-value of the sample set as the minimum p_k. 
	*	A p_k value is calculated for each k.
	*	@param maxK Maximum level k
	*/

//	TDTbranchMeasure* getTDTbranchMeasure(int k,  int side=0, double minFreq=10);

virtual void print(ostream&);

};  // End of class TUCounts








};  // End of Namespace

#endif

/* End of file: MultimarkerMeasure.h */




