#ifndef __Chi2TDTMeasure_cpp__
#define __Chi2TDTMeasure_cpp__




namespace BIOS {



		Chi2TDTMeasure::Chi2TDTMeasure(TUCounts* tuCounts, double minFreq, bool permutations, bool left):SimpleTUMeasure(tuCounts, minFreq, permutations, left)
{
try
{
tdtTable=NULL;
//if (tuCounts!=NULL && tuCounts->haplotypeTUCountsVector->size()==0)
//throw BadFormat("Chi2TDTMeasure::Chi2TDTMeasure(TUCounts* tuCounts, double minFreq, bool permutations, bool left)");
if (tuCounts!=NULL && tuCounts->haplotypeTUCountsVector->size()>0)
{
			tdtTable=new TDTtable(tuCounts->haplotypeTUCountsVector, NULL, 0, minFreq);
if (tdtTable==NULL || tdtTable->partition==NULL || tdtTable->getTotalHeteroGenotypes()==0)
zap(tdtTable);
}
}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from Chi2TDTMeasure::Chi2TDTMeasure(TUCounts* tuCounts, double minFreq..." ); throw;};
		};

/*_________________________________________________________________*/

		Chi2TDTMeasure::Chi2TDTMeasure(double minFreq, bool permutations, bool left):SimpleTUMeasure(minFreq, permutations)
{
tdtTable=NULL;
this->minFreq=minFreq;
if (permutations) this->minFreq=0;
tdtTable=NULL;
};
/*___________________________________________________________________________________*/

/*
Chi2TDTMeasure*	Chi2TDTMeasure::getNewMeasure(TUCounts* tuCounts, int iniPos, int length)
{
Chi2TDTMeasure* result=(Chi2TDTMeasure*)this->clone();
result->tdtTable->update(tuCounts->haplotypeTUCountsVector, iniPos, length);
}
/*___________________________________________________________________________________*/


Chi2TDTMeasure*	Chi2TDTMeasure::inferMeasure(TUCounts* tuCounts)
{
if (tuCounts==NULL) 
throw NullValue("Chi2TDTMeasure*	Chi2TDTMeasure::inferMeasure(TUCounts* tuCounts)");


//if (tdtTable==NULL) throw NullValue("Chi2TDTMeasure::inferMeasure(TUCounts* tuCounts)");
Chi2TDTMeasure* result=(Chi2TDTMeasure*)this->clone();
//zap(result->tuCounts);
//cout <<"current:\n";
//cout << *this <<"\n";
//cout << *this->tuCounts->haplotypeTUCountsVector <<"\n";
if (result->tdtTable!=NULL) 
{
result->tdtTable->update(tuCounts->parentalHaplotypesList);
//cout <<"afterudating:\n";
//cout << *result <<"\n";
if (result->tdtTable!=NULL && result->tdtTable->partition==NULL) zap(result->tdtTable);
}
result->tuCounts = tuCounts;
//cout << *tuCounts->haplotypeTUCountsVector <<"\n";
//cout <<"new:\n" << *result;

// TUCounts* other=tuCounts->clone();
// zap(other);

return result;
}
/*_________________________________________________________________*/
/*

		Chi2TDTMeasure::Chi2TDTMeasure(bool permutations):TUMeasure(permutations){
    minFreq=0;
		};
		
		/*_________________________________________________________________*/

		Chi2TDTMeasure::Chi2TDTMeasure(Chi2TDTMeasure& other):SimpleTUMeasure(other){
    minFreq=other.minFreq;
    if (other.tdtTable==NULL) tdtTable=NULL;
    else tdtTable=new TDTtable(*other.tdtTable);
		};


/*_________________________________________________________________*/

		Chi2TDTMeasure::~Chi2TDTMeasure(){
  zap(tdtTable);
		};

/*_________________________________________________________________*/
/*
		Chi2TDTMeasure* Chi2TDTMeasure::clone(){
  return new Chi2TDTMeasure(*this);
		};
/*________________________________________________________________________________*/



		double Chi2TDTMeasure::getStatistic()
		{
  if (tdtTable!=NULL)
    return tdtTable->getStatistic();
  else return 0;
		};

/*_____________________________________________________________________________________________________________*/



		TDTtable* Chi2TDTMeasure::getTDTtable()
		{
  return tdtTable;
		};


/*_____________________________________________________________*/

		double Chi2TDTMeasure::getWeightedStatistic(doubleList* weights)
		{
  if (tdtTable==NULL) return 0;
		return tdtTable->getWeightedStatistic(weights);
		};


/*_____________________________________________________________*/
/*
	double Chi2TDTMeasure::getWeightedPVal(doubleList* weights,bool chi2)
  {
  if (chi2) return pdfTestWeightedChiSquareTDT(getStatistic(weights), weights);  
  else return getPValWithPermutations();
  }


/*_____________________________________________________________*/
/*
double Chi2TDTMeasure::getPValWithPermutations()
{
return TUMeasure::getPVal();
}

/*_____________________________________________________________*/

double Chi2TDTMeasure::getPVal()
{
try
{
double result;
if (tdtTable==NULL) return 1;
if (permutations) return SimpleTUMeasure::getPVal();
result=pdfTestChiSquare(getStatistic(),tdtTable->getYDim()-1);
if (isNAN(result)) 
{
cout << *tdtTable <<"\n";
cout <<"totalheteros:" << tdtTable->getTotalHeteroGenotypes()<<"\n";
cout << "statistic is: " << getStatistic();
throw NanValue(" Chi2TDTMeasure::getPVal()");
}
return result;
}
catch (BasicException& be) {be.addMessage ("\ncalled from Chi2TDTMeasure::getPVal()"); throw;};
}

/*_____________________________________________________________*/

doubleList* Chi2TDTMeasure::getHapFreqs()
{
if (tdtTable==NULL) return NULL;
return tdtTable->getHapFreqs();
}

/*_____________________________________________________________*/

stringList*  Chi2TDTMeasure::getHeadFile()
 {

stringList *result=new stringList();
result->insertElement(string("Pos: pVal Haplotypes: // T: Counts for T // U: Counts for U"));
return result;
};

/*_________________________________________________________________________________________________*/

		void Chi2TDTMeasure::print(ostream& out)
{
try
{
doubleList* tl, *ul, *homol;
if (tdtTable!=NULL && tdtTable->partition!=NULL)
{
//cout <<*tdtTable;
//cout <<"--------------";
tdtTable->partition->setDelimiters('\0', '\n');
tdtTable->partition->setOutputSeparator('\0');
tdtTable->partition->setOutputSeparatorForInternalContainers(' ');
tdtTable->partition->setDelimitersForInternalContainers('\0', ' ');
if (tuCounts==NULL) throw NullValue("Chi2TDTMeasure::print(ostream& out)A");
if (tuCounts->getParentalGenotypes()==NULL) throw NullValue("Chi2TDTMeasure::print(ostream& out)");
if (tuCounts->getParentalGenotypes()->getPositions()==NULL) throw NullValue("Chi2TDTMeasure::print(ostream& out)C");
if (tuCounts->getPositions()==NULL) throw NullValue("Chi2TDTMeasure::print(ostream& out)-2");
out << tuCounts->getParentalGenotypes()->getPositions()[tuCounts->getPositions()[0]] <<": ";
out << getPVal();
out << " Haplotypes: " << *tdtTable->partition;
tl=tdtTable->getCounts(t);
ul=tdtTable->getCounts(u);
homol=tdtTable->getHomoCounts();
out <<"T: " << *tl <<"U: " << *ul <<"H: " << *homol;
 zap(ul);zap(tl); zap(homol);
}
else out <<"null tdt table\n\n\n";
}
catch (BasicException& be){be.addMessage("\ncalled from Chi2TDTMeasure::print(ostream& out)"); throw;};
		};

/*_____________________________________________________________*/




};

#endif
