#ifndef __G2Measure_cpp__
#define __G2Measure_cpp__




/*_____________________________________________________________*/

void print ( BIOS::G2Measure *t )
{
	cout << *t << endl;
}


/*_____________________________________________________________*/


namespace BIOS
{

	G2Measure::G2Measure ( TUCounts* tuCounts, double minFreq, int testMode, TUCounts** partialTuCountsTraning, TUCounts** partialTuCountsTest, bool useDistances ) :GroupBasedTDTMeasure ( tuCounts, minFreq, testMode, partialTuCountsTraning, partialTuCountsTest, false, useDistances )
	{
		try
		{
			totalMultipleTest=0;
			if ( testMode==-1 && tdtTable!=NULL && tdtTable->partition!=NULL ) totalMultipleTest=std::pow ( 2, ( double ) tdtTable->partition->size()-1 )-1;
			setAll();
		}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from G2Measure::G2Measure(TUCounts* tuCounts, double minFreq, bool left)" ); throw;};
	};

	/*_____________________________________________________________*/

	TDTtable* G2Measure::set ( TUCounts* aTUCounts )
	{
// It creates and return a new TDTtable with only two columns, one for each group in 2G algorithm
		try
		{
			TDTtable* result=NULL;
			if ( aTUCounts==NULL ) return NULL;
			PartitionHaplotypeTUCountsVector* p=new PartitionHaplotypeTUCountsVector();
			p->insertElement ( new HaplotypeTUCountsVector() );
			p->insertElement ( new HaplotypeTUCountsVector() );
			double sumT1=0, sumT2=0, sumU1=0, sumU2=0;
			HaplotypeTUCounts* h;
			for ( HaplotypeTUCountsVector::iterator it=aTUCounts->haplotypeTUCountsVector->begin(); it!=aTUCounts->haplotypeTUCountsVector->end();it++ )
			{
// for each haplotypeTUCounts
				h=aTUCounts->haplotypeTUCountsVector->getElement ( it );
    if (h!=NULL && !h->getHaplotype()->hasAMissingPosition())
				if ( ( ( h->frequencyT+h->frequencyU ) ) >=minFreq )
				{
					if ( h->frequencyT>h->frequencyU ) p->getElement ( 0 )->insertHardElement ( h );
					if ( h->frequencyT<h->frequencyU ) p->getElement ( 1 )->insertHardElement ( h );
					//if ( h->frequencyT==h->frequencyU ) p->getElement ( rand() %2 )->insertHardElement ( h );
				}
			}
			if ( p->getElement ( 0 )->size() >0 && p->getElement ( 1 )->size() >0 )
				result=new TDTtable ( p );
			zap ( p );
			return result;
		}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from G2Measure::set()" ); throw;};
	}

	/*_____________________________________________________________*/

	G2Measure::G2Measure ( double minFreq, int testMode, bool useDistances ) :GroupBasedTDTMeasure ( minFreq, testMode, false, useDistances )
	{
		totalMultipleTest=0;
	}


	/*_____________________________________________________________*/

	G2Measure::G2Measure ( G2Measure& other ) :GroupBasedTDTMeasure ( other )
	{
		totalMultipleTest=other.totalMultipleTest;
	}

	/*________________________________________________________________________________*/
	/*
			double G2Measure::getStatistic()
			{
			return Chi2TDTMeasure::getStatistic()/2;
			}
			/*
			double sum;
			if (tdtTable==NULL)
			{
			//cout <<"nulltable\n";
			return 0;
			}
			if (tdtTable->getYDim()!=2)
			{
			cout <<" table 2G is:" << *tdtTable <<"\n";
			throw BadFormat("double G2Measure::getStatistic()");
			}
			sum=std::pow(tdtTable->getValue(0,0)-tdtTable->getValue(1,0),2);
		 sum=sum/min(tdtTable->getHeteroHapCount (0, ut), tdtTable->getHeteroHapCount(1, ut));
		 if (tuCounts->getTotalPos()==1 && Chi2TDTMeasure::getStatistic()!=sum)
		 {
		 	 		cout <<" table 2G is:" << *tdtTable <<"\n";
		 	 		cout <<" statistic is: " << sum <<"\n";
		 	 		cout <<" while statistic for Chi2 is:" << Chi2TDTMeasure::getStatistic() <<"\n";
		 	 throw BadFormat("	double G2Measure::getStatistic()");
		 }
				};

	/*_________________________________________________________________*/

	G2Measure* G2Measure::getNewMeasure ( TUCounts* tuCounts, TUCounts** training, TUCounts** test )
	{
		try
		{
			return new G2Measure ( tuCounts, minFreq, testMode, training, test, useDistances );
		}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from G2Measure* G2Measure::getNewMeasure(TUCounts* tuCounts, TUCounts** training, TUCounts** test)" ); throw;};
	}

	/*_________________________________________________________________*/
	/*
	  G2Measure* G2Measure::inferMeasure(TUCounts* tuCounts)
	{
	return new G2Measure(tuCounts, minFreq);
	}
	/*____________________________________________________________________________*/


	G2Measure::~G2Measure()
	{
	};

	/*____________________________________________________________________________*/


	G2Measure*	G2Measure::clone()
	{
		return new G2Measure ( *this );
	};

	/*____________________________________________________________________________*/

	string G2Measure::getName()
	{
		string result=string ( "mTDT2G" );
		if ( testMode==-1 ) result=result+string ( "_Bonferroni" );
		if ( testMode>=2 ) result=result+string ( "_cv" ) +tos ( testMode );
		if ( testMode==1 ) result=result+string ( "_holdout" );
		if ( useDistances ) result=result+string ( "_useDistances" );
		if ( minFreq!=0 ) result=result+string ( "_minFreq" ) +tos ( minFreq );
//if (permutations) result=result+string("_")+tos(tuCounts->getTotalPermutations())+string("permutations");
		return result;
	}
	/*_________________________________________________________________*/

	stringList*  G2Measure::getHeadFile()
	{
		stringList *result=new stringList();
		result->insertElement ( string ( "FirstSNP" ) );
		result->insertElement ( string ( "pVal " ) );
		result->insertElement ( string ( "TotalUsedDifferentHaplotypesInG1 // " ) );
		result->insertElement ( string ( "T/U G1 // " ) );
		result->insertElement ( string ( "TotalUsedDifferenteHaplotypesInG2 //" ) );
		result->insertElement ( string ( "T/U G2" ) );
		return result;
	};

	/*_____________________________________________________________*/

	
		double G2Measure::getOR()
	  {
	  try
	{
double result=0; 
if (partialTdtTables==NULL  || partialTdtTables->size()==0) return tdtTable->getValue ( 0,0 )/(double)tdtTable->getValue(1,0);
for (TDTtableVector::iterator it=partialTdtTables->begin(); it<partialTdtTables->end(); it++)
{
if (partialTdtTables->getElement(it)!=NULL)
result=result+partialTdtTables->getElement(it)->getValue(0,0)/(double)partialTdtTables->getElement(it)->getValue(1,0);
}
return result;
}
	catch (BasicException& be) {be.addMessage ("\ncalled from GroupBasedTDTMeasure::getPVal()"); throw;};

	  }


	/*____________________________________________________________________________________________*/

	bool G2Measure::getOneSide()
	{
		return false;
	}
	/*_____________________________________________________________________________________________________________*/


	void G2Measure::onePrint ( ostream& out, TUCounts* aTuCounts, TDTtable* aTDTtable )
	{
  if (aTuCounts==NULL || aTuCounts->getParentalGenotypes()==NULL)
  out << "no counts";
  else
  {
		out << aTuCounts->getParentalGenotypes()->getPositions() [aTuCounts->getPositions() [0]] <<"\t";
		if ( aTDTtable!=NULL )
		{
			for ( int i=1; i<3; i++ )
			{
				aTDTtable->partition->getElement ( i-1 )->setDelimiters ( '\0', '\0' );
//if (i==2) out <<"\n";
				out << getPVal() << "\t";
				out << "G" << i <<":\t" << *aTDTtable->partition->getElement ( i-1 );
				out <<"\tT:\t" << aTDTtable->getValue ( 0,i-1 ) << "\tU: \t" << aTDTtable->getValue ( 1,i-1 );
				if ( i==1 ) out <<"\t";
				aTDTtable->partition->getElement ( i-1 )->setDelimiters ( '[', ']' );
			}
		}
		else out <<"nullTable";
  }
	};

}
#endif
