#ifndef __G2Measure_h__
#define __G2Measure_h__

namespace BIOS {
	
  /**
     @memo G2Measure
     @doc
     Definition:
	Table to store T/U frecuencies for the TDT algorithm

     @author María del Mar Abad Grau
     @version 1.0
	
	*/	
class G2Measure: public GroupBasedTDTMeasure {

private:

void set();
    
		public:
	

		/**
		*	Constructor
		*/		
		G2Measure(TUCounts* tuCounts, double minFreq=10, int testMode=2, TUCounts** partialTuCountsTraining=NULL, TUCounts** partialTuCountsTest=NULL, bool useDistance=true);
		
		G2Measure(double minFreq, int testMode, bool useDistances=true);

				G2Measure(G2Measure& other);

		/**
		*	Destructor
		*/		
virtual		~G2Measure();

//void setAll();

	 virtual	TDTtable*  set(TUCounts* aTUCounts=NULL);

void set(TDTtable* aTDTtable);

G2Measure* clone();

virtual  bool getOneSide();

//virtual double getStatistic();

  virtual G2Measure* getNewMeasure(TUCounts* tuCounts, TUCounts** training=NULL, TUCounts** test=NULL);
  
  	//	virtual G2Measure* inferMeasure(TUCounts* tuCounts);

 // virtual G2Measure* getNewMeasure(HapExtractionConfiguration* hapExtractionConfiguration, double minFreq=0, bool useModel=true);

		/**
		*	Calculate statistic from the tables 
		*/

//virtual double getPVal();	
	
virtual stringList* getHeadFile();

virtual double getOR();

string getName();//{return string("mTDT2G");};

// stringList* getFreqsResults();

//friend ostream& operator<<(ostream& out, G2Measure& l);


void onePrint( ostream&, TUCounts* aTuCounts, TDTtable* aTDTtable);

	};




};

#endif
