#ifndef __GroupBasedTDTMeasure_cpp__
#define __GroupBasedTDTMeasure_cpp__




namespace BIOS {



		GroupBasedTDTMeasure::GroupBasedTDTMeasure(TUCounts* tuCounts, double minFreq, int testMode, TUCounts** partialTuCountsTraining, TUCounts** partialTuCountsTest, bool permutations, bool useDistances):Chi2TDTMeasure(tuCounts, minFreq, permutations)
{
try
{
totalMultipleTest=0;
this->testMode=testMode;
this->partialTuCountsTraining=partialTuCountsTraining;
this->partialTuCountsTest=partialTuCountsTest;
this->useDistances=useDistances;
partialTdtTables=NULL;
partialTrainingTdtTables=NULL;
totalUsedHaplotypes=0;
totalUsedDifferentHaplotypes=0;
if (tdtTable!=NULL) 
{
//cout << "initableis:" << *tdtTable <<"\n";
totalUsedHaplotypes=(int)tdtTable->getTotalTransmissionCount (ut);
totalUsedDifferentHaplotypes=tdtTable->getYDim();
}
}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from GroupBasedTDTMeasure::GroupBasedTDTMeasure(TUCounts* tuCounts, double minFreq..." ); throw;};
//parentalHaplotypesListAdhoc=NULL;
};

/*_________________________________________________________________*/

		GroupBasedTDTMeasure::GroupBasedTDTMeasure(double minFreq, int testMode, bool permutations, bool useDistances):Chi2TDTMeasure(minFreq, permutations)
{
totalMultipleTest=0;
totalUsedHaplotypes=0;
totalUsedDifferentHaplotypes=0;
this->testMode=testMode;
this->useDistances=useDistances;
partialTdtTables=NULL;
partialTrainingTdtTables=NULL;
partialTuCountsTraining=NULL;
partialTuCountsTest=NULL;
//parentalHaplotypesListAdhoc=NULL;
		};



		
		/*_________________________________________________________________*/

		GroupBasedTDTMeasure::GroupBasedTDTMeasure(GroupBasedTDTMeasure& other):Chi2TDTMeasure(other){
totalMultipleTest=other.totalMultipleTest;
testMode=other.testMode;
partialTuCountsTraining=other.partialTuCountsTraining;
partialTuCountsTest=other.partialTuCountsTest;
partialTdtTables=NULL;
totalUsedHaplotypes=other.totalUsedHaplotypes;
totalUsedDifferentHaplotypes=other.totalUsedDifferentHaplotypes;
this->useDistances=other.useDistances;
if (testMode>=1 && other.partialTrainingTdtTables!=NULL)
 partialTrainingTdtTables=other.partialTrainingTdtTables->clone();
if ( other.partialTrainingTdtTables == NULL)
  	this->partialTrainingTdtTables = NULL;
if (testMode>=1 && other.partialTdtTables!=NULL) 
partialTdtTables=other.partialTdtTables->clone();
	};


/*_________________________________________________________________*/

		GroupBasedTDTMeasure::~GroupBasedTDTMeasure(){
  //zap(tdtTable);
  if (testMode>=1) 
{
zap(partialTdtTables);
zap(partialTrainingTdtTables);
}
  //zap(parentalHaplotypesListAdhoc);
		};
		
		/*_________________________________________________________________*/

		void GroupBasedTDTMeasure::removeSemiHomo()
		{
		//.........
		try
		{
		if (tdtTable!=NULL && tuCounts!=NULL)
				tdtTable->removeSemiHomo(tuCounts->parentalHaplotypesList);
			}
  catch (BasicException& be) {be.addMessage ("\ncalled from void GroupBasedTDTMeasure::removeSemiHomo()2"); throw;};
		};

		
		/*_________________________________________________________________*/

		void GroupBasedTDTMeasure::setAll()
		{
		//.........
		try
		{
		TDTtable* aTdtTable, *aTrainingTdtTable=NULL;
zap(tdtTable);		
if (testMode<1) 
{
tdtTable=set(tuCounts);
removeSemiHomo();
return;
}
partialTdtTables=new TDTtableVector();
partialTrainingTdtTables=new TDTtableVector();
//parentalHaplotypesListAdhoc=new VectorOfParentalHaplotypes(tuCounts->parentalHaplotypesList->getPositions(), tuCounts->parentalHaplotypesList->getLength());
for (int i=0; i<testMode; i++)
{
if (partialTuCountsTraining[i]==NULL) throw NullValue("void GroupBasedTDTMeasure::setAll()");
//cout <<* partialTuCountsTraining[i] <<"\n";
aTdtTable=set(partialTuCountsTraining[i]);
if (aTdtTable!=NULL && (aTdtTable->getTotalTransmissionCount(ut)==0)) zap (aTdtTable);

if (partialTuCountsTest[i]==NULL) throw NullValue("void GroupBasedTDTMeasure::setAll()");
if (aTdtTable!=NULL) 
{
aTrainingTdtTable=aTdtTable->clone();
aTdtTable->update(partialTuCountsTest[i]->parentalHaplotypesList, useDistances);
if (aTdtTable!=NULL && (aTdtTable->getTotalTransmissionCount(ut)==0)) zap (aTdtTable);
if (aTdtTable!=NULL && aTdtTable->partition==NULL) 
{
zap(aTdtTable);
zap(aTrainingTdtTable);
}
}
if (aTdtTable!=NULL) 
{
partialTrainingTdtTables->insertElement(aTrainingTdtTable);
partialTdtTables->insertElement(aTdtTable);
}
//cout <<"BEE:\n" << *this <<"\n";
//cout <<"testmode is:" << testMode << "\n";
}
setFinal();
}
catch (BasicException& be) {be.addMessage ("\ncalled from void GroupBasedTDTMeasure::setAll()"); throw;};
};

		
		/*_________________________________________________________________*/

		void GroupBasedTDTMeasure::setFinal()
		{
		//.........
		try
		{
		
	//	cout <<"\nbemmmmfris: \n" << *this <<"\n";
		
		
		TDTtable* aTDTtable, *aTrainingTDTtable;
		if (partialTdtTables->size()==0) return;
tdtTable=new TDTtable(2);
Haplotype * h;
int position;


tdtTable->partition=new PartitionAsSetSampleOfHaplotypes();
for (int i=0; i< partialTdtTables->getElement(0)->partition->size(); i++)
 tdtTable->partition->insertElement(new HaplotypeSet());

for(int i=0;i<partialTdtTables->size(); i++)
{
if (partialTdtTables->size()!=partialTrainingTdtTables->size()) throw OutOfBounds(partialTdtTables->size(), partialTrainingTdtTables->size(), "void GroupBasedTDTMeasure::setFinal()");
aTDTtable=partialTdtTables->getElement(i);
aTrainingTDTtable=partialTrainingTdtTables->getElement(i);
//cout <<"partition is:" << *aTDTtable->partition <<", while clone is:" << *tdtTable->partition <<"\n";
for (PartitionAsSetSampleOfHaplotypes::iterator it=aTDTtable->partition->begin(); it!=aTDTtable->partition->end(); it++)
{
position=aTDTtable->partition->getPosition(it);

for (HaplotypeSet::iterator it2=aTDTtable->partition->getElement(it)->begin(); it2!=aTDTtable->partition->getElement(it)->end(); it2++)
{
h=aTDTtable->partition->getElement(it)->getElement(it2);
// add all haplotypes not already in the partition
if (tdtTable->partition->getElement(position)->findEqualElement(h)==tdtTable->partition->getElement(position)->end())
tdtTable->partition->getElement(position)->insertHardElement(h);
}
tdtTable->addValue(0,position, aTDTtable->getValue(0,position));
tdtTable->addValue(1,position, aTDTtable->getValue(1,position));
}tdtTable->addValue(2,position, aTDTtable->getValue(2,position));
}
}
catch (BasicException& be) {be.addMessage ("\ncalled from void GroupBasedTDTMeasure::setFinal()"); throw;};
};

/*_____________________________________________________________*/
/*
bool GroupBasedTDTMeasure::consistent(bool first, bool second)
{
if ((first && second) || !first && !second) return 1; else return 0;
}
/*_____________________________________________________________*/
/*
int GroupBasedTDTMeasure::consistent(bool first, bool second, bool third)
{
if ((consistent(first, second) && third) || !consistent(first, second) && !third) return 1; else return 0;
}

/*_____________________________________________________________*/


	double GroupBasedTDTMeasure::getPVal()
  {
  try
{
int minDF;
double result, totalOutcomes=0;
if (partialTdtTables==NULL || partialTdtTables->size()==0) return Chi2TDTMeasure::getPVal();
//if  (partialTdtTables->size()==2 && sumOfHalves) return getPValSumOfHalfNormal(getStatistic());
return pdfTestChiSquare(getStatistic(),partialTdtTables->size());

if (isNAN(result)) 
{
cout << *tdtTable <<"\n";
cout <<"totalheteros:" << tdtTable->getTotalHeteroGenotypes()<<"\n";
cout << "statistic is: " << getStatistic();
throw NanValue(" Chi2TDTMeasure::getPVal()");
}
return result;
}
catch (BasicException& be) {be.addMessage ("\ncalled from GroupBasedTDTMeasure::getPVal()"); throw;};

  }
/*_________________________________________________________________*/

  double GroupBasedTDTMeasure::getTotalMultipleTest()
  {
    return totalMultipleTest;
  };
  
  
/*_________________________________________________________________*/

  void GroupBasedTDTMeasure::print(ostream& out)
  {
//out << "\nFirstprintcommonall\n";
	onePrint(out, tuCounts, tdtTable);
//out << "\nand now the others\n";
//out << "there are " << partialTdtTables->size() << "tables\n";
	if (testMode>=1)
	for (int i=0; i<testMode; i++)
	{
	 out <<"\n";
  if (partialTdtTables!=NULL && partialTdtTables->size()>i)
	 onePrint(out, partialTuCountsTest[i], partialTdtTables->getElement(i));
  else 
{
if (tuCounts!=NULL) out << tuCounts->getParentalGenotypes()->getPositions() [tuCounts->getPositions() [0]]  << "\t1\t";
onePrint(out, NULL, NULL); 
}
	 }
  };

		/*_____________________________________________________________*/

/*
	double GroupBasedTDTMeasure::getPVal()
  {
  try
{
return Chi2TDTMeasure::getPVal();
}
catch (BasicException& be) {be.addMessage ("\ncalled from GroupBasedTDTMeasure::getPVal()"); throw;};

  }

		
/*_________________________________________________________________________________________________*/
		/*
double GroupBasedTDTMeasure::getStatistic()
{
return Chi2TDTMeasure::getStatistic();
}
/*_________________________________________________________________________________________________*/

double GroupBasedTDTMeasure::getStatistic()
{
double result=0;
if (partialTdtTables==NULL || partialTdtTables->size()==0) return Chi2TDTMeasure::getStatistic();
for (TDTtableVector::iterator it=partialTdtTables->begin(); it<partialTdtTables->end(); it++)
{
if (partialTdtTables->getElement(it)!=NULL)
result=result+partialTdtTables->getElement(it)->getStatistic();// using sum of chi squares 1 df
}
return result; //partialTdtTables->size();
}    
    /*_________________________________________________________________________________________________*/


/*_____________________________________________________________________________________________________________*/

/*
		ostream& GroupBasedTDTMeasure::print(ostream& out){
   out << *this;
   return out;
		};
/*_____________________________________________________________*/


};

#endif
