#ifndef __GroupBasedTDTMeasure_h__
#define __GroupBasedTDTMeasure_h__

namespace BIOS {
	
  /**
     @memo GroupBasedTDTMeasure
     @doc
     Definition:
	  Abstract class generalizing all Chi2-based TDT measures

     @author María del Mar Abad Grau
     @version 1.0
	
	*/	
class GroupBasedTDTMeasure: public Chi2TDTMeasure {
    

		public:
	
double totalMultipleTest;
int testMode;
TUCounts** partialTuCountsTraining, **partialTuCountsTest;
TDTtableVector* partialTdtTables, *partialTrainingTdtTables;
int totalUsedHaplotypes;
int totalUsedDifferentHaplotypes;
bool useDistances;

//VectorOfParentalHaplotypes* parentalHaplotypesListAdhoc;

		/**
		*	Constructor
		*/		
//		GroupBasedTDTMeasure(bool permutations=false);

		/**
		*	Destructor
		*/		
	virtual	~GroupBasedTDTMeasure();


		/**
		*	Constructor 
		*	@param tuCounts Hapcounts to be used
		*/		
		GroupBasedTDTMeasure(TUCounts* tuCounts, double minFreq=0, int testMode=2, TUCounts** partialTuCountsTraning=NULL, TUCounts** partialTuCountsTest=NULL, bool permutations=false, bool useDistances=true);


// testMode is 0 if usual testing (low specificity because of ad-hoc grouping)
// testMode is -1 when Bonferroni correction is used (low power because it is an overcorrection)
// testMode is = 1 when holdout is used
// testMode is > 1 when cross-validation with testMode folds is used

//		GroupBasedTDTMeasure(TUCounts* tuCounts, Transmission transmission=ut, double minFreq=0, bool left=true);

		GroupBasedTDTMeasure(double minFreq=0, int testMode=2, bool permutations=false, bool useDistances=true);
		
	 GroupBasedTDTMeasure(GroupBasedTDTMeasure& other);
	 
	 void removeSemiHomo();
	 
	 virtual	TDTtable*  set(TUCounts* aTUCounts=NULL)=0;
	 

	 void setFinal();
	 
	 void setAll();
	 
	 virtual void onePrint( ostream&, TUCounts* aTuCounts, TDTtable* aTDTtable)=0;
virtual double getPVal();	

 virtual double getTotalMultipleTest();
  //virtual GroupBasedTDTMeasure* getNewMeasure(TUCounts* tuCounts, int iniPos=0, int length=-1)=0;

	virtual double getStatistic();
//virtual GroupBasedTDTMeasure* clone();

		/**
		*	Calculate statistic from the tables 
		*/

 virtual void print( ostream&);

//bool consistent(bool first, bool second);

//int consistent(bool first, bool second, bool third);
//		void oneHapPrint(ostream& out);
//virtual ostream& print( ostream&);
 
//virtual stringList*  getHeadFile();


//friend ostream& operator<<(ostream& out, GroupBasedTDTMeasure& l);

};
/*{
out << (TUMeasure&)l <<"\n";

out << *l.getTDTtable() <<"\n";
}
*/

};

#endif
