#ifndef __LaplaceTDTMeasure_h__
#define __LaplaceTDTMeasure_h__

namespace BIOS {
	
  /**
     @memo LaplaceTDTMeasure
     @doc
     Definition:
	Table to store T/U frecuencies for the TDT algorithm

     @author María del Mar Abad Grau
     @version 1.0
	
	*/	
class LaplaceTDTMeasure: public Chi2TDTMeasure {

private:

double alpha;
    
		public:
	

		/**
		*	Constructor
		*/		
	//	LaplaceTDTMeasure();

		/**
		*	Destructor
		*/		
virtual		~LaplaceTDTMeasure();

LaplaceTDTMeasure* clone();

  virtual LaplaceTDTMeasure* getNewMeasure(TUCounts* tuCounts, TUCounts** training=NULL, TUCounts** test=NULL);

		/**
		*	Constructor 
		*	@param minFreq Min number of counts in an haplotype to be used
		*/		
		LaplaceTDTMeasure(TUCounts* tuCounts, double alpha=1, bool left=true);

		LaplaceTDTMeasure(double alpha, bool left=true);

 string getName();

		/**
		*	Calculate statistic from the tables 
		*/

virtual	double getStatistic();

//	double getPVal();


//static stringList*  getHeadFileTDTFreqs();

stringList* getFreqsResults();

//virtual ostream& print(ostream&);

//friend ostream& operator<<(ostream& out, LaplaceTDTMeasure& l);
	};




//out << (Chi2TDTMeasure&)l <<"\n";



};

#endif
