#ifndef __ScoreTDTMeasure_cpp__
#define __ScoreTDTMeasure_cpp__




/*_____________________________________________________________*/

void print(BIOS::ScoreTDTMeasure *t){
	cout << *t << endl;
}


/*_____________________________________________________________*/


namespace BIOS {		


ScoreTDTMeasure::ScoreTDTMeasure(TUCounts* tuCounts, bool HWE, double minFreq, bool left):Chi2TDTMeasure (tuCounts, minFreq, false, left)
{
try
{
//cout << *tuCounts->haplotypeTUCountsVector <<"\n";

//if (tdtTable!=NULL) cout <<"totaldis:" << tdtTable->getYDim() <<"\n";
//if (tdtTable!=NULL) cout <<"getYDim:" << tdtTable->getYDim() <<"\n";
//else cout <<"nulltable\n";
this->HWE=HWE;
//if (tdtTable!=NULL) cout <<"tutable is:" << *tdtTable <<"\n";
setMatrices();
}
catch (BasicException& be){be.addMessage("\ncalled from ScoreTDTMeasure::ScoreTDTMeasure(TUCounts* tuCounts, bool HWE, double minFreq, bool left):Chi2TDTMeasure (tuCounts, minFreq, false, left)"); throw;};
};
/*___________________________________________________________________________________*/


void ScoreTDTMeasure::setMatrices()

{
try
{
marginalDiscrepancies=NULL;
covMatrix=NULL;
invOfCovMatrix=NULL;
marginalDiscrepanciesTranspose=NULL;

if (tdtTable!=NULL && tdtTable->partition->size()==1) zap(tdtTable);
if (tuCounts==NULL || tdtTable==NULL ) return;
marginalDiscrepancies=new dv2d(tdtTable->getYDim(),1);//-1

for (int i=0; i<(tdtTable->getYDim());i++)//-1
marginalDiscrepancies->vec()[i][0]=(tdtTable->getValue(0,i)-tdtTable->getValue(1,i));
//cout <<"here4\n";
double cell, pi,pj;

covMatrix=new dv2d(tdtTable->getYDim(),tdtTable->getYDim());//-1,-1
for (int i=0; i<(tdtTable->getYDim());i++)//-1
{
//cout <<"i is: " << i <<"\n";
covMatrix->vec()[i][i]=tdtTable->getValue(0,i)+tdtTable->getValue(1,i);
for (int j=i+1; j<(tdtTable->getYDim());j++)//-1
{
//cout <<"j is: " << j <<"\n";
//cout <<"HWE is:" << HWE <<"\n";
//if (!HWE)//n_{ij}, which is N_{ij}+N_{ji}
{
cell=getGenotypeCount(tdtTable->partition->getElement(i)->getElement(0), tdtTable->partition->getElement(j)->getElement(0));
cell+=getGenotypeCount(tdtTable->partition->getElement(j)->getElement(0), tdtTable->partition->getElement(i)->getElement(0));
}
if (HWE)
{ // under HWE, n_{ij}, i.e. genotype {i/j} count is asymptotically 2 n p_iU p_jU, witn n being the total number of genotypes 
//pi=(tdtTable->getHeteroHapCount(i)+tdtTable->getValue(2,i))/(double) tdtTable->getTotalCounts();
//pj=(tdtTable->getHeteroHapCount(j)+tdtTable->getValue(2,j))/(double) tdtTable->getTotalCounts();
pi=(tdtTable->getHeteroHapCount(i,u)+tdtTable->getValue(2,i)/2)/(double)(tdtTable->getTotalCounts()/2);
pj=(tdtTable->getHeteroHapCount(j,u)+tdtTable->getValue(2,j)/2)/(double)(tdtTable->getTotalCounts()/2);
cell=cell-pi*pj*tdtTable->getTotalCounts();
//cout <<"pi:" << pi <<", pj:" << pj <<"\n";
}
//cell=tdtTable->getTotalTransmissionCount(ut)/(double)(tdtTable->getYDim()*(tdtTable->getYDim()-1));
//cell=0;
covMatrix->vec()[i][j]=-cell;
covMatrix->vec()[j][i]=-cell;
}
}
marginalDiscrepanciesTranspose=(marginalDiscrepancies->transpose()).clone();
//cout <<"covmatr:\n";
//cout <<*covMatrix <<"\n";
if (covMatrix->zeroInverse())
{
zap (marginalDiscrepancies);
zap (marginalDiscrepanciesTranspose);
zap(covMatrix);
}
else invOfCovMatrix=new dv2d(covMatrix->inv());
}
catch (BasicException& be){be.addMessage("\ncalled from ScoreTDTMeasure::setMatrices()"); throw;};
}
/*___________________________________________________________________________________*/



ScoreTDTMeasure::ScoreTDTMeasure(ScoreTDTMeasure& other):Chi2TDTMeasure (other)
{
this->HWE=other.HWE;
covMatrix=NULL;
invOfCovMatrix=NULL;
marginalDiscrepancies=NULL;
marginalDiscrepanciesTranspose=NULL;
if (other.covMatrix!=NULL) covMatrix=other.covMatrix->clone();
if (other.invOfCovMatrix!=NULL) invOfCovMatrix=other.invOfCovMatrix->clone();
if (other.marginalDiscrepancies!=NULL) marginalDiscrepancies=other.marginalDiscrepancies->clone();
if (other.marginalDiscrepanciesTranspose!=NULL) marginalDiscrepanciesTranspose=other.marginalDiscrepanciesTranspose->clone();
}

/*___________________________________________________________________________________*/



ScoreTDTMeasure::ScoreTDTMeasure(bool HWE, double minFreq, bool left):Chi2TDTMeasure (minFreq, false, left)
{
marginalDiscrepancies=NULL;
covMatrix=NULL;
invOfCovMatrix=NULL;
marginalDiscrepanciesTranspose=NULL;
this->HWE=HWE;
}

/*___________________________________________________________________________________*/


		ScoreTDTMeasure::~ScoreTDTMeasure(){
zap(marginalDiscrepancies);
zap(marginalDiscrepanciesTranspose);
zap(covMatrix);

			}
			
	/*___________________________________________________________________________________*/
 
 
 string ScoreTDTMeasure::getName()
 {
 string result=string("ScoreTDT");
 if (HWE) result+=string("-HWE");
 if (minFreq!=0) result=result+string("_minFreq")+tos(minFreq);
 return result;
 };
/*___________________________________________________________________________________*/


ScoreTDTMeasure*		ScoreTDTMeasure::clone(){
return new ScoreTDTMeasure(*this);
			}
/*___________________________________________________________________________________*/


ScoreTDTMeasure*		ScoreTDTMeasure::getNewMeasure(TUCounts* tuCounts, TUCounts** training, TUCounts** test){
try
{
return new ScoreTDTMeasure(tuCounts, this->HWE, minFreq);
}
catch (BasicException& be){be.addMessage("\ncalled from ScoreTDTMeasure::getNewMeasure(TUCounts* tuCounts)"); throw;};
			}
/*___________________________________________________________________________________*/


ScoreTDTMeasure* ScoreTDTMeasure::inferMeasure(TUCounts* tuCounts)
{
//if (tdtTable==NULL) throw NullValue("Chi2TDTMeasure::inferMeasure(TUCounts* tuCounts)");
try
{
ScoreTDTMeasure* result=this->clone();
result->tuCounts=tuCounts;
if (tdtTable!=NULL)
{
result->tdtTable->update(tuCounts->parentalHaplotypesList);
if (result->tdtTable->partition==NULL || result->tdtTable->getTotalHeteroGenotypes()==0) zap (result->tdtTable);

//if (tdtTable!=NULL) cout <<"totaldisifer:" << tdtTable->getYDim() <<"\n";



zap(result->marginalDiscrepancies);
//cout << "original covmatrix:" << *this->covMatrix <<"\n";
zap(result->covMatrix);
result->setMatrices();
}
return result;
}
catch (BasicException& be){be.addMessage("\ncalled from ScoreTDTMeasure::inferMeasure(TUCounts* tuCounts)"); throw;};
			}
			
			/*___________________________________________________________________________________*/


double ScoreTDTMeasure::getStatistic()
{
double result=0;
if (marginalDiscrepancies==NULL || marginalDiscrepanciesTranspose==NULL) return 0;
dv2d partialResult=*marginalDiscrepanciesTranspose**invOfCovMatrix;
dv2d finalResult=partialResult**marginalDiscrepancies;
if (finalResult.get_width()!=1 || finalResult.get_height()!=1)
{
cout <<"\nfinal results is: "  << finalResult;
cout <<"\nmarginaltranspose is: " << *marginalDiscrepanciesTranspose;
basicPrint(cout);
thisPrint(cout);
throw BadFormat("ScoreTDTMeasure::getStatistic()");
}
result=finalResult[0][0];
if (result<0 || isNAN(result)) result=0;
if (isNAN(result)) 
{
cout << *tdtTable <<"\n";
cout <<"covMatrix: " << *covMatrix <<"\n"; //<<", and invOfCovMatrix: " << *invOfCovMatrix <<"\n";
cout <<"totalheteros:" << tdtTable->getTotalHeteroGenotypes()<<"\n";
throw NanValue("ScoreTDTMeasure::getStatistic()");
}
//cout <<"the statistic value is: " << result;

return result;
}


/*_________________________________________________________________*/

		void ScoreTDTMeasure::basicPrint(ostream& out){

if (tdtTable!=NULL) out <<*tdtTable <<"\n";
}
/*_________________________________________________________________*/


		void ScoreTDTMeasure::Chi2Print(ostream& out){

 Chi2TDTMeasure::print(out);
 out  <<"\n";
}
/*_________________________________________________________________*/


		void ScoreTDTMeasure::thisPrint(ostream& out){

if (this->marginalDiscrepancies!=NULL)
{
out << "Marginal discrepancies:\n";
out << *this->marginalDiscrepancies <<"\n";
}
if (this->marginalDiscrepanciesTranspose!=NULL)
{
out << "Marginal discrepancies transpose:\n";
out << *this->marginalDiscrepanciesTranspose <<"\n";
}
else out <<"\n\n";
if (covMatrix!=NULL)
{
    out <<"Covariance matrix:\n";
out << *this->covMatrix <<"\n";
    out <<"Inv of covariance matrix:\n";
out << *this->invOfCovMatrix <<"\n";
		}
else out <<"\n\n\n\n";
}
/*_________________________________________________________________*/

		void ScoreTDTMeasure::print(ostream& out){
Chi2Print(out);
thisPrint(out);
}

/*_____________________________________________________________*/

/*
ostream& operator<<(ostream& out, ScoreTDTMeasure& l)
{
cout <<"GGGE\n";
out << (Chi2TDTMeasure&)l <<"\n";

out << *l.covMatrix <<"\n";
    
out << *l.marginalDiscrepancies <<"\n";

return out;
}
*/





};

#endif
