
#ifndef __ScoreTDTPMeasure_cpp__
#define __ScoreTDTPMeasure_cpp__




/*_____________________________________________________________*/

void print(BIOS::ScoreTDTPMeasure *t){
	cout << *t << endl;
}


/*_____________________________________________________________*/


namespace BIOS {		


ScoreTDTPMeasure::ScoreTDTPMeasure(TUCounts* tuCounts, bool HWE, double minFreq, bool left):ScoreTDTMeasure (tuCounts, HWE, minFreq, left)
{

weightsMatrix=NULL;
weights=NULL;
if (tuCounts==NULL || tdtTable==NULL ) return;
weightsMatrix=new dv2d(tdtTable->getYDim(),1);//-1
weights=tdtTable->getHapFreqs();
for (int i=0; i<(tdtTable->getYDim());i++)//-1
{
//marginalDiscrepancies->vec()[i][0]=marginalDiscrepancies->vec()[i][0]*sqrt(weights->getElement(i));
//marginalDiscrepanciesTranspose->vec()[0][i]=marginalDiscrepanciesTranspose->vec()[0][i]*sqrt(weights->getElement(i));
covMatrix->vec()[i][i]=covMatrix->vec()[i][i]/weights->getElement(i);
for (int j=i+1; j<(tdtTable->getYDim());j++)//-1
{
covMatrix->vec()[i][j]=covMatrix->vec()[i][j]/(sqrt(weights->getElement(i))*sqrt(weights->getElement(j)));
covMatrix->vec()[j][i]=covMatrix->vec()[j][i]/(sqrt(weights->getElement(i))*sqrt(weights->getElement(j)));
}
};
if (covMatrix->zeroInverse())
{
zap (marginalDiscrepancies);
zap (marginalDiscrepanciesTranspose);
zap(covMatrix);
}
else 
{
zap(invOfCovMatrix);
invOfCovMatrix=new dv2d(covMatrix->inv());
}


}

/*___________________________________________________________________________________*/



ScoreTDTPMeasure::ScoreTDTPMeasure(bool HWE, double minFreq, bool left):ScoreTDTMeasure (HWE, minFreq, left)
{
weightsMatrix=NULL;
weights=NULL;
}
/*_____________________________________________________________*/

	double ScoreTDTPMeasure::getPVal()
  {
  if (weights!=NULL)
  {
   if (tdtTable==NULL) throw NullValue("double TDTPMeasure::getPVal()");
//cout <<"the statistic value is: " << getStatistic() <<" and weights are: " << *weights;
  return pdfTestWeightedChiSquareTDT(getStatistic(), weights); 
  }
  else return 1;
  }

/*___________________________________________________________________________________*/



ScoreTDTPMeasure::ScoreTDTPMeasure(ScoreTDTPMeasure & other):ScoreTDTMeasure (other)
{
weightsMatrix=NULL;
weights=NULL;
if (other.weightsMatrix!=NULL) weightsMatrix=other.weightsMatrix->clone();
if (other.weights!=NULL) weights=other.weights->clone();
}

/*___________________________________________________________________________________*/


		ScoreTDTPMeasure::~ScoreTDTPMeasure(){
zap(weightsMatrix);
zap(weights);
			}
			
	/*___________________________________________________________________________________*/
 
 
 string ScoreTDTPMeasure::getName()
 {
 string result=string("ScoreTDTP");
 if (HWE) result+=string("-HWE");
 if (minFreq!=0) result=result+string("_minFreq")+tos(minFreq);
 return result;
 };
/*___________________________________________________________________________________*/


ScoreTDTPMeasure*		ScoreTDTPMeasure::clone(){
return new ScoreTDTPMeasure(*this);
			}

/*___________________________________________________________________________________*/


ScoreTDTPMeasure*		ScoreTDTPMeasure::getNewMeasure(TUCounts* tuCounts, TUCounts** training, TUCounts** test){
return new ScoreTDTPMeasure(tuCounts, this->HWE, minFreq);
			}

/*___________________________________________________________________________________*/


ScoreTDTPMeasure*		ScoreTDTPMeasure::inferMeasure(TUCounts* tuCounts){
throw NonImplemented(" ScoreTDTPMeasure::inferMeasure(TUCou...");
cout <<"have to think how to keep the model\n";
//return new ScoreTDTPMeasure(tuCounts, this->iniPos, this->length, this->HWE, minFreq);
			}
			
		


/*_________________________________________________________________*/
/*
		void ScoreTDTPMeasure::print(ostream& out){

ScoreTDTMeasure::print(out);
		};


/*_____________________________________________________________*/

/*
ostream& operator<<(ostream& out, ScoreTDTPMeasure& l)
{
cout <<"GGGE\n";
out << (Chi2TDTMeasure&)l <<"\n";

out << *l.covMatrix <<"\n";
    
out << *l.marginalDiscrepancies <<"\n";

return out;
}
*/





};

#endif
