#ifndef __ScoreTDTPMeasure_h__
#define __ScoreTDTPMeasure_h__

namespace BIOS {
	
  /**
     @memo ScoreTDTPMeasure
     @doc
     Definition:
	Table to store T/U frecuencies for the TDT algorithm

     @author María del Mar Abad Grau
     @version 1.0
	
	*/	
class ScoreTDTPMeasure: public ScoreTDTMeasure {
    
   dv2d* weightsMatrix;    

doubleList *weights;

		public:
	

		/**
		*	Constructor
		*/		
	//	ScoreTDTPMeasure();

		/**
		*	Destructor
		*/		
	virtual	~ScoreTDTPMeasure();

ScoreTDTPMeasure* clone();

		/**
		*	Constructor 
		*	@param minFreq Min number of counts in an haplotype to be used
		*/		
		ScoreTDTPMeasure(TUCounts* tuCounts, bool HWE=false, double minFreq=10, bool left=true);

		ScoreTDTPMeasure(bool HWE=false, double minFreq=10, bool left=true);

ScoreTDTPMeasure(ScoreTDTPMeasure & other);

// stringList* getFreqsResults();

		/**
		*	Calculate statistic from the tables 
		*/


ScoreTDTPMeasure* getNewMeasure(TUCounts* tuCounts, TUCounts** training=NULL, TUCounts** test=NULL);
ScoreTDTPMeasure* inferMeasure(TUCounts* tuCounts);

//virtual stringList*  getHeadFile();

virtual string getName();//{return string("mTDT");};

double getPVal();
//void print(ostream&);
//friend ostream& operator<<(ostream& out, ScoreTDTPMeasure& l);


	};





};

#endif
