#ifndef __SimpleTUMeasure_h__
#define __SimpleTUMeasure_h__

namespace BIOS {
	
  /**
     @memo SimpleTUMeasure
     @doc
     Definition:
	
An abstract class for measure computed from T/U counts of trio samples

     @author María Mar Abad Grau
     @version 1.0
	
	*/	
	
class HapExtractionConfiguration;

//class TUCounts;

class SimpleTUMeasure: public TUMeasure{

    

 
		public:
	

		/**
		*	Constructor
		*/		
	//	SimpleTUMeasure(bool permutations=false);

	SimpleTUMeasure(TUCounts* tuCounts, double minFreq=0, bool permutations=false, bool left=true);

	SimpleTUMeasure(double minFreq, bool permutations=false);

	SimpleTUMeasure();
	
		SimpleTUMeasure(SimpleTUMeasure& other);

double	getGenotypeCount(Haplotype*a, Haplotype*b);

		/**
		*	Destructor
		*/		
		virtual ~SimpleTUMeasure();

virtual SimpleTUMeasure* clone()=0;


  //	virtual SimpleTUMeasure* getNewMeasure(TUCounts* tuCounts, int iniPos=0, int length=-1)=0;
	

//  virtual MeasureResults* getResults();
  
 // virtual GenericCounts* getCounts(char* fileSample, int totalPermutations, int* pos, int size);


/**
		*	virtual methods to get pval of the measure.
		*	
		*/

		virtual double getStatistic()=0;

		virtual double getPVal();

//  virtual double getPValWithPermutations()=0;

 // virtual stringList* getFreqsResults()=0;

  virtual string getName()=0;

  virtual stringList* getHeadFile()=0;

  TUCounts* getTUCounts();

  SimpleTUMeasure* fromString(string s);

//friend ostream& operator<<(ostream& out, SimpleTUMeasure& l) {cout <<"isss\n"; return l.print(out); cout <<"after\n";};

virtual void print(ostream&)=0;

	};



/*
{

}
*/

};

#endif
