#ifndef __TDTbranchMeasure_h__
#define __TDTbranchMeasure_h__

namespace BIOS {
	
	/**
		@memo TDTbranchMeasure
		@doc
		Definition:

		TreeDT algorithm inspired in Sevon et al. "TreeDT: Tree Pattern Mining for Gene Mapping" (2006)

		@author Jose J. Moreno
		@version 1.0
	*/	
	


	class TDTbranchMeasure: public TUMeasure{

		int k;
		//TUCounts* tuCounts;
		//! haplotype vector
		HaplotypeTUCountsVector* v;
		int side;

		//virtual double getMinPVal(HaplotypeTUCountsVector *v, bool toLeft=false);

		public:
		//! Creates subtree of both sides
		const static int BOTH_SIDES=0;
		//! Only creates subtree of the right side
		const static int RIGHT_SIDE=1;
		//! Only creates subtree of the left side
		const static int LEFT_SIDE=2;

		/**
		*	Constructor
		*/		
		TDTbranchMeasure();

		/**
		*	Constructor
		*	@param maxK Maximum level k
		*/	

		TDTbranchMeasure(TUCounts* tuCounts, int k, int side=RIGHT_SIDE , double minFreq=10);

		/**
		*	Destructor
		*/		
		virtual ~TDTbranchMeasure();

		virtual TDTbranchMeasure* clone();


		/**
		*	virtual methods to get pval of the measure.
		*	
		*/

		virtual double getStatistic();

		/**
		*	Calculates the p-value of the sample set as the minimum p_k. 
		*	A p_k value is calculated for each k.
		*	@see getPvalueForK()
		*	@return p-value		
		*/

		virtual double getPVal();


		virtual string getName();

		virtual stringList* getHeadFile();

		virtual TDTbranchMeasure* getNewMeasure(TUCounts* tuCounts, TUCounts** training=NULL, TUCounts** test=NULL);

		TUCounts* getTUCounts();

		TDTbranchMeasure* fromString(string s);
		
virtual void print(ostream&);

		//friend ostream& operator<<(ostream& out, TDTbranchMeasure& l){};

	};



/*
{

}
*/

};

#endif
