#ifndef __TDTbranchSimpleMeasure_cpp__
#define __TDTbranchSimpleMeasure_cpp__





namespace BIOS {

	TDTbranchSimpleMeasure::TDTbranchSimpleMeasure(TDTbranchSimpleMeasure & other){
		this->k = other.k;
		this->useMaxK = useMaxK;
		this->tuCounts = other.tuCounts;
		if ( other.tdtTable != NULL )
			this->tdtTable = other.tdtTable->clone();
		else
			this->tdtTable = NULL;
	}


	TDTbranchSimpleMeasure::TDTbranchSimpleMeasure(TUCounts* tuCounts, int k, bool useMaxK, double minFreq):Chi2TDTMeasure()
	{

		this->k = k;
		this->useMaxK = useMaxK;
		//this->tuCounts = tuCounts;

		if ( tuCounts != NULL)
			setTUCounts(tuCounts);
		
	
	};

	void TDTbranchSimpleMeasure::setTUCounts(TUCounts* tuCounts)
	{
		double minPval=1.0, pVal;
		TDTtable * minTable=NULL;
		this->tuCounts = tuCounts;
		// Partition the vector of haplotypes given in tuCounts and create a TDTtable

		if (useMaxK){
			this->tdtTable = NULL;
			SetOfPartitions * partitions;

			int maxK=2;
			for(int k_i=2; k_i<=k; k_i++){
 				//cout << endl<< "Checking k..." << k_i << endl;
				partitions = SetOfPartitions::splitVector( tuCounts->haplotypeTUCountsVector, k_i);	
				if ( partitions->size()){
					minTable = partitions->getTDTtableForMinPval(k, pVal);
					if( pVal < minPval ){
						if( this->tdtTable != NULL)
							delete tdtTable;
						this->tdtTable = minTable->clone();
						minPval = pVal;
// 						cout << "pval updated to: " << minPval << endl;
						maxK=k_i;
					}
					delete minTable;					
				}
				delete partitions;
			}
			//cout << "  maxK = " << maxK << endl;

		}
		else{
			SetOfPartitions * partitions;
			partitions = SetOfPartitions::splitVector( tuCounts->haplotypeTUCountsVector, k);	
			if ( partitions->size() == 0)
				this->tdtTable = NULL;
			else
				this->tdtTable = partitions->getTDTtableForMinPval(k, minPval);		
			delete partitions;
		}
	};
/*
	double TDTbranchSimpleMeasure::getPVal()
	{
		double p, z;
		z = this->tdtTable->getStatistic();
		p = pdfTestChiSquare( z , k - 1);
		return p;
		
		
// 		double tdt_z,  tdt_p,  tdt_p_min;
// 		HaplotypeTUCountsVector* v = tuCounts->haplotypeTUCountsVector;
// 		
// 		SetOfPartitions * partitions;
// 		partitions = SetOfPartitions::splitVector( v, k);	
// 
// 		for (int p=0; p < partitions->size(); p++){	
// 
// 			TDTtable *t = new TDTtable( (*partitions)[p] ) ;
// 				tdt_z = t->getStatistic();
// 			delete t;
// 
// 			tdt_p = pdfTestChiSquare( tdt_z , k - 1); // Get p
// 
// 			if ( p==0)
// 				tdt_p_min = tdt_p;
// 
// 			if ( tdt_p < tdt_p_min)
// 				tdt_p_min = tdt_p;	
// 
// 		}
// 		
// 		//HaplotypeTUCountsVector::Delete(v);
// 		delete partitions;
// 
// 		return tdt_p_min;
		

	}
*/
/*
	double TDTbranchSimpleMeasure::getMinPVal( HaplotypeTUCountsVector *v , bool toLeft)
	{
		double tdt_z,  tdt_p,  tdt_p_min;

		SetOfPartitions * partitions;
		partitions = SetOfPartitions::splitVector( v, k, toLeft );		

		for (int p=0; p < partitions->size(); p++){
			TDTtable *t = new TDTtable( (*partitions)[p] ) ;
				tdt_z = t->getStatistic();
			delete t;

			tdt_p = pdfTestChiSquare( tdt_z , k - 1); // Get p

			if ( p==0)
				tdt_p_min = tdt_p;

			if ( tdt_p < tdt_p_min)
				tdt_p_min = tdt_p;	


		}

		delete partitions;

		return tdt_p_min;

	}

	double TDTbranchSimpleMeasure::getPVal()
	{
		double p_right, p_left;

		HaplotypeTUCountsVector *v_left, *v_right;

		//cout << *v << endl;
//		v->split(v_left, v_right, 5);
		v->chopInHalf( v_left, v_right );
		//cout << *v_left << endl;
		//cout << *v_right << endl;

		if ( side == BOTH_SIDES || side == RIGHT_SIDE){
			// Calcualte p value of the right side
			p_right = getMinPVal(v_right);
		}
	
		if ( side == BOTH_SIDES || side == LEFT_SIDE){
			// Calculate p value of the left side
			p_left = getMinPVal(v_left, true);
		}

		if ( side == BOTH_SIDES){
			// Return product of both sides 
			return p_right * p_left;
		}
		else{
			if ( side == RIGHT_SIDE){ 
				// return right side
				return p_right;
			}
			else{
				// return left side
				return p_left;
			}
		}
				

		HaplotypeTUCountsVector::Delete(v_left);
		HaplotypeTUCountsVector::Delete(v_right);
	
	}
*/

	string TDTbranchSimpleMeasure::getName(){
		if (useMaxK)
			return string("TDTBsimpleMK"  + tos(k) );
		else
			return string("TDTBsimple"  + tos(k) );
	};


/*_________________________________________________________________*/

  TDTbranchSimpleMeasure* TDTbranchSimpleMeasure::getNewMeasure(TUCounts* tuCounts, TUCounts** training, TUCounts** test)
{
// throw NonImplemented("TDTbranchSimpleMeasure::getNewMeasure");
	return new TDTbranchSimpleMeasure(tuCounts, k, useMaxK, minFreq);
}

//   TDTbranchSimpleMeasure* TDTbranchSimpleMeasure::inferMeasure(TUCounts* tuCounts)
//   {
//   };
  
/*_________________________________________________________________*/

		TDTbranchSimpleMeasure::TDTbranchSimpleMeasure()
{
		};
/*_________________________________________________________________*/

		TDTbranchSimpleMeasure::~TDTbranchSimpleMeasure(){
  //tuCounts=NULL;
		};
/*_________________________________________________________________*/

// 		double TDTbranchSimpleMeasure::getStatistic(){
// 			throw NonImplemented("TDTbranchSimpleMeasure::getStatistic()");
// 		};
/*_________________________________________________________________*/

		stringList* TDTbranchSimpleMeasure::getHeadFile(){
throw NonImplemented("TDTbranchSimpleMeasure::getHeadFile()");
		};
/*_________________________________________________________________*/

		TDTbranchSimpleMeasure* TDTbranchSimpleMeasure::clone(){
 			return new TDTbranchSimpleMeasure(*this);
		};

/*_________________________________________________________________*/




/*_________________________________________________________________*/

		TUCounts* TDTbranchSimpleMeasure::getTUCounts(){
  return tuCounts;
		};

/*_____________________________________________________________*/


		void TDTbranchSimpleMeasure::print(ostream& out){
 throw NonImplemented(" TDTbranchSimpleMeasure::print(ostream& out)");
		};

/*_____________________________________________________________*/

  TDTbranchSimpleMeasure* TDTbranchSimpleMeasure::fromString(string s){throw NonImplemented("TDTbranchSimpleMeasure::fromString(string s)");};


};

#endif
