#ifndef __TreeDTCompositeMeasure_h__
#define __TreeDTCompositeMeasure_h__

namespace BIOS {
	
	/**
		@memo TreeDTCompositeMeasure
		@doc
		Definition:

		TreeDT algorithm inspired in Sevon et al. "TreeDT: Tree Pattern Mining for Gene Mapping" (2006)

		@author Jose J. Moreno
		@version 1.0
	*/	
	


	class TreeDTCompositeMeasure: public CompositeTUMeasure{

		int k;
		//TUCounts* tuCounts;
		//! haplotype vector
		HaplotypeTUCountsVector* v;
		

		//virtual double getMinPVal(HaplotypeTUCountsVector *v, bool toLeft=false);

		public:
		/**
		*	Constructor
		*/		
		TreeDTCompositeMeasure();

		/**
		*	Constructor
		*	@param maxK Maximum level k
		*/	

		TreeDTCompositeMeasure(TUCounts* tuCounts, int k, double minFreq=10);

		/**
		*	Destructor
		*/		
		virtual ~TreeDTCompositeMeasure();

		virtual TreeDTCompositeMeasure* clone();

		

		/**
		*	virtual methods to get pval of the measure.
		*	
		*/

		virtual double getStatistic();

		/**
		*	Calculates the p-value of the sample set as the minimum p_k. 
		*	A p_k value is calculated for each k.
		*	@see getPvalueForK()
		*	@return p-value		
		*/

		//virtual double getPVal();


		virtual string getName();

		virtual stringList* getHeadFile();

		virtual TreeDTCompositeMeasure* getNewMeasure(TUCounts* tuCounts, TUCounts** training=NULL, TUCounts** test=NULL);

		TUCounts* getTUCounts();

		TreeDTCompositeMeasure* fromString(string s);
		
		virtual void print(ostream&);

		//friend ostream& operator<<(ostream& out, TreeDTCompositeMeasure& l){};

	};



/*
{

}
*/

};

#endif
