#ifndef __YateTDTMeasure_h__
#define __YateTDTMeasure_h__

namespace BIOS {
	
  /**
     @memo YateTDTMeasure
     @doc
     Definition:
	Table to store T/U frecuencies for the TDT algorithm

     @author María del Mar Abad Grau
     @version 1.0
	
	*/	
class YateTDTMeasure: public Chi2TDTMeasure {

  private:

  double alpha;

  bool basicYate;
    
		public:
	

		/**
		*	Constructor
		*/		
	//	YateTDTMeasure();

		/**
		*	Destructor
		*/		
		virtual ~YateTDTMeasure();


  virtual YateTDTMeasure* getNewMeasure(TUCounts* tuCounts, TUCounts** training=NULL, TUCounts** test=NULL);


		/**
		*	Constructor 
		*	@param minFreq Min number of counts in an haplotype to be used
		*/		
		YateTDTMeasure(TUCounts* tuCounts, double alpha=1, bool basicYate=true, bool left=true);

		YateTDTMeasure(double alpha, bool basicYate, bool left=true);

YateTDTMeasure* clone();

string getName();


		/**
		*	Calculate statistic from the tables 
		*/

virtual	double getStatistic();

	//double getPVal();


//static stringList*  getHeadFileTDTFreqs();

stringList* getFreqsResults();

//virtual ostream& print(ostream&);

	};


};

#endif
