
namespace BIOS {
/*
	double TreeDT::getPvalue(TrioCountersHapUAndT* TM, std::vector<RandomizationDistribution *> & rds)
	{
		double pValue;
		HaplotypeVector * pU, *pT, * pTU;

		pU = TM->getNonTransmittedHaplotypes() ; // Internal new made
		pT = TM->getTransmittedHaplotypes() ; // Internal new made

		pTU = new HaplotypeVector(*pU); // Make a full copy of pU (not only the pointers)
		pTU->insertClone(pT); // Inserts a clone of pT. A full copy not only the pointers.
	
		pValue = TreeDT::getPvalue(pTU,4, rds);

		pU->free();
		delete pU;
		pT->free();
		delete pT;
		pTU->free();
		delete pTU;	

		return pValue;
	};
*/
	double TreeDT::getPvalue(HaplotypeTUCountsVector* v, int maxK, std::vector<RandomizationDistribution *> & rds)
	{
		double pValue, minPValue;

		minPValue = pValue = TreeDT::getPvalueForK(v,1, rds);
		
		for(int k=2; k<=maxK; k++){
			pValue = TreeDT::getPvalueForK(v,k, rds);
			if (pValue < minPValue)
				minPValue = pValue;
		}

		return minPValue;
	};

	double TreeDT::getPvalueForK(HaplotypeTUCountsVector* v, int k, std::vector<RandomizationDistribution *> & rds)
	{
		return TreeDT::getPvalueForK(v,k,rds[k-1]);
/*
		double z;
		double p;

		z = TreeDT::getMaxZstatistic(v,k);

		// Use pdf to calculate p-value
		p = rds[k-1]->getPvalue(z);

		return p;
*/
	}

	double TreeDT::getPvalueForK(HaplotypeTUCountsVector* v, int k, RandomizationDistribution * rd)
	{
		double z;
		double p;

		z = TreeDT::getMaxZstatistic(v,k);

		// Use pdf to calculate p-value
		p = rd->getPvalue(z);

		return p;	
	}; 


	double TreeDT::getMaxZstatistic(HaplotypeTUCountsVector* v, int k){

		double zStatistic, maxZstatistic=-9999;
		SetOfPartitions * partitions;

		partitions = SetOfPartitions::splitVector(v, k);


		if (partitions != NULL){
			
			for(int i=0; i< partitions->size(); i++){
				// Calculate z statistic of the partition
				zStatistic = (*partitions)[i]->getZstatistic(0.5);
				if ( zStatistic > maxZstatistic)
					maxZstatistic = zStatistic;
			}

			delete partitions;
		}

		return maxZstatistic;

		
	};





/*
	double TreeDT::getPvalue(TrioCountersHapUAndT* TM, doubleList**pdf){
		double pValue;
		HaplotypeVector * pU, *pT, * pTU;

		pU = TM->getNonTransmittedHaplotypes() ; // Internal new made
		pT = TM->getTransmittedHaplotypes() ; // Internal new made

		pTU = new HaplotypeVector(*pU); // Make a full copy of pU (not only the pointers)
		pTU->insertClone(pT); // Inserts a clone of pT. A full copy not only the pointers.
	
		pValue = TreeDT::getPvalue(pTU,4, pdf);

		pU->free();
		delete pU;
		pT->free();
		delete pT;
		pTU->free();
		delete pTU;	

		return pValue;
	};



	double TreeDT::getPvalueForK(HaplotypeVector* v, int k, doubleList**pdf){

		double z;
		double p;

		z = TreeDT::getMaxZstatistic(v,k);

		// Use pdf to calculate p-value
		p = TreeDT::PfromZ(pdf[k-1], z);

		cout << "p-value para k " << k << " = " << p << endl;

		return p;

	}

	double TreeDT::getPvalue(HaplotypeVector* v, doubleList**pdf){
		return TreeDT::getPvalue(v,4, pdf);
	};

	double TreeDT::getPvalue(HaplotypeVector* v, int maxK, doubleList**pdf){
		double pValue, minPValue;

		minPValue = pValue = TreeDT::getPvalueForK(v,1, pdf);
		
		for(int k=2; k<=maxK; k++){
			pValue = TreeDT::getPvalueForK(v,k, pdf);
			if (pValue < minPValue)
				minPValue = pValue;
		}

		return minPValue;
	};



	double TreeDT::PfromZ(doubleList * pdf, double z){
		double unit = (float)1/(float)pdf->size();
		bool found = false;
		double p=0;

		for(int i=0; i < pdf->size() && !found; i++){

			if ( (*pdf)[i] < z)
				p += unit;
			else
				found = true;
						
		}
		return 1-p;

	
	}


*/

	




};
