/* File: TrioCounters.h */


#ifndef __TrioCounters_cpp__
#define __TrioCounters_cpp__





//using namespace stats;

namespace BIOS {


/**********************************/
/* DEFINITIONS OF THE FUNCTIONS */
/**********************************/



/*____________________________________________________________ */

TrioCounters* TrioCounters::clone()
{
return new TrioCounters((TrioCounters&)*this);
} 
/*_________________________________________________________________*/

TrioCounters::TrioCounters(TrioCounters& source):GenotypeCounters((GenotypeCounters&)source)
{
genotypeCountsFather=genotypeCountsMale;
genotypeCountsMother=genotypeCountsFemale;
SNPAbsFreqsFather=SNPAbsFreqsMale;
SNPAbsFreqsMother=SNPAbsFreqsFemale;
}
/*_________________________________________________________________*/

MultidimensionalTable<longLongList*>* TrioCounters::getPointersToPartnerGenotypes(IndCategory icPartner)
{
if (icPartner!=father && icPartner!=mother) throw BadFormat(string("TrioCounters::getPointersToPartnerGenotypes"));
longLongList* list, *list2;
intList* dimList=new intList();
for (int i=0; i<this->totalPos; i++)
 dimList->insertElement(getTotalGenotypes(genotypeArray->totalAlleles[i]));
MultidimensionalTable<longLongList*>*result=new MultidimensionalTable<longLongList*>(dimList);
zap(dimList);
for (int i=0; i<result->getSize(); i++) result->setValue(i, NULL);
longLongList* partner=genotypeCountsFather;
longLongList* current=genotypeCountsMother;
if (icPartner==mother)
{
partner=genotypeCountsMother;
current=genotypeCountsFather;
}
//else cout <<"for mother\n";
long long int currentValue, partnerValue;
longLongList * pointerList;
for (int i=0; i<current->size(); i++)
if (current->getElement(i)>=0)
{
currentValue=current->getElement(i);
partnerValue=partner->getElement(i);
//cout <<"current:" << currentValue <<" and partner" << partnerValue <<"\n";
pointerList=result->getValue(currentValue);
if (pointerList==NULL) {pointerList=new longLongList(); result->setValue(currentValue, pointerList);};
pointerList->insertElement(partnerValue);
//cout <<" result at pos " << currentValue <<" :  " << *result->getValue(currentValue);
}
//exit(0);
return result;
}

/*_________________________________________________________________*/

TrioCounters::TrioCounters(SNPPos Pos[], SNPPos TotalPos,  TrioSample * samp, int affectation, bool includeMissing): GenotypeCounters() //Pos, TotalPos, samp, affectation, includeMissing) 
{
try
{
set (Pos, TotalPos, samp, affectation, includeMissing);
}
catch (OutOfBounds& ob){ob.addMessage("\ncalled from TrioCounters::TrioCounters(SNPPos Pos[]..."); throw;}
catch (ORI & ori){ori.addMessage("\ncalled from TrioCounters::TrioCounters(SNPPos Pos[]..."); throw;}
catch (ORLLI & e) {e.addMessage("\ncalled from TrioCounters::TrioCounters(SNPPos Pos[]..."); throw;}
catch (NonImplemented & ni){ni.addMessage("\ncalled from TrioCounters::TrioCounters(SNPPos Pos[]..."); throw;};
}

/*_________________________________________________________________*/

TrioCounters::TrioCounters(): GenotypeCounters()
{
genotypeCountsFather=NULL;
genotypeCountsMother=NULL;
SNPAbsFreqsFather=NULL;
SNPAbsFreqsMother=NULL;
}
/*_______________________________________________________________*/

 void TrioCounters::empty()
{
genotypeCountsFather=NULL;
genotypeCountsMother=NULL;
SNPAbsFreqsFather=NULL;
SNPAbsFreqsMother=NULL;
}

/*_______________________________________________________________*/

MultidimensionalTable<double>*  TrioCounters::getGenotypeAbsFreqs(IndCategory member)//, BayesType Bayes, float distance, float alpha) 
{
switch (member)
{
case father: return GenotypeCounters::getGenotypeAbsFreqs(male); break; //, Bayes, distance, alpha); break; 
case mother: return GenotypeCounters::getGenotypeAbsFreqs(female); break; //. Bayes, distance, alpha); break; 
case parent: return GenotypeCounters::getGenotypeAbsFreqs(everyGender); break; //, Bayes, distance, alpha); break; 
default: throw BadFormat("MultidimensionalTable<double>*  TrioCounters::getGenotypeAbsFreqs(IndCategory member)"); break;
}
}

/*_______________________________________________________________*/

 longLongList*TrioCounters::permuteInParent(bool father)
{
// It returns a new list of genotype codes for each individual randomly changing between T/U
return GenotypeCounters::permuteInGender(father);
}

/*_______________________________________________________________*/

TrioCounters*TrioCounters::getPermutation()
{
//if (Bayes!=MLE) throw BadFormat("TrioCounters<T>::getPermutation()");
longLongList
* tempGenotypeCountsFather=permuteInParent(true),
* tempGenotypeCountsMother=permuteInParent(false);


TrioCounters* result=clone();
zap(result->genotypeCountsFather);
zap(result->genotypeCountsMother);
result->genotypeCountsFather=tempGenotypeCountsFather;
result->genotypeCountsMother=tempGenotypeCountsMother;
result->genotypeCountsMale=tempGenotypeCountsFather;
result->genotypeCountsFemale=tempGenotypeCountsMother;
return result;
}
/*_________________________________________________________________*/
/*
void TrioCounters::set(TrioSample* sample, int affectation)  
{
try
{
setCounters(sample, affectation);
setTotalGenotypes();
setSNPFreqs();
}
catch (OutOfBounds& ob){ob.addMessage("\ncalled from TrioCounters::set(TrioSample* sample..."); throw;}
catch (NonImplemented & ni){ni.addMessage("\ncalled from TrioCounters::set(TrioSample* sample..."); throw;}
catch (ORI & ori){ori.addMessage("\ncalled from TrioCounters::set(TrioSample* sample..."); throw;}
catch (ORLLI & e) {e.addMessage("\ncalled from TrioCounters::set(TrioSample* sample..."); throw;};
}
/*___________________________________________________________________________________________________*/

 void TrioCounters::setSNPFreqs()  
{
try
{
GenotypeCounters::setSNPFreqs();
SNPAbsFreqsFather=SNPAbsFreqsMale;
SNPAbsFreqsMother=SNPAbsFreqsFemale;
}
catch (BasicException & e) {e.addMessage("\n called from GenotypeCounters::setSNPFreqs()"); throw; }
}



/*____________________________________________________________ */

void TrioCounters::setCounters (GenomaSample* sample, int affectation)  
{
try
{
zap(genotypeCountsMale);
zap(genotypeCountsFemale);
genotypeCountsFather=((TrioSample*)sample)->getGenotypeCounts(pos, totalPos, father, everyGender, affectation, genotypeArray, false, includeMissing);
genotypeCountsMother=((TrioSample*)sample)->getGenotypeCounts(pos, totalPos, mother, everyGender, affectation, genotypeArray, false, includeMissing);
genotypeCountsMale=genotypeCountsFather;
genotypeCountsFemale=genotypeCountsMother;
}
catch (BasicException & e) {e.addMessage("\n called from GenotypeCounters::setCounters()"); throw; }
//cout <<"mother gens:\n" << *genotypeCountsMother;
}

/*_________________________________________________________________*/

TUCounts * TrioCounters::getPermutationTUCounts (HapExtractionConfiguration* hapExtractionConfiguration)
{
throw NonImplemented("TrioCounters::getPermutationTUCounts (HapExtractionConfiguration* hapExtractionConfiguration)");
}


};  // End of Namespace

#endif

/* End of file: TrioCounters.h */




