/* File: MultimarkerMeasure.h */


#ifndef __TrioCountersHapUAndT_cpp__
#define __TrioCountersHapUAndT_cpp__





//using namespace stats;

namespace BIOS
{


	/**********************************/
	/* DEFINITIONS OF THE FUNCTIONS */
	/**********************************/



///////////////////
//// public ////////
///////////////////

	/*____________________________________________________________ */
	/*
	TrioCountersHapUAndT* TrioCountersHapUAndT::clone()
	{
	return new TrioCountersHapUAndT(*this);
	}
	/*_________________________________________________________________*/

	void TrioCountersHapUAndT::set ( TrioCountersHapUAndT& source )
	{
//haplotypeCounts=NULL;
		haplotypeCounts=NULL;
		hapByFreqsT=NULL;
		hapByFreqsU=NULL;
//		emDistributions=source.emDistributions;
//		emRestriction=source.emRestriction;
		if ( source.haplotypeCounts!=NULL ) haplotypeCounts=new ParentalHaplotypesList ( *source.haplotypeCounts );
		if ( source.hapByFreqsT!=NULL ) hapByFreqs=new FreqAndKeyVector ( *source.hapByFreqsT );
		if ( source.hapByFreqsU!=NULL ) hapByFreqs=new FreqAndKeyVector ( *source.hapByFreqsU );
	//	if ( source.haplotypeFreqsTabPairParents!=NULL ) haplotypeFreqsTabPairParents=new Pair<Pair<MultidimensionalTable<double>*>*> ( *source.haplotypeFreqsTabPairParents );
	}
	/*_________________________________________________________________*/

	TrioCountersHapUAndT::TrioCountersHapUAndT ( TrioCountersHapUAndT& source ) : HapCounters ( source )
	{
		set ( source );
	}
	/*_________________________________________________________________*/

	TrioCountersHapUAndT::TrioCountersHapUAndT ( TrioCounters* trioCounters, PhaseAlg phaseAlg, EMDistributions emDistributions, EMRestriction emRestriction, BayesType  Bay, float alphaBayes, float distance ) : HapCounters () // trioCounters, phaseAlg, Bay, alphaBayes, distance )
	{
		try
		{
  HapCounters::set((GenotypeCounters*)trioCounters, phaseAlg, Bay, alphaBayes, distance);
		//	this->emRestriction=emRestriction;
		//	this->emDistributions=emDistributions;
//			haplotypeCounts=NULL;
   maleHaps=NULL;
   femaleHaps=NULL;
			hapByFreqsT=NULL;
			hapByFreqsU=NULL;
	//		haplotypeFreqsTabPairParents=getHaplotypeFreqsTab();
	//		setHaplotypeCounts();
			if ( haplotypeTable!=NULL ) setTotalHaplotypes();
			if ( haplotypeTable!=NULL )
			{
				setHapByFreqs();
			}
		}
		catch ( BasicException & be ) {be.addMessage ( "\ncalled from TrioCountersHapUAndT::TrioCountersHapUAndT(SNPPos Pos[]..." ); throw;};
	}
	/*_________________________________________________________________*/

	TrioCounters* TrioCountersHapUAndT::getTrioCounters()
	{
		return ( TrioCounters* ) genotypeCounters;
	}
	/*_________________________________________________________________*/

	MultidimensionalTable<double>* TrioCountersHapUAndT::getKnownHaplotypeFreqs()
	{
		//	cout << "inside\n";
		long long int hT, hU, valueFather, valueMother, *value, hap;
		intList* dimList=new intList();
		MultidimensionalTable<double>* parentT, *parentU;
		for ( int i=0; i<getTrioCounters()->totalPos;i++ ) dimList->insertElement ( getTrioCounters()->genotypeArray->totalAlleles[i] );
		MultidimensionalTable<double>* result=new MultidimensionalTable<double> ( dimList );
		
		float freq, total, total2, total3, total4;
		//	cout << "trios is:" << *this->getTrioCounters() << "\n";
		for ( int i=0; i<this->getTrioCounters()->genotypeCountsFather->size(); i++ )
//if (this->getTrioCounters()->genotypeCountsFather->getElement(i)>=0 && this->getTrioCounters()->genotypeCountsMother->getElement(i)>=0)//not missing
		{
			valueFather=this->getTrioCounters()->genotypeCountsFather->getElement ( i );
			valueMother=this->getTrioCounters()->genotypeCountsMother->getElement ( i );
			for ( int pari=0; pari<2; pari++ )
			{
				if ( pari==0 ) value=&valueFather;
				else value=&valueMother;
				if ( *value>=0 ) // non missing
				{
					hT=getHap ( *value, true );
					hU=getHap ( *value, false );
					//	cout << "hT is:" << hT << "and hU is:" << hU <<"\n";
					if ( hT<0 || hU<0 ) throw BadFormat ( "Pair<Pair<MultidimensionalTable<double>*>*>*  TrioCountersHapUAndT::getKnownHaplotypeFreqs()" );
					result->addValue ( hT, 1 );
					result->addValue ( hU, 1 );
				}
			}
		}


		total=result->getTotalCounts();
		total=addBayes ( total, Bayes, distance, alphaBayes, 1 );
	
		for ( int i=0; i<result->getSize();i++ )
		{
			freq=addBayes ( result->getValue ( i ), Bayes, distance, alphaBayes, result->getSize());
			result->setValue ( i,freq/total);
		}

		zap ( dimList );
		return result;
	}
	/*_________________________________________________________________*/


	long long int TrioCountersHapUAndT::getHap ( const long long int value, bool left )
	{
		long long int result=-2;
		if ( this->getTrioCounters()->genotypeArray->getTotalSolvedConfs ( value ) ==1 )
		{
			result=this->getTrioCounters()->genotypeArray->getSolvedConf ( value, 0, left, this->haplotypeTable );
		}
		return result;
	}


	/*_______________________________________________________________*/
	
		double TrioCountersHapUAndT::getNormalizationValue (MultidimensionalTable<double>* haplotypeFreqsTab, int totalConfigurations, long long int ambiguousPosFather, long long int ambiguousPosMother)
		{
			double total=0, currentFrequency;
   long long int fatherT, fatherU, motherT, motherU;
			for ( int j=0; j<totalConfigurations; j++ )
			{
 	fatherT=getTrioCounters()->genotypeArray->getSolvedConf ( ambiguousPosFather, j, true,  this->haplotypeTable );
		fatherU=getTrioCounters()->genotypeArray->getSolvedConf ( ambiguousPosFather, j, false,  this->haplotypeTable );
		motherT=getTrioCounters()->genotypeArray->getPartnerSolvedConf ( j, ambiguousPosFather, ambiguousPosMother, true, this->haplotypeTable );
		motherU=getTrioCounters()->genotypeArray->getPartnerSolvedConf ( j, ambiguousPosFather, ambiguousPosMother, false, this->haplotypeTable );
				currentFrequency=getCurrentFrequency ( haplotypeFreqsTab, fatherT, fatherU, motherT, motherU );
				total=total+currentFrequency; //totalConfigurations;
			}
			return total;
		}


		/*_______________________________________________________________*/


	void TrioCountersHapUAndT::setHaplotypeCounts()
	{
/*
cout <<  "fatherT:" << *haplotypeFreqsTabPairParents->First->First <<"\n";
cout <<  "fatherU:" << *haplotypeFreqsTabPairParents->First->Second <<"\n";
cout <<  "motherT:" << *haplotypeFreqsTabPairParents->Second->First <<"\n";
cout <<  "motherU:" << *haplotypeFreqsTabPairParents->Second->Second <<"\n";
*/
//exit(0);

		int totalMeiosis=0;
		ParentalHaplotypes *parentalHaplotypes, *chosenParentalHaplotypes;
  InferredHaplotypes* inferredHaplotypes;
		this->haplotypeCounts=new ParentalHaplotypesList();
  maleHaps=new InferredHaplotypesList();
  femaleHaps=new InferredHaplotypesList();
		int totalConfigurations;
		double maxFrequency=0, currentFrequency, total=0, freq;
		long long int ambiguousPosFather, ambiguousPosMother;
		for ( long long int i=0; i<getTrioCounters()->genotypeCountsFather->size(); i++ )
			if ( getTrioCounters()->genotypeCountsFather->getElement ( i ) <0 || getTrioCounters()->genotypeCountsMother->getElement ( i ) <0 )
   {
				this->haplotypeCounts->insertElement ( NULL );
    maleHaps->insertElement(NULL);
    femaleHaps->insertElement(NULL);
    }
			else
			{
				maxFrequency=-1;
				ambiguousPosFather=getTrioCounters()->genotypeCountsFather->getElement ( i );
				ambiguousPosMother=getTrioCounters()->genotypeCountsMother->getElement ( i );
				totalConfigurations=getTrioCounters()->genotypeArray->getTotalSolvedConfs ( ambiguousPosFather );
			 if ( phaseAlg==weighted ) total=getNormalizationValue (haplotypeFreqsTab, totalConfigurations, ambiguousPosFather, ambiguousPosMother); 
				for ( int j=0; j<totalConfigurations; j++ )
				{
					parentalHaplotypes=getParentalHaplotypes ( ambiguousPosFather, ambiguousPosMother, j );
					parentalHaplotypes->trioCount=i;
					if ( phaseAlg!=onlyKnown )
						currentFrequency=getCurrentFrequency ( haplotypeFreqsTab, parentalHaplotypes );
					if ( phaseAlg==maxFreq && maxFrequency<=currentFrequency ) {maxFrequency=currentFrequency; chosenParentalHaplotypes=parentalHaplotypes;}
					if ( phaseAlg==weighted )
					{parentalHaplotypes->freq=currentFrequency/total;this->haplotypeCounts->insertElement ( parentalHaplotypes );
this->maleHaps->insertElement(parentalHaplotypes->getFatherInferredHaplotypes());
this->femaleHaps->insertElement(parentalHaplotypes->getMotherInferredHaplotypes());
}
				}// end for each conf
				if ( phaseAlg==maxFreq )
				{
					//	freq=addBayes ( 1, Bayes, distance, alphaBayes, totalMeiosis*2 );
					chosenParentalHaplotypes->freq=1;
					parentalHaplotypes=chosenParentalHaplotypes;
					this->haplotypeCounts->insertElement ( parentalHaplotypes );
				}
				if ( ( phaseAlg==onlyKnown && totalConfigurations==1 ) || phaseAlg!=onlyKnown )
					if ( phaseAlg==onlyKnown ) 
     {
this->haplotypeCounts->insertElement ( parentalHaplotypes );
this->maleHaps->insertElement(parentalHaplotypes->getFatherInferredHaplotypes());
this->femaleHaps->insertElement(parentalHaplotypes->getMotherInferredHaplotypes());
}
					totalMeiosis=totalMeiosis+2;
			}
		if ( totalMeiosis!=this->totalMeiosis ) throw OutOfBounds ( totalMeiosis, this->totalMeiosis, "void TrioCountersHapUAndT::setHaplotypeCounts()" );
//cout <<"hapcounts:\n" << *haplotypeCounts <<"\n";
//exit(0);
		if ( totalMeiosis==0 ) this->~TrioCountersHapUAndT();
//cout << "dirrr: " << *getTrioCounters() << "\n";
//cout << "dirrr: " << *haplotypeCounts << "\n";
	}
	/*_______________________________________________________________*/

	double TrioCountersHapUAndT::getCurrentFrequency (MultidimensionalTable<double>* haplotypeFreqsTab, ParentalHaplotypes *parentalHaplotype )
	{
		return getCurrentFrequency(haplotypeFreqsTab, parentalHaplotype->fatherT, parentalHaplotype->motherT, parentalHaplotype->fatherU, parentalHaplotype->motherU);
	}
	/*_______________________________________________________________*/

	double TrioCountersHapUAndT::getCurrentFrequency (MultidimensionalTable<double>* haplotypeFreqsTab, long long int  fatherT, long long int  fatherU, long long int  motherT, long long int  motherU)
	{
		return haplotypeFreqsTab->getValue(fatherT)*haplotypeFreqsTab->getValue(motherT)*haplotypeFreqsTab->getValue(fatherU)*haplotypeFreqsTab->getValue(motherU);
//*std::pow(totalMeiosis,4)/std::pow(4,4);
	}
	/*_______________________________________________________________*/


	HeteroPair<HaplotypeTUCountsVector*,ParentalHaplotypesUsingPointersList*>* TrioCountersHapUAndT::getTUCounts ( bool useOnlyHetero )
	{
		ParentalHaplotypesUsingPointersList* result2=new ParentalHaplotypesUsingPointersList();
		HaplotypeTUCountsVector* result1=new HaplotypeTUCountsVector();
		HeteroPair<HaplotypeTUCountsVector*,ParentalHaplotypesUsingPointersList*>* result=new HeteroPair<HaplotypeTUCountsVector*,ParentalHaplotypesUsingPointersList*>();
		result->First=result1;
		result->Second=result2;
		HaplotypeTUCounts* h;
		ParentalHaplotypesUsingPointers* pp;
		map<long long int, int> hapPos=map<long long int, int>();
		double totalCountsUsed, totalCounts;
		intList* posList;
		int pos=0;
		for ( long long int k=0; k<haplotypeTable->getSize(); k++ )
		{
			totalCountsUsed=getTotalHaplotypes ( k, ut, parent );
			if ( totalCountsUsed>0 )
			{
				posList=haplotypeTable->getPosList ( k );
				h=new HaplotypeTUCounts ( posList->size() );
				for ( int i=0; i<posList->size(); i++ )
					( *h ) [i]= ( base ) getTrioCounters()->genotypeArray->getAllele ( i, posList->getElement ( i ) );
				h->frequencyT=getTotalHaplotypes ( k, t, parent, onlyHetero );
				h->frequencyU=getTotalHaplotypes ( k, u, parent, onlyHetero );
				if ( useOnlyHetero ) h->frequencyHomo=getTotalHaplotypes ( k, ut, parent, onlyHomo );
				else
				{
					h->frequencyHomo=0;
					h->frequencyT+=getTotalHaplotypes ( k, ut, parent, onlyHomo ) /2;
					h->frequencyU+=getTotalHaplotypes ( k, ut, parent, onlyHomo ) /2;
				}
				zap ( posList );
				hapPos[k]=pos;
				result1->insertElement ( h );
				pos++;
			}
		}
		Haplotype*fatherT, *motherT, *fatherU, *motherU;
		ParentalHaplotypes* ph;
		for ( ParentalHaplotypesList::iterator it=haplotypeCounts->begin(); it!=haplotypeCounts->end(); it++ )
		{
			ph=*it;
			fatherT=result1->getElement ( hapPos[ph->fatherT] )->getHaplotype();
			fatherU=result1->getElement ( hapPos[ph->fatherU] )->getHaplotype();
			motherT=result1->getElement ( hapPos[ph->motherT] )->getHaplotype();
			motherU=result1->getElement ( hapPos[ph->motherU] )->getHaplotype();
			pp=new ParentalHaplotypesUsingPointers ( fatherT, fatherU, motherT, motherU, ph->trioCount, ph->freq, ph->outputSeparator, ph->delimiters, ph->printTransmitted,  ph->printUntransmitted );
			result2->insertElement ( pp );
		}
		return result;
	}




	/*_______________________________________________________________*/

	ParentalHaplotypes* TrioCountersHapUAndT::getParentalHaplotypes ( long long int ambiguousConfFather, long long int ambiguousConfMother, int binaryKnownConfiguration)
	{
		ParentalHaplotypes *parentalHaplotype=new ParentalHaplotypes();
		parentalHaplotype->fatherT=getTrioCounters()->genotypeArray->getSolvedConf ( ambiguousConfFather, binaryKnownConfiguration, true,  this->haplotypeTable );
		parentalHaplotype->fatherU=getTrioCounters()->genotypeArray->getSolvedConf ( ambiguousConfFather, binaryKnownConfiguration, false,  this->haplotypeTable );
		parentalHaplotype->motherT=getTrioCounters()->genotypeArray->getPartnerSolvedConf ( binaryKnownConfiguration, ambiguousConfFather, ambiguousConfMother, true, this->haplotypeTable );
		parentalHaplotype->motherU=getTrioCounters()->genotypeArray->getPartnerSolvedConf ( binaryKnownConfiguration, ambiguousConfFather, ambiguousConfMother, false, this->haplotypeTable );
		parentalHaplotype->freq=1;
		return parentalHaplotype;
	}
	/*_______________________________________________________________*/

	MultidimensionalTable<double>* TrioCountersHapUAndT::getHaplotypeFreqsTab() 
	{
// It computes the haplotype frequencies
		MultidimensionalTable<double>* genotypeAbsFreqsTab=NULL;
		MultidimensionalTable<longLongList*>* pointersToPartnerGenotypes=NULL;
		if ( phaseAlg==onlyKnown ) return getKnownHaplotypeFreqs();
//		if ( emRestriction==noRestriction )
	//		genotypeAbsFreqsTab=getTrioCounters()->getGenotypeAbsFreqs ( parent );
	//	else // triosBased restriction
		{
			genotypeAbsFreqsTab=getTrioCounters()->getGenotypeAbsFreqs ( father );
			pointersToPartnerGenotypes=getTrioCounters()->getPointersToPartnerGenotypes ( mother );
		}

		MultidimensionalTable<double>*result=getHaplotypeFreqsTab ( 0, genotypeAbsFreqsTab, pointersToPartnerGenotypes );

		if ( result==NULL ) result=getHaplotypeFreqsTab ( 1, genotypeAbsFreqsTab, pointersToPartnerGenotypes );
		if ( result==NULL )
			throw NullValue ( " at TrioCountersHapUAndT::getHaplotypeFreqsTab" );


		zap ( pointersToPartnerGenotypes );
		zap ( genotypeAbsFreqsTab );

		return result;
	}
	/*_______________________________________________________________*/

	MultidimensionalTable<double>* TrioCountersHapUAndT::getHaplotypeFreqsTab ( int type, MultidimensionalTable<double>* genotypeAbsFreqsTab, MultidimensionalTable<longLongList*>* pointersToPartnerGenotypes ) 
	{
		if ( phaseAlg==onlyKnown ) throw BadFormat ( "TrioCountersHapUAndTUnknownHaps::getHaplotypeFreqsTab" );
		MultidimensionalTable<double>* result=new MultidimensionalTable<double>();
		
		result=this->getInitialEstimation ( type );
		double totalHaps=getTrioCounters()->totalGenotypes*2;

 		this->getTrioCounters()->genotypeArray->estimateMLE ( result, genotypeAbsFreqsTab, pointersToPartnerGenotypes, totalHaps, 1000, this->haplotypeTable, Bayes, distance, alphaBayes );
	


		return result;
	}

	/*_________________________________________________________________*/

	void TrioCountersHapUAndT::setTotalHaplotypes()
	{
		totalDifferentHaplotypes=0;
		totalUsedDifferentHaplotypes=0;
		double totalHaplotypes;
		for ( long long int key=0; key<haplotypeTable->getSize(); key++ )
		{
			totalHaplotypes=getTotalHaplotypes ( key, ut, parent, allHomozygosity );
			if ( totalHaplotypes>0 ) totalDifferentHaplotypes++;
			if ( totalHaplotypes>0 )
				totalUsedDifferentHaplotypes++;
		}
	}
	/*_________________________________________________________________*/

	MultidimensionalEmptyTable<int>* TrioCountersHapUAndT::getHaplotypeArray()
	{
		return haplotypeTable;
	}


	/*_________________________________________________________________*/

	void  TrioCountersHapUAndT::empty()
	{

		zap ( haplotypeCounts );
		zap ( haplotypeTable );
		zap ( hapByFreqsT );
		zap ( hapByFreqsU );

	};

	/*_________________________________________________________________*/

	TrioCountersHapUAndT::TrioCountersHapUAndT() : HapCounters()
	{
		haplotypeCounts=NULL;
	}
	/*______________________________________________________*/
	/*
	 void TrioCountersHapUAndT::setSNPFreqs()
	{
	try
	{
	SNPAbsFreqsFatherT=new double*[trioCounters->totalPos];
	SNPAbsFreqsFatherU=new double*[trioCounters->totalPos];
	SNPAbsFreqsMotherT=new double*[trioCounters->totalPos];
	SNPAbsFreqsMotherU=new double*[trioCounters->totalPos];
	int al;
	double totalSNP=0, freq=0;
	for (int i=0; i<trioCounters->totalPos; i++)
	{
	 SNPAbsFreqsFatherT[i]=Initialize(trioCounters->genotypeArray->totalAlleles[i], 0.0);
	 SNPAbsFreqsFatherU[i]=Initialize(trioCounters->genotypeArray->totalAlleles[i], 0.0);
	 SNPAbsFreqsMotherT[i]=Initialize(trioCounters->genotypeArray->totalAlleles[i], 0.0);
	 SNPAbsFreqsMotherU[i]=Initialize(trioCounters->genotypeArray->totalAlleles[i], 0.0);
	}
	double** SNPAbsFreqs;
	long long int hap;
	int i=0, *position;
	ParentalHaplotypes* val;
	//cout <<"hapcounts:" << *haplotypeCounts <<"\n";
	for (ParentalHaplotypesList::iterator it=haplotypeCounts->begin(); it<haplotypeCounts->end(); it++)
	if (*it!=NULL)
	{
	val=(ParentalHaplotypes*)haplotypeCounts->getElement(it);
	for (int trans=0; trans<2; trans++)
	{
	for (int parent=0; parent<2; parent++)
	{
	if (trans==0) if (parent==0) {SNPAbsFreqs=SNPAbsFreqsFatherT; hap=val->fatherT;} else {SNPAbsFreqs=SNPAbsFreqsMotherT; hap=val->motherT;}
	else if (parent==0) {SNPAbsFreqs=SNPAbsFreqsFatherU; hap=val->fatherU; } else {SNPAbsFreqs=SNPAbsFreqsMotherU; hap=val->motherU;}
	position=haplotypeTable->getPositions(hap);
	for (int j=0; j<trioCounters->totalPos; j++)
	{
	 al=position[j];
	 SNPAbsFreqs[j][al]=SNPAbsFreqs[j][al]+val->freq;
	}
	zaparr(position);
	}
	}
	}
	}
	catch (ORLLI & e) {e.addMessage("\ncalled from TrioCountersHapUAndT::setSNPFreqs()"); throw; }
	catch (BasicException & be) {be.addMessage("\ncalled from TrioCountersHapUAndT::setSNPFreqs()"); throw; }
	}


	/*____________________________________________________________ */
	/*

	double TrioCountersHapUAndT::getStandardizedSimilarityMeasure (IndCategory ic)
	// for Length contrast test
	{
	return getTest(1, ic);
	}


	/*____________________________________________________________ */

	/*
	double TrioCountersHapUAndT::getSimilarityMeasure (IndCategory ic)
	// for Length contrast test
	{
	return getTest(0, ic);
	}
	/*____________________________________________________________ */

	/*
	double TrioCountersHapUAndT::getSignedRankTest (bool Wilcoxon, IndCategory ic)
	// for Length contrast test
	{
	//cout << "\nsigned rank is:" << 2+!Wilcoxon;
	return getTest(2+!Wilcoxon, ic);
	}

	/*___________________________________________________*/
	/*
	double TrioCountersHapUAndT::getLengthMeasure (long long int pos1T, long long int pos2T, long long int pos1U, long long int pos2U)
	{
	try
	{
	// it is defined as the difference between the transmitted haplotypes of a pair of individuals minus the differences in their non transmitted haplotypes
	int *p1T=haplotypeTable->getPositions(pos1T);
	int *p2T=haplotypeTable->getPositions(pos2T);
	int *p1U=haplotypeTable->getPositions(pos1U);
	int *p2U=haplotypeTable->getPositions(pos2U);

	int resultT=0, resultU=0, maxResultT=0, maxResultU=0;
	for (int i=0; i< trioCounters->totalPos; i++)
	{
	//cout <<"\n" << pos1T[i] <<"-" << pos2T[i] << "-" << pos1U[i] << "-" << pos2U[i];
	if (p1T[i]==p2T[i]) {resultT++;} else {if (resultT>maxResultT) maxResultT=resultT; resultT=0;};
	if (p1U[i]==p2U[i]) {resultU++;} else {if (resultU>maxResultU) maxResultU=resultU; resultU=0;};
	}
	if (resultT>maxResultT) maxResultT=resultT;
	if (resultU>maxResultU) maxResultU=resultU;
	zaparr(p1T);
	zaparr(p2T);
	zaparr(p1U);
	zaparr(p2U);
	return (maxResultT-maxResultU)/(double)trioCounters->totalPos;
	}
	catch (ORLLI & e) {e.addMessage("\ncalled from TrioCountersHapUAndT::getLengthMeasure"); throw; }
	catch (BasicException & be) {be.addMessage("\ncalled from TrioCountersHapUAndT::getLengthMeasure"); throw; };
	};
	/*___________________________________________________*/



	/*____________________________________________________________ */
	/*
		BidimensionalTable<double>* TrioCountersHapUAndT::getMultiallelicFreqs ( SNPPos a, SNPPos b, Transmission trans, IndCategory ic )
		{
			try
			{
				if ( ic!=parent && ic!=mother && ic!=father ) throw BadFormat ( "BidimensionalTable<double>* TrioCountersHapUAndT::getMultiallelicFreqs(SNPPos a, SNPPos b, Transmission trans, IndCategory ic)" );
				ParentalHaplotypes *parentalHaplotypes=NULL;
				BidimensionalTable<double>*result=new BidimensionalTable<double> ( getTrioCounters()->genotypeArray->totalAlleles[a], getTrioCounters()->genotypeArray->totalAlleles[b] );
				int pos, *positions, cont=0;
				double totalHaplotypes=this->totalMeiosis*2,  SB=0, p;
				if ( trans!=ut ) totalHaplotypes=totalHaplotypes/2;
				if ( ic!=parent ) totalHaplotypes=totalHaplotypes/2;
				for ( ParentalHaplotypesList::iterator pointer=haplotypeCounts->begin(); pointer!=haplotypeCounts->end(); pointer++ )
					if ( *pointer!=NULL )
					{
						parentalHaplotypes= ( ParentalHaplotypes* ) haplotypeCounts->getElement ( pointer );
						for ( int i=0; i<2; i++ )
							if ( ( i==0 && trans==t ) || ( i==1 && trans==u ) || trans==ut )
								for ( int parentT=0; parentT<2; parentT++ )
									if ( parentT== ( int ) ic || ic==parent )
										if ( parentalHaplotypes->isKnown ( 1-parentT ) )
										{
												if ( i==0 ) if ( parentT==0 ) pos=parentalHaplotypes->fatherT; else pos=parentalHaplotypes->motherT;
											else if ( parentT==0 ) pos=parentalHaplotypes->fatherU; else pos=parentalHaplotypes->motherU;
											positions=haplotypeTable->getPositions ( pos );
											result->addValue ( positions[a], positions[b], parentalHaplotypes->freq/totalHaplotypes );
											zaparr ( positions );
										}
						cont++;
					}
				return result;
			}
			catch ( ORLLI & e ) {e.addMessage ( "\n called from TrioCountersHapUAndT::getMultiallelicFreqs" ); throw; }
			catch ( BasicException & be ) {be.addMessage ( "\n called from TrioCountersHapUAndT::getMultiallelicFreqs" ); throw; };
		}

		/*____________________________________________________________ */

	BidimensionalTable<double>* TrioCountersHapUAndT::getMultiallelicFreqs ( SNPPos a, SNPPos b, Transmission trans, IndCategory ic )
	{
		try
		{
			if ( ic!=parent && ic!=mother && ic!=father ) throw BadFormat ( "BidimensionalTable<double>* TrioCountersHapUAndT::getMultiallelicFreqs(SNPPos a, SNPPos b, Transmission trans, IndCategory ic)" );
			BidimensionalTable<double>*result=new BidimensionalTable<double> ( genotypeCounters->genotypeArray->totalAlleles[a], genotypeCounters->genotypeArray->totalAlleles[b] );
			int posLeft, posRight, *positionsLeft, *positionsRight;
			double totalHaplotypes=this->totalMeiosis*2,  SB=0, p;


			InferredHaplotypes* inferredHaplotypes;
			int pos[genotypeCounters->totalPos];
			for ( int i=0; i<genotypeCounters->totalPos;i++ ) pos[i]=haplotypeFreqsTab->dimensionList->getElement ( i );
/*
cout << "dimen in results:" << *result->dimensionList <<"\n";
cout << "dimen in first first:" << *haplotypeFreqsTabPairParents->First->First->dimensionList <<"\n";
cout << "dimen in first second:" << *haplotypeFreqsTabPairParents->First->Second->dimensionList<<"\n";
cout << "dimen in second first:" << *haplotypeFreqsTabPairParents->Second->First->dimensionList <<"\n";
cout << "dimen in second second:" << *haplotypeFreqsTabPairParents->Second->Second->dimensionList <<"\n";
*/


			double total=0;

			for ( int i=0; i<2; i++ ) // transmission
				if ( ( i==0 && trans==t ) || ( i==1 && trans==u ) || trans==ut )
					for ( int member=0; member<2; member++ ) // parent
						if ( member== ( int ) ic || ic==parent )
						{
							for ( int j=0; j<haplotypeFreqsTab->dimensionList->getElement ( a );j++ )
								for ( int k=0; k<haplotypeFreqsTab->dimensionList->getElement ( b );k++ )
								{
									pos[a]=j; pos[b]=k;
      //   cout << "vals: " << j << " and " << k << " y freqs: " << haplotypeFreqs->getValue ( pos ) << "\n";
									result->addValue ( j, k, haplotypeFreqsTab->getValue ( pos ) );
        total=total+haplotypeFreqsTab->getValue ( pos ) ;
								}
						} 
//cout << "totttttttttal is:" << total <<"\n";
			
						for ( int i=0; i<result->getXDim(); i++ )
							for ( int j=0; j<result->getYDim(); j++ )
								result->setValue ( i, j, result->getValue ( i,j ) /total );
			
			return result;
		}
		catch ( ORLLI & e ) {e.addMessage ( "\n called from HapCounters::getMultiallelicFreqs" ); throw; }
		catch ( BasicException & be ) {be.addMessage ( "\n called from HapCounters::getMultiallelicFreqs" ); throw; };
	}


	/*____________________________________________________________ */

	void TrioCountersHapUAndT::setHapByFreqs ()
	{
		//FreqAndKeyVector* hapByFreqs=new FreqAndKeyVector();
		hapByFreqsT=new FreqAndKeyVector();
		hapByFreqsU=new FreqAndKeyVector();
  zap(hapByFreqs);
hapByFreqs=new FreqAndKeyVector();
		FreqAndKey* fv;
		double total;
		for ( long long int key=0; key<haplotypeTable->getSize(); key++ )
			for ( int tr=0; tr<3; tr++ )
			{
				total=getTotalHaplotypes ( key, ( Transmission ) tr, parent, allHomozygosity );
				if ( total>0 )
				{
					fv=new FreqAndKey();
					fv->First=total;
					fv->Second=key;
					switch ( ( Transmission ) tr )
					{
						case t: hapByFreqsT->insertElement ( fv ); break;
						case u: hapByFreqsU->insertElement ( fv ); break;
						case ut: hapByFreqs->insertElement ( fv ); break;
					}
				}
			}
		hapByFreqs->sort ( false );
		hapByFreqsT->sort ( false );
		hapByFreqsU->sort ( false );
		if ( 1==0 )
			if ( ! ( *hapByFreqs==*this->hapByFreqs ) )
			{
				cout << "hapsintrios:" << *hapByFreqs << "\n";
				cout << "while haps in unrelated: " << *this->hapByFreqs << "\n";
				throw BadFormat ( "void TrioCountersHapUAndT::setHapByFreqs ()" );
			}
	}

	/*____________________________________________________________ */

	double TrioCountersHapUAndT::getTotalHeteroGenotypes ( long long int hap, IndCategory ic ) 
	{
		if ( ic==offspring || ic==everybody ) throw BadFormat ( string ( "TrioCountersHapUAndT::getTotalMeiosis" ) );
		ParentalHaplotypes* parentalHaplotypes;
		double total=0;
		long long int parentT, parentU, chosenParent;


		for ( ParentalHaplotypesList::iterator it=haplotypeCounts->begin(); it<haplotypeCounts->end(); it++ )
			if ( *it!=NULL )
			{
				parentalHaplotypes= ( ParentalHaplotypes* ) haplotypeCounts->getElement ( it );
				for ( int parentC=0; parentC<2; parentC++ )
					if ( ic==parent || parentC==0 && ic==father || parentC==1 && ic==mother )
					{
						if ( parentC==0 ) {parentT=parentalHaplotypes->fatherT; parentU=parentalHaplotypes->fatherU;}
						else {parentT=parentalHaplotypes->motherT; parentU=parentalHaplotypes->motherU;}
						if ( ( parentT==hap && parentU!=hap ) || ( parentT!=hap && parentU==hap ) )
							total=total+parentalHaplotypes->freq;
					}
			}
		return total;
	}


	/*____________________________________________________________ */

	double TrioCountersHapUAndT::getTotalHomoGenotypes ( long long int hap, IndCategory ic ) 
	{
		if ( ic==offspring || ic==everybody ) throw BadFormat ( string ( "TrioCountersHapUAndT::getTotalMeiosis" ) );
		ParentalHaplotypes* parentalHaplotypes;
		double total=0;
		long long int parentT, parentU, chosenParent;


		for ( ParentalHaplotypesList::iterator it=haplotypeCounts->begin(); it<haplotypeCounts->end(); it++ )
			if ( *it!=NULL )
			{
				parentalHaplotypes= ( ParentalHaplotypes* ) haplotypeCounts->getElement ( it );
				for ( int parentC=0; parentC<2; parentC++ )
					if ( ic==parent || parentC==0 && ic==father || parentC==1 && ic==mother )
					{
						if ( parentC==0 ) {parentT=parentalHaplotypes->fatherT; parentU=parentalHaplotypes->fatherU;}
						else {parentT=parentalHaplotypes->motherT; parentU=parentalHaplotypes->motherU;}
						if ( parentT==hap && parentU==hap )
							total=total+parentalHaplotypes->freq;
					}
			}

		return total;
	}

	/*____________________________________________________________ */
	/*
	double TrioCountersHapUAndT::getTotalHeteroGenotypes (IndCategory ic)
	{
	if (ic==offspring || ic==everybody) throw BadFormat(string("TrioCountersHapUAndT::getTotalMeiosis"));
	ParentalHaplotypes* parentalHaplotypes;
	double total=0;
	long long int parentT, parentU, chosenParent;


	for (ParentalHaplotypesList::iterator it=haplotypeCounts->begin(); it<haplotypeCounts->end(); it++)
	if (*it!=NULL)
	{
	parentalHaplotypes=(ParentalHaplotypes*)haplotypeCounts->getElement(it);
	for (int parentC=0; parentC<2; parentC++)
	if (ic==parent || parentC==0 && ic==father || parentC==1 && ic==mother)
	{
	if (parentC==0) {parentT=parentalHaplotypes->fatherT; parentU=parentalHaplotypes->fatherU;}
	else {parentT=parentalHaplotypes->motherT; parentU=parentalHaplotypes->motherU;}
	if (parentT!=parentU)
	total=total+parentalHaplotypes->freq;
	}
	}
	return total;
	}

	/*____________________________________________________________ */


	double TrioCountersHapUAndT::getTotalHaplotypes ( long long int hap, Transmission trans, IndCategory ic, Homozygosity h ) 
	{
		if ( ic==offspring || ic==everybody ) throw BadFormat ( string ( "TrioCountersHapUAndT::getTotalMeiosis" ) );
		ParentalHaplotypes* parentalHaplotypes;
		double total=0;
		long long int parentT, parentU, chosenParent;


		for ( ParentalHaplotypesList::iterator it=haplotypeCounts->begin(); it<haplotypeCounts->end(); it++ )
			if ( *it!=NULL )
			{
				parentalHaplotypes= ( ParentalHaplotypes* ) haplotypeCounts->getElement ( it );
				for ( int parentC=0; parentC<2; parentC++ )
					if ( ic==parent || parentC==0 && ic==father || parentC==1 && ic==mother )
					{
						if ( parentC==0 ) {parentT=parentalHaplotypes->fatherT; parentU=parentalHaplotypes->fatherU;}
						else {parentT=parentalHaplotypes->motherT; parentU=parentalHaplotypes->motherU;}
						for ( int tr=1; tr<3; tr++ )
							if ( ( int ) trans==tr || trans==ut )
								if ( ( parentT==hap && tr==1 ) || ( parentU==hap && tr==2 ) )
									if ( ( parentT!=parentU && h==onlyHetero ) || ( parentT==parentU && h==onlyHomo ) || h==allHomozygosity )
										total=total+parentalHaplotypes->freq;
					}
			}
		return total;
	}





};  // End of Namespace

#endif

/* End of file: MultimarkerMeasure.h */

//stringList * BIOS::TrioCountersHapUAndT::getTDTFreqsResults(SNPPos snpPos)
//{
//}






