/* File: MultimarkerMeasure.h */


#ifndef __TrioCountersHapUAndTKnownHaps_cpp__
#define __TrioCountersHapUAndTKnownHaps_cpp__





//using namespace stats;

namespace BIOS {


/**********************************/
/* DEFINITIONS OF THE FUNCTIONS */
/**********************************/



///////////////////
//// public ////////
///////////////////

/*____________________________________________________________ */

TrioCountersHapUAndTKnownHaps* TrioCountersHapUAndTKnownHaps::clone()
{
return new TrioCountersHapUAndTKnownHaps(*this);
} 


/*_________________________________________________________________*/

TrioCountersHapUAndTKnownHaps::TrioCountersHapUAndTKnownHaps(TrioCountersHapUAndTKnownHaps& source):TrioCountersHapUAndT((TrioCountersHapUAndT&) source)
{
}

/*_________________________________________________________________*/
/*
TrioCountersHapUAndTKnownHaps::TrioCountersHapUAndTKnownHaps(TrioCountersHapUAndT& source):TrioCountersHapUAndT(source)
{
set();
}
/*_________________________________________________________________*/

TrioCountersHapUAndTKnownHaps::TrioCountersHapUAndTKnownHaps(TrioCounters* source):TrioCountersHapUAndT(source)
{
//cout << "counts father:" << *multimarkerMeasure->genotypeCountsFather;
set();
}
/*_________________________________________________________________*/

TrioCountersHapUAndTKnownHaps::TrioCountersHapUAndTKnownHaps(SNPPos Pos[], SNPPos totalPos, TrioSample * samp, int affectation)  throw (OutOfRange<long long int>) :TrioCountersHapUAndT(Pos,  totalPos, samp,  affectation)
{
set();
}
/*_________________________________________________________________*/

void TrioCountersHapUAndTKnownHaps::set()
{
totalHaplotypes=0;
this->haplotypeCounts=new ParentalHaplotypeList();
ParentalHaplotypes* parentalHaplotypes;
long long int *  hT, * hU, valueFather, valueMother, *value, hap;
for (int i=0; i<this->trioCounters->genotypeCountsFather->size(); i++)
{
valueFather=this->trioCounters->genotypeCountsFather->getElement(i);
valueMother=this->trioCounters->genotypeCountsMother->getElement(i);
parentalHaplotypes=new ParentalHaplotypes();

parentalHaplotypes->freq=1;
parentalHaplotypes->trioCount=i;
for (int par=0; par<2; par++)
{
if (par==0) {hT=&parentalHaplotypes->fatherT; hU=&parentalHaplotypes->fatherU; value=&valueFather;}
else {hT=&parentalHaplotypes->motherT; hU=&parentalHaplotypes->motherU;value=&valueMother;}
*hT=-1;
*hU=-1;
if (*value!=-1)
{
*hT=getHap(*value, true);
*hU=getHap(*value, false);
}
}
if (parentalHaplotypes->allKnown())
{
this->haplotypeCounts->insertElement(parentalHaplotypes);
totalHaplotypes=totalHaplotypes+4;
}
//else cout <<"\nunknown" << parentalHaplotypes;
//exit(0);
}
setSNPFreqs();
//cout <<"\n\n\n\n" << *trioCounters;

//cout <<"\n\n\n\n" << *this->haplotypeCounts;
//exit(0);
if (totalHaplotypes==0) this->~TrioCountersHapUAndTKnownHaps();
}



/*_________________________________________________________________*/


long long int TrioCountersHapUAndTKnownHaps::getHap(const long long int value, bool left)
{
long long int result=-2;
if (this->trioCounters->tableGenotypes->getTotalSolvedConfs(value)==1)
 result=this->trioCounters->tableGenotypes->getSolvedConf(value, 0, left, this->haplotypeTable);
//else throw BadFormat("TrioCountersHapUAndTKnownHaps::getHap(int*gene, long long int genePartnerPos, bool side)");
return result;
}

/*_________________________________________________________________*/

/*
longLongList* TrioCountersHapUAndTKnownHaps::getHaplotypeCountsFromGenotypes(IndCategory ic, Transmission trans)
{
longLongList* hapCounts=new longLongList(), *l;
int* gene, *hap, h, genePartnerPos;
longLongList::iterator p;
long long int cont, cont2;

for (int i=0; i<2;i++)
if ((ic==(IndCategory) i) || (ic>=3))
//if ((ic==father && i==0) || (ic==mother && i==1) || (ic==offspring && i==2) || (ic==3) || (ic==4 && i<2))
{
switch (i)
{
case 0: l=trioCounters->genotypeCountsFather; break;
case 1: l=trioCounters->genotypeCountsMother; break;
}

if (l!=NULL)
for (longLongList::iterator it=l->begin(); it<l->end(); it++)
if (l->getElement(it)!=-1)
if (!trioCounters->tableGenotypes->hasSameValues(l->getElement(it))) // only heterozygous
{
gene=trioCounters->tableGenotypes->getPositions(l->getElement(it));
for (int side=0; side<2;side++)
if ((trans==t && side==1) || (trans==u && side==0) || trans==ut)
hapCounts->insertElement(getHap(gene, side));
zaparr(gene);
};
}
return hapCounts;
}

/*_________________________________________________________________*/
/*
HeteroListPair<long long int, double>* TrioCountersHapUAndTKnownHaps::getComposedList(longLongList *fatherHaps, longLongList* motherHaps)
{
long long int pos, pos2;
HeteroListPair<long long int, double>* result=new HeteroListPair<long long int, double>();
longLongList* haps=fatherHaps;
longLongList::iterator it;
for (int parent=0; parent<2; parent++)
{
if (parent==1) haps=motherHaps;
for (int i=0; i<haps->size(); i++)
{
pos=haps->getElement(i);
result->addValue(pos, 1);
}
}
return result;
}


/*_______________________________________________________________*/
/*
void TrioCountersHapUAndTKnownHaps::setHaplotypeFreqs(longLongList* fatherCountsT, longLongList* fatherCountsU, longLongList* motherCountsT, longLongList* motherCountsU)
{
this->haplotypeCounts=new ParentalHaplotypeList();
ParentalHaplotypes parentalHaplotypes;
for (int i=0; i<fatherCountsT->size(); i++)
{
parentalHaplotypes.fatherT=fatherCountsT->getElement(i);
parentalHaplotypes.fatherU=fatherCountsU->getElement(i);
parentalHaplotypes.motherT=motherCountsT->getElement(i);
parentalHaplotypes.motherU=motherCountsU->getElement(i);
parentalHaplotypes.freq=1;
parentalHaplotypes.trioCount=i;
if (parentalHaplotypes.allKnown())
this->haplotypeCounts->insertElement(parentalHaplotypes);
}
}

/*_________________________________________________________________*/

TrioCountersHapUAndTKnownHaps * TrioCountersHapUAndTKnownHaps::getPermutation ()
{
TrioCounters* tempResult=this->trioCounters->getPermutation();
TrioCountersHapUAndTKnownHaps* result=new TrioCountersHapUAndTKnownHaps(tempResult);
return result;
}
/*____________________________________________________________ */
/*

double TrioCountersHapUAndTKnownHaps::getStandardizedSimilarityMeasure (IndCategory ic)
// for Length contrast test
{
return getTest(1, ic);
}
/


/*____________________________________________________________ */



};  // End of Namespace

#endif

/* End of file: MultimarkerMeasure.h */




