/* File: MultimarkerMeasure.h */


#ifndef __TrioCountersHapUAndT_cpp__
#define __TrioCountersHapUAndT_cpp__





//using namespace stats;

namespace BIOS {


/**********************************/
/* DEFINITIONS OF THE FUNCTIONS */
/**********************************/



///////////////////
//// public ////////
///////////////////

/*____________________________________________________________ */
/*
TrioCountersHapUAndT* TrioCountersHapUAndT::clone()
{
return new TrioCountersHapUAndT(*this);
} 
/*_________________________________________________________________*/

void TrioCountersHapUAndT::set(TrioCountersHapUAndT& source)
{
//haplotypeCounts=NULL;

haplotypeCounts=NULL;
SNPAbsFreqsFatherT=NULL;
SNPAbsFreqsFatherU=NULL;
SNPAbsFreqsMotherT=NULL;
SNPAbsFreqsMotherU=NULL;
trioCounters=NULL;
hapByFreqs=NULL;
hapByFreqsT=NULL;
hapByFreqsU=NULL;
totalMeiosis=source.totalMeiosis;
totalUsedHaplotypes=source.totalUsedHaplotypes;
totalDifferentHaplotypes=source.totalDifferentHaplotypes;
totalUsedDifferentHaplotypes=source.totalUsedDifferentHaplotypes;
minFreq=source.minFreq;
if (source.trioCounters=NULL) trioCounters=new TrioCounters(*source.trioCounters);
if (source.haplotypeCounts!=NULL) haplotypeCounts=new ParentalHaplotypeList(*source.haplotypeCounts);
if (source.haplotypeTable!=NULL) 
{
haplotypeTable=new MultidimensionalEmptyTable<int>(*source.haplotypeTable);
setSNPFreqs();
}
if (source.hapByFreqs!=NULL) hapByFreqs=new FreqAndKeyVector(*source.hapByFreqs);
if (source.hapByFreqsT!=NULL) hapByFreqs=new FreqAndKeyVector(*source.hapByFreqsT);
if (source.hapByFreqsU!=NULL) hapByFreqs=new FreqAndKeyVector(*source.hapByFreqsU);
}
/*_________________________________________________________________*/

TrioCountersHapUAndT::TrioCountersHapUAndT(TrioCountersHapUAndT& source)
{
set(source);
}
/*_________________________________________________________________*/

TrioCountersHapUAndT::TrioCountersHapUAndT(TrioCounters* source, PhaseAlg phaseAlg, EMDistributions emDistributions, EMRestriction emRestriction, bool onlyHetero, int minFreq)
{
this->onlyHetero=onlyHetero;
this->phaseAlg=phaseAlg;
this->minFreq=minFreq;
this->emDistributions=emDistributions;
this->emRestriction=emRestriction;
haplotypeTable=NULL;
SNPAbsFreqsFatherT=NULL;
SNPAbsFreqsFatherU=NULL;
SNPAbsFreqsMotherT=NULL;
SNPAbsFreqsMotherU=NULL;
hapByFreqs=NULL;
hapByFreqsT=NULL;
hapByFreqsU=NULL;
trioCounters=source;
setHaplotypeTable();
haplotypeCounts=NULL;
setHaplotypeCounts();
 if (haplotypeTable!=NULL) setTotalHaplotypes();
if (haplotypeTable!=NULL)
{
setSNPFreqs();
setHapByFreqs();
}
}
/*_________________________________________________________________*/

TrioCountersHapUAndT::TrioCountersHapUAndT(SNPPos Pos[], SNPPos totalPos, TrioSample * samp, int affectation, PhaseAlg phaseAlg, EMDistributions emDistributions, EMRestriction emRestriction, bool includeMissing, bool onlyHetero, int minFreq)  throw (OutOfRange<long long int>,OutOfRange<int>, NoMemory, BadFormat, NullValue)
{
if (Pos==NULL)
throw NullValue("TrioCountersHapUAndT::TrioCountersHapUAndT(SNPPos Pos[], SNPPos totalPos, TrioSample * samp, int affectation, PhaseAlg phaseAlg, EMDistributions emDistributions, EMRestriction emRestriction, bool includeMissing, bool onlyHetero, int minFreq)");
this->onlyHetero=onlyHetero;
this->minFreq=minFreq;
this->phaseAlg=phaseAlg;
this->emDistributions=emDistributions;
this->emRestriction=emRestriction;
trioCounters=new TrioCounters(Pos, totalPos, samp, affectation, includeMissing); // false for non-tdt (homo included)
haplotypeTable=NULL;
setHaplotypeTable();
haplotypeCounts=NULL;
SNPAbsFreqsFatherT=NULL;
SNPAbsFreqsFatherU=NULL;
SNPAbsFreqsMotherT=NULL;
SNPAbsFreqsMotherU=NULL;
hapByFreqs=NULL;
hapByFreqsT=NULL;
hapByFreqsU=NULL;
setHaplotypeCounts();
 if (haplotypeTable!=NULL) setTotalHaplotypes();
if (haplotypeTable!=NULL)
{
setSNPFreqs();
setHapByFreqs();
}
}
/*_________________________________________________________________*/

TrioCountersHapUAndT * TrioCountersHapUAndT::getPermutation ()
{
TrioCounters* tempResult=this->trioCounters->getPermutation();
TrioCountersHapUAndT* result=new TrioCountersHapUAndT(tempResult, phaseAlg, emDistributions, emRestriction, onlyHetero, minFreq);
return result;
}

/*_________________________________________________________________*/

Pair<Pair<MultidimensionalTable<double>*>*>*  TrioCountersHapUAndT::getKnownHaplotypeFreqs()
{
Pair<Pair<MultidimensionalTable<double>*>*>* result=new Pair<Pair<MultidimensionalTable<double>*>*>();

long long int hT, hU, valueFather, valueMother, *value, hap;
intList* dimList=new intList();
MultidimensionalTable<double>* parentT, *parentU;
for (int i=0; i<trioCounters->totalPos;i++) dimList->insertElement(trioCounters->genotypeArray->totalAlleles[i]);
result->First=new Pair<MultidimensionalTable<double>*>();
result->Second=new Pair<MultidimensionalTable<double>*>();
result->First->First=new MultidimensionalTable<double>(dimList);
result->First->Second=new MultidimensionalTable<double>(dimList);
result->Second->First=new MultidimensionalTable<double>(dimList);
result->Second->Second=new MultidimensionalTable<double>(dimList);
for (int i=0; i<this->trioCounters->genotypeCountsFather->size(); i++)
{
valueFather=this->trioCounters->genotypeCountsFather->getElement(i);
valueMother=this->trioCounters->genotypeCountsMother->getElement(i);
for (int pari=0; pari<2; pari++)
{
if (pari==0) {parentT=result->First->First; parentU=result->First->Second; value=&valueFather;}
else {parentT=result->Second->First; parentU=result->Second->Second; value=&valueMother;}
if (*value>=0)
{
hT=getHap(*value, true);
hU=getHap(*value, false);
if (hT>0 && hU>0)
{
 parentT->addValue(hT, 1);
 parentU->addValue(hU, 1);
}
}
}
}
zap(dimList);
return result;
}
/*_________________________________________________________________*/


long long int TrioCountersHapUAndT::getHap(const long long int value, bool left)
{
long long int result=-2;
if (this->trioCounters->genotypeArray->getTotalSolvedConfs(value)==1)
{
 result=this->trioCounters->genotypeArray->getSolvedConf(value, 0, left, this->haplotypeTable);
}
 return result;
}


/*_______________________________________________________________*/

double TrioCountersHapUAndT::getNormalizationValue(int totalConfigurations, long long int ambiguousPosFather, long long int ambiguousPosMother, Pair<MultidimensionalTable<double>*>* haplotypeFreqsTabPairFather,
Pair<MultidimensionalTable<double>*>* haplotypeFreqsTabPairMother)
{
double result=0, total=0, totalRealConfs=0, currentFrequency;
ParentalHaplotypes *parentalHaplotype;
for (int j=0; j<totalConfigurations; j++)
{
parentalHaplotype=getParentalHaplotypes(ambiguousPosFather, ambiguousPosMother, j);
currentFrequency=getCurrentFrequency(haplotypeFreqsTabPairFather, haplotypeFreqsTabPairMother, parentalHaplotype);
zap(parentalHaplotype);
total=total+currentFrequency; //totalConfigurations;
}
return total;
}


/*_______________________________________________________________*/


void TrioCountersHapUAndT::setHaplotypeCounts()
{
totalMeiosis=0;
Pair<Pair<MultidimensionalTable<double>*>*>* haplotypeFreqsTabPairParents=getHaplotypeFreqsTab();
//cout <<"here:" << *haplotypeFreqsTabPairParents->First->First << "\n";
//cout <<"here:" << *haplotypeFreqsTabPairParents->First->Second << "\n";
//cout <<"here:" << *haplotypeFreqsTabPairParents->Second->First << "\n";
//cout <<"here:" << *haplotypeFreqsTabPairParents->Second->Second << "\n";
ParentalHaplotypes *parentalHaplotypes, *chosenParentalHaplotypes;
this->haplotypeCounts=new ParentalHaplotypeList();
int totalConfigurations;
double maxFrequency=0, currentFrequency, total=0;
long long int ambiguousPosFather, ambiguousPosMother;
for (long long int i=0; i<trioCounters->genotypeCountsFather->size(); i++)
if (trioCounters->genotypeCountsFather->getElement(i)>=0 && trioCounters->genotypeCountsMother->getElement(i)>=0)
{ 
maxFrequency=-1;
ambiguousPosFather=trioCounters->genotypeCountsFather->getElement(i);
ambiguousPosMother=trioCounters->genotypeCountsMother->getElement(i);
totalConfigurations=trioCounters->genotypeArray->getTotalSolvedConfs(ambiguousPosFather);
if (phaseAlg==weighted) total=getNormalizationValue(totalConfigurations, ambiguousPosFather, ambiguousPosMother, haplotypeFreqsTabPairParents->First, haplotypeFreqsTabPairParents->Second);
for (int j=0; j<totalConfigurations; j++)
{
parentalHaplotypes=getParentalHaplotypes(ambiguousPosFather, ambiguousPosMother, j);
parentalHaplotypes->trioCount=i;
if (phaseAlg!=onlyKnown)
currentFrequency=getCurrentFrequency(haplotypeFreqsTabPairParents->First, haplotypeFreqsTabPairParents->Second, parentalHaplotypes);

if (phaseAlg==maxFreq)
if (maxFrequency<=currentFrequency) 
{
maxFrequency=currentFrequency; 
chosenParentalHaplotypes=parentalHaplotypes;
}

if (phaseAlg==weighted)
{
if (total==0)
{
parentalHaplotypes->freq=(1/(double)totalConfigurations);
this->haplotypeCounts->insertElement(parentalHaplotypes);
} 
else
if (currentFrequency/total>zero)
{
parentalHaplotypes->freq=(currentFrequency/total);//totalConfigurations;
//else parentalHaplotypes->freq=currentFrequency/totalConfigurations;
//if (parentalHaplotypes->freq>zero)
this->haplotypeCounts->insertElement(parentalHaplotypes);
}
}
}// end for each conf
if (phaseAlg==maxFreq)
{
chosenParentalHaplotypes->freq=1;
parentalHaplotypes=chosenParentalHaplotypes;
this->haplotypeCounts->insertElement(parentalHaplotypes);
}
if ((phaseAlg==onlyKnown && totalConfigurations==1) || phaseAlg!=onlyKnown) 
{
if (phaseAlg==onlyKnown) this->haplotypeCounts->insertElement(parentalHaplotypes);
if (!onlyHetero) totalMeiosis=totalMeiosis+2;
else
{
if (parentalHaplotypes->fatherT!=parentalHaplotypes->fatherU)
totalMeiosis=totalMeiosis+1;
if (parentalHaplotypes->motherT!=parentalHaplotypes->motherU)
totalMeiosis=totalMeiosis+1;
}
}
}
haplotypeFreqsTabPairParents->First->empty();
haplotypeFreqsTabPairParents->Second->empty();
haplotypeFreqsTabPairParents->empty();
zap(haplotypeFreqsTabPairParents);
if (totalMeiosis==0) this->~TrioCountersHapUAndT();
}
/*_______________________________________________________________*/

double TrioCountersHapUAndT::getCurrentFrequency(Pair<MultidimensionalTable<double>*>* haplotypeFreqsTabPairFather,
Pair<MultidimensionalTable<double>*>* haplotypeFreqsTabPairMother, ParentalHaplotypes *parentalHaplotype)
{
if (1==0)
if (parentalHaplotype->trioCount==4)
{
cout << "\nf1: " << haplotypeFreqsTabPairFather->First->getValue(parentalHaplotype->fatherT);
cout << "\nf2: " << haplotypeFreqsTabPairFather->Second->getValue(parentalHaplotype->fatherU);
cout << "\nf3: " << haplotypeFreqsTabPairMother->First->getValue(parentalHaplotype->motherT);
cout << "\nf4: " << haplotypeFreqsTabPairMother->Second->getValue(parentalHaplotype->motherU);
cout <<"\nv1:" << parentalHaplotype->fatherT <<", v2: " << parentalHaplotype->fatherU << ", v3: " << parentalHaplotype->motherT <<" , and v4 : " << parentalHaplotype->motherU;
}
return haplotypeFreqsTabPairFather->First->getValue(parentalHaplotype->fatherT)*haplotypeFreqsTabPairMother->First->getValue(parentalHaplotype->motherT)*haplotypeFreqsTabPairFather->Second->getValue(parentalHaplotype->fatherU)*haplotypeFreqsTabPairMother->Second->getValue(parentalHaplotype->motherU);
}
/*_______________________________________________________________*/

ParentalHaplotypes* TrioCountersHapUAndT::getParentalHaplotypes(long long int ambiguousConfFather, long long int ambiguousConfMother, int binaryKnownConfiguration)
{
ParentalHaplotypes *parentalHaplotype=new ParentalHaplotypes();
parentalHaplotype->fatherT=trioCounters->genotypeArray->getSolvedConf(ambiguousConfFather, binaryKnownConfiguration, true,  this->haplotypeTable);
parentalHaplotype->fatherU=trioCounters->genotypeArray->getSolvedConf(ambiguousConfFather, binaryKnownConfiguration, false,  this->haplotypeTable);
parentalHaplotype->motherT=trioCounters->genotypeArray->getPartnerSolvedConf(binaryKnownConfiguration, ambiguousConfFather, ambiguousConfMother, true, this->haplotypeTable);
parentalHaplotype->motherU=trioCounters->genotypeArray->getPartnerSolvedConf(binaryKnownConfiguration, ambiguousConfFather, ambiguousConfMother, false, this->haplotypeTable);
parentalHaplotype->freq=1;
return parentalHaplotype;
}
/*_______________________________________________________________*/

Pair<Pair<MultidimensionalTable<double>*>*>* TrioCountersHapUAndT::getHaplotypeFreqsTab() throw (NoMemory, BadFormat)
{
// It computes the haplotype frequencies
MultidimensionalTable<double>* genotypeAbsFreqsTab=NULL;
MultidimensionalTable<longLongList*>* pointersToPartnerGenotypes=NULL;
if (phaseAlg==onlyKnown) return getKnownHaplotypeFreqs();
if (emRestriction==noRestriction) 
genotypeAbsFreqsTab=trioCounters->getGenotypeAbsFreqs(parent);
else // triosBased restriction
{
genotypeAbsFreqsTab=trioCounters->getGenotypeAbsFreqs(father);
//cout << "abs:" << *genotypeAbsFreqsTab <<"\n";
//exit(0);
pointersToPartnerGenotypes=trioCounters->getPointersToPartnerGenotypes(mother);
}

Pair<Pair<MultidimensionalTable<double>*>*>*result=getHaplotypeFreqsTab(0, genotypeAbsFreqsTab, pointersToPartnerGenotypes);

if (result->First==NULL) result=getHaplotypeFreqsTab(1, genotypeAbsFreqsTab, pointersToPartnerGenotypes);
if (result->First==NULL)
throw NullValue(" at TrioCountersHapUAndT::getHaplotypeFreqsTab");


zap(pointersToPartnerGenotypes);
zap(genotypeAbsFreqsTab);

return result;
}
/*_______________________________________________________________*/

MultidimensionalTable<double>* TrioCountersHapUAndT::getInitialEstimation(int type)
{
double value;
int *position;
intList* dimList=new intList();
for (int i=0; i<trioCounters->totalPos;i++) dimList->insertElement(trioCounters->genotypeArray->totalAlleles[i]);
MultidimensionalTable<double>* currentEstimation=new MultidimensionalTable<double>(dimList);
zap(dimList);
double total=0;
for (int i=0; i<currentEstimation->getSize();i++) 
{
 position=currentEstimation->getPositions(i);
 switch(type)
{
case 0: //independent loci
 value=1;
 for (int j=0; j<trioCounters->totalPos; j++)
  value=value*(trioCounters->SNPAbsFreqsFather[j][position[j]]+trioCounters->SNPAbsFreqsMother[j][position[j]])/(trioCounters->totalGenotypes*2);
break;
case 1://uniform
 value=1/(double)currentEstimation->getSize();
break;
}
 currentEstimation->setValue(i, value);
 zap(position);
 total=total+value;
}
return currentEstimation;
}

/*_______________________________________________________________*/

Pair<Pair<MultidimensionalTable<double>*>*>* TrioCountersHapUAndT::getHaplotypeFreqsTab(int type, MultidimensionalTable<double>* genotypeAbsFreqsTab, MultidimensionalTable<longLongList*>* pointersToPartnerGenotypes) throw (NoMemory, BadFormat)
{
if (phaseAlg==onlyKnown) throw BadFormat("TrioCountersHapUAndTUnknownHaps::getHaplotypeFreqsTab");
Pair<Pair<MultidimensionalTable<double>*>*>* result=new Pair<Pair<MultidimensionalTable<double>*>*>();
result->First=new Pair<MultidimensionalTable<double>*>();
result->Second=new Pair<MultidimensionalTable<double>*>();

result->First->First=this->getInitialEstimation(type);
//cout << *result->First->First <<"\n";

result->First->Second=NULL;
result->Second->First=NULL;
result->Second->Second=NULL;
double totalHaps=trioCounters->totalGenotypes*2;
if (emDistributions==UTDistributions) 
{
result->First->Second=new MultidimensionalTable<double>(*result->First->First);
//cout << "\nSecon:\n"<< *result->First->Second <<"\n";
//totalHaps=totalHaps/2;
}
if (emRestriction==triosBasedRestriction)
{
//totalHaps=totalHaps/2;
result->Second->First=new MultidimensionalTable<double>(*result->First->First);
//cout << "\ntir:\n"<< *result->Second->First <<"\n";
if (emDistributions==UTDistributions) result->Second->Second=new MultidimensionalTable<double>(*result->First->First);
//cout << "\nfour:\n"<< *result->Second->Second <<"\n";
}
//exit(0);
//cout <<"\nbefore:"<< *result->First->First <<"\n"<< *result->First->Second <<"\n";
//cout <<"\nbefore:"<< *result->Second->First <<"\n";
//cout <<"bef\n";
//if (result->Second->Second!=NULL) cout << *result->Second->Second <<"\n";
//exit(0);
//cout <<"geabs:" << *genotypeAbsFreqsTab <<"\n";
//exit(0);
//cout <<"partmer:" << *pointersToPartnerGenotypes <<"\n";
//exit(0);

this->trioCounters->genotypeArray->estimateMLE(result->First->First, genotypeAbsFreqsTab, pointersToPartnerGenotypes, totalHaps, 1000, result->First->Second, result->Second->First, result->Second->Second, this->haplotypeTable);
//cout <<"at\n";
//if (result->Second->First!=NULL)
//cout <<"\nafter:"<< *result->Second->First <<"\n";
//if (result->Second->Second!=NULL) cout << *result->Second->Second <<"\n";
if (emDistributions==oneDistribution) 
{
result->First->Second=new MultidimensionalTable<double>(*result->First->First);
result->Second->Second=new MultidimensionalTable<double>(*result->First->Second);
if (emRestriction==noRestriction)
result->Second->First=new MultidimensionalTable<double>(*result->First->Second);
}
else if (emRestriction==noRestriction)
{
result->Second->First=new MultidimensionalTable<double>(*result->First->First);
result->Second->Second=new MultidimensionalTable<double>(*result->First->Second);
}


return result;
}

/*_________________________________________________________________*/

void TrioCountersHapUAndT::setTotalHaplotypes()
{
totalDifferentHaplotypes=0;
totalUsedDifferentHaplotypes=0;
totalUsedHaplotypes=0;
double totalHaplotypes;
for (long long int key=0; key<haplotypeTable->getSize(); key++)
{
totalHaplotypes=getTotalHaplotypes(key, ut, parent);
if (totalHaplotypes>0) totalDifferentHaplotypes++;
if (totalHaplotypes>=minFreq && totalHaplotypes>0) 
{
totalUsedDifferentHaplotypes++;
totalUsedHaplotypes=totalUsedHaplotypes+getTotalHeteroGenotypes(key, parent);
if (!onlyHetero) totalUsedHaplotypes=totalUsedHaplotypes+getTotalHomoGenotypes(key, parent)*2;
}
}
if (totalUsedDifferentHaplotypes<2) this->~TrioCountersHapUAndT();
}
/*_________________________________________________________________*/

double TrioCountersHapUAndT::getTotalUsedDifferentHaplotypesInG1()
{
double result=0.0; 
double totalCountsT, totalCountsU, totalCounts;
for (long long int key=0; key<haplotypeTable->getSize(); key++)
{
totalCounts=getTotalHaplotypes(key, ut, parent);
totalCountsT=getTotalHaplotypes(key, t, parent);
totalCountsU=getTotalHaplotypes(key, u, parent);
if (totalCountsT>totalCountsU && totalCounts>=minFreq) 
result++;
}
return result;
}
/*_________________________________________________________________*/

double TrioCountersHapUAndT::getTotalUsedHaplotypesInG(bool g1)
{
double result=0.0; 
double totalCountsT, totalCountsU, totalCounts;
for (long long int key=0; key<haplotypeTable->getSize(); key++)
{
totalCounts=getTotalHaplotypes(key, ut, parent);
totalCountsT=getTotalHaplotypes(key, t, parent);
totalCountsU=getTotalHaplotypes(key, u, parent);
if (totalCounts>=minFreq) 
if (totalCountsT>totalCountsU && g1) 
result=result+totalCountsT;
else
if (totalCountsT<totalCountsU && !g1) 
result=result+totalCountsU;
}
return result;
}

/*_________________________________________________________________*/

FreqAndKeyVector* TrioCountersHapUAndT::getUsedHaplotypes(Transmission trans)
 {
if (hapByFreqs==NULL) setHapByFreqs();
switch(trans)
{
case t: return hapByFreqsT; break;
case u: return hapByFreqsU; break;
case ut: return hapByFreqs; break;
}
}

/*_________________________________________________________________*/

MultidimensionalEmptyTable<int>* TrioCountersHapUAndT::getHaplotypeArray()
{
return haplotypeTable;
}
/*_________________________________________________________________*/

FreqAndKeyVector* TrioCountersHapUAndT::getUsedHaplotypesInG(bool g1, Transmission trans)
 {
FreqAndKeyVector* result=new FreqAndKeyVector();
FreqAndKey *val=NULL;
double totalCountsT, totalCountsU, totalCounts, realTotalCounts;
for (long long int key=0; key<haplotypeTable->getSize(); key++)
{
totalCounts=getTotalHaplotypes(key, ut, parent);
totalCountsT=getTotalHaplotypes(key, t, parent);
totalCountsU=getTotalHaplotypes(key, u, parent);
if (totalCounts>=minFreq && totalCounts>0) 
if ((totalCountsT>totalCountsU && g1) || (totalCountsT<=totalCountsU && trans==u) || !g1)
{
realTotalCounts=totalCountsT;
if (trans==u) realTotalCounts=totalCountsU;
val=new FreqAndKey(realTotalCounts, key);
result->insertElement(val);
}
}
return result;
};
/*_________________________________________________________________*/

stringList* TrioCountersHapUAndT::getListOfUsedHaplotypesInG(bool g1, Transmission trans, bool onlyOneTime)
 {
stringList* result=new stringList();
double totalCountsT, totalCountsU, totalCounts, realTotalCounts;
intList* posList;
string hap;
for (long long int key=0; key<haplotypeTable->getSize(); key++)
{
totalCounts=getTotalHaplotypes(key, ut, parent);
totalCountsT=getTotalHaplotypes(key, t, parent);
totalCountsU=getTotalHaplotypes(key, u, parent);
if (totalCounts>=minFreq && totalCounts>0)
if ((totalCountsT>totalCountsU && g1) || (totalCountsT<=totalCountsU && !g1))
{
realTotalCounts=totalCountsT;
if (trans==u) realTotalCounts=totalCountsU;
posList=haplotypeTable->getPosList(key);
hap=string("");
for (int i=0; i<posList->size(); i++)
hap=hap+tos(trioCounters->genotypeArray->getAllele(i, posList->getElement(i)));
if (onlyOneTime)
result->insertElement(hap);
else
for (int a=0; a<realTotalCounts; a++)
result->insertElement(hap);
}
}
return result;
};
/*_________________________________________________________________*/

stringList* TrioCountersHapUAndT::getListOfUsedHaplotypes(Transmission trans, bool onlyOneTime)
 {
stringList* result=new stringList();
double totalCountsUsed, totalCounts;
intList* posList;
string hap;
for (long long int key=0; key<haplotypeTable->getSize(); key++)
{
totalCountsUsed=getTotalHaplotypes(key, ut, parent);
totalCounts=getTotalHaplotypes(key, trans, parent);
if (totalCountsUsed>=minFreq && totalCounts>0)
{
posList=haplotypeTable->getPosList(key);
hap=string("");
for (int i=0; i<posList->size(); i++)
hap=hap+tos(posList->getElement(i));
if (onlyOneTime)
result->insertElement(hap);
else
for (int a=0; a<totalCounts; a++)
result->insertElement(hap);
}
}
return result;
};
/*_________________________________________________________________*/

stringList* TrioCountersHapUAndT::getTDTFreqsResults()
 {
stringList* result=new stringList();
 result->insertElement(string("Haplotypes: "));
 result->paste(getListOfUsedHaplotypes(ut, true));
 result->insertElement(string("\nT: ")); 
 result->paste(getTDTFreqs(t, parent));
 result->insertElement(string("\nU: ")); 
 result->paste(getTDTFreqs(u, parent));
return result;
}
/*_________________________________________________________________*/

stringList* TrioCountersHapUAndT::getG2Results(bool g1, double pValue, SNPPos snpPos)
 {
double totalUsedDifferentHaplotypesInG1=getTotalUsedDifferentHaplotypesInG1();
double totalUsedHaplotypesInG1=getTotalUsedHaplotypesInG(true);
stringList* result=new stringList();
result->insertElement(tos(snpPos));
result->insertElement(tos(pValue));
result->insertElement(tos(totalUsedDifferentHaplotypesInG1));
result->insertElement(tos(totalUsedDifferentHaplotypes));
result->insertElement(tos(totalUsedHaplotypesInG1));
result->insertElement(tos(totalUsedHaplotypes));
if (totalUsedHaplotypesInG1<totalUsedHaplotypes/2)  
if (g1)
 { result->insertElement(tos(totalUsedHaplotypesInG1));
   result->paste(getListOfUsedHaplotypesInG(true,t, false));
}
else
{
result->insertElement(tos(getTotalUsedHaplotypesInG(false)));
result->paste(getListOfUsedHaplotypesInG(false,u, false));
}
else 
if (g1) 
{
result->insertElement(tos(getTotalUsedHaplotypesInG(true)));
result->paste(getListOfUsedHaplotypesInG(false,u, false));
}
else 
{
result->insertElement(tos(totalUsedHaplotypesInG1));
result->paste(getListOfUsedHaplotypesInG(true,t, false));
}
return result;
};
/*_________________________________________________________________*/

stringList* TrioCountersHapUAndT::getTDTFreqs(Transmission trans, IndCategory ic)
 {
stringList* result=new stringList();
double total;
for (long long int key=0; key<haplotypeTable->getSize(); key++)
{
total=getTotalHaplotypes(key, ut, ic);
if (total>=minFreq && total>0)
result->insertElement(tos(getTotalHaplotypes(key, trans, ic)));
}
return result;
};

/*_________________________________________________________________*/

stringList*  TrioCountersHapUAndT::getHeadFileG2()
 {
stringList *result=new stringList();
result->insertElement(string("FirstSNP"));
result->insertElement("pVal");
result->insertElement("TotalUsedDifferentHaplotypesInG1");
result->insertElement("TotalUsedDifferentHaplotypes");
result->insertElement("TotalFreqG1");
result->insertElement("TotalFreq");
result->insertElement("TotalListSize");
result->insertElement("haplotypeList");
return result;
};
/*_________________________________________________________________*/

stringList*  TrioCountersHapUAndT::getHeadFileTDTFreqs()
 {

stringList *result=new stringList();
result->insertElement(string("T/U"));
result->insertElement(string("Haps freqs ..."));
return result;
};

/*_________________________________________________________________*/

void  TrioCountersHapUAndT::empty()
{
for (int i=0; i<trioCounters->totalPos; i++)
{
if (SNPAbsFreqsFatherT!=NULL) zaparr(SNPAbsFreqsFatherT[i]);
if (SNPAbsFreqsFatherU!=NULL)  zaparr(SNPAbsFreqsFatherU[i]);
if (SNPAbsFreqsMotherT!=NULL) zaparr(SNPAbsFreqsMotherT[i]);
if (SNPAbsFreqsMotherU!=NULL)  zaparr(SNPAbsFreqsMotherU[i]);
}
if (SNPAbsFreqsFatherT!=NULL)  zaparr(SNPAbsFreqsFatherT);
if (SNPAbsFreqsFatherU!=NULL)  zaparr(SNPAbsFreqsFatherU);
if (SNPAbsFreqsMotherT!=NULL)  zaparr(SNPAbsFreqsMotherT);
if (SNPAbsFreqsMotherU!=NULL)  zaparr(SNPAbsFreqsMotherU);

zap(SNPAbsFreqsFatherT);
zap(SNPAbsFreqsMotherT);
zap(SNPAbsFreqsFatherU);
zap(SNPAbsFreqsMotherU);

 zap(trioCounters);
 zap(haplotypeCounts);
 zap(haplotypeTable);
zap(hapByFreqs);
zap(hapByFreqsT);
zap(hapByFreqsU);


	};

/*_________________________________________________________________*/

TrioCountersHapUAndT::TrioCountersHapUAndT()
{
trioCounters=NULL;
haplotypeTable=NULL;
haplotypeCounts=NULL;
totalMeiosis=0;
}
/*______________________________________________________*/

void TrioCountersHapUAndT::setHaplotypeTable()
{

intList* dimList=new intList();
for (int i=0; i<trioCounters->totalPos; i++)
 dimList->insertElement(trioCounters->genotypeArray->totalAlleles[i]);

haplotypeTable=new MultidimensionalEmptyTable<int>(dimList);
//cout <<"hap counts: " << *haplotypeTable;
//exit(0);
zap(dimList);
}
/*______________________________________________________*/

 void TrioCountersHapUAndT::setSNPFreqs()
{
SNPAbsFreqsFatherT=new double*[trioCounters->totalPos];
SNPAbsFreqsFatherU=new double*[trioCounters->totalPos];
SNPAbsFreqsMotherT=new double*[trioCounters->totalPos];
SNPAbsFreqsMotherU=new double*[trioCounters->totalPos];
int al;
double totalSNP=0, freq=0;
for (int i=0; i<trioCounters->totalPos; i++)
{
 SNPAbsFreqsFatherT[i]=Initialize(trioCounters->genotypeArray->totalAlleles[i], 0.0);
 SNPAbsFreqsFatherU[i]=Initialize(trioCounters->genotypeArray->totalAlleles[i], 0.0);
 SNPAbsFreqsMotherT[i]=Initialize(trioCounters->genotypeArray->totalAlleles[i], 0.0);
 SNPAbsFreqsMotherU[i]=Initialize(trioCounters->genotypeArray->totalAlleles[i], 0.0);
}
double** SNPAbsFreqs;
long long int hap;
int i=0, *position;
ParentalHaplotypes* val;
for (ParentalHaplotypeList::iterator it=haplotypeCounts->begin(); it<haplotypeCounts->end(); it++)
{
val=(ParentalHaplotypes*)haplotypeCounts->getElement(it);
for (int trans=0; trans<2; trans++)
{
for (int parent=0; parent<2; parent++)
{
if (trans==0) if (parent==0) {SNPAbsFreqs=SNPAbsFreqsFatherT; hap=val->fatherT;} else {SNPAbsFreqs=SNPAbsFreqsMotherT; hap=val->motherT;} 
else if (parent==0) {SNPAbsFreqs=SNPAbsFreqsFatherU; hap=val->fatherU; } else {SNPAbsFreqs=SNPAbsFreqsMotherU; hap=val->motherU;}
position=haplotypeTable->getPositions(hap);
for (int j=0; j<trioCounters->totalPos; j++)
{
 al=position[j];
 SNPAbsFreqs[j][al]=SNPAbsFreqs[j][al]+val->freq;
}
zaparr(position);
}
}
}
}
/*_______________________________________________________________*/
/*
void TrioCountersHapUAndTUnknownHaps::sethaplotypeCounts()
{
//zap(this->haplotypeCounts);
this->haplotypeCounts=new HeteroListPair<long long int, double>();
this->haplotypeCountsU=new HeteroListPair<long long int, double>();
for (int i=0;i<2;i++)
{
if (i==0) {this->hapFreqs=this->haplotypeCounts; hapFreqsTab=haplotypeCountsTab;}
else  {this->hapFreqs=this->haplotypeCountsU; hapFreqsTab=haplotypeCountsTabU;}
for (long long int i=0; i<hapFreqsTab->getSize(); i++)
if (hapFreqsTab->getValue(i)>0)
{
 this->hapFreqs->First->insertElement(i);
 this->hapFreqs->Second->insertElement(hapFreqsTab->getValue(i)*this->totalMeiosis/2);
}
}
}




/*____________________________________________________________ */


double TrioCountersHapUAndT::getStandardizedSimilarityMeasure (IndCategory ic)
// for Length contrast test
{
return getTest(1, ic);
}

/*____________________________________________________________ */

/*
double TrioCountersHapUAndT::getSimilarityMeasure (IndCategory ic)
// for Length contrast test
{
cout << "Error, TrioCountersHapUAndT::getStandardizedSimilarityMeasure is undefined";
exit(0);
//return getTest(0);
}

/*____________________________________________________________ */
/*

double TrioCountersHapUAndT::getSignedRankTest (bool Wilcoxon, IndCategory ic)
// for Length contrast test
{
cout << "Error, TrioCountersHapUAndT::getSignedRankTest is undefined";
exit(0);
}


/*____________________________________________________________ */


double TrioCountersHapUAndT::getSimilarityMeasure (IndCategory ic)
// for Length contrast test
{
return getTest(0, ic);
}
/*____________________________________________________________ */


double TrioCountersHapUAndT::getSignedRankTest (bool Wilcoxon, IndCategory ic)
// for Length contrast test
{
//cout << "\nsigned rank is:" << 2+!Wilcoxon;
return getTest(2+!Wilcoxon, ic);
}

/*___________________________________________________*/

double TrioCountersHapUAndT::getLengthMeasure (long long int pos1T, long long int pos2T, long long int pos1U, long long int pos2U) 
{
// it is defined as the difference between the transmitted haplotypes of a pair of individuals minus the differences in their non transmitted haplotypes
int *p1T=haplotypeTable->getPositions(pos1T);
int *p2T=haplotypeTable->getPositions(pos2T);
int *p1U=haplotypeTable->getPositions(pos1U);
int *p2U=haplotypeTable->getPositions(pos2U);

int resultT=0, resultU=0, maxResultT=0, maxResultU=0;
for (int i=0; i< trioCounters->totalPos; i++)
{
//cout <<"\n" << pos1T[i] <<"-" << pos2T[i] << "-" << pos1U[i] << "-" << pos2U[i];
if (p1T[i]==p2T[i]) {resultT++;} else {if (resultT>maxResultT) maxResultT=resultT; resultT=0;};
if (p1U[i]==p2U[i]) {resultU++;} else {if (resultU>maxResultU) maxResultU=resultU; resultU=0;};
}
if (resultT>maxResultT) maxResultT=resultT; 
if (resultU>maxResultU) maxResultU=resultU; 
zaparr(p1T);
zaparr(p2T);
zaparr(p1U);
zaparr(p2U);
return (maxResultT-maxResultU)/(double)trioCounters->totalPos;
};
/*___________________________________________________*/
/*
double TrioCountersHapUAndT::getSwitchMeasure (long long int pos1T, long long int pos2T, long long int pos1U, long long int pos2U) 
{
// it is defined as the difference in changes between the transmitted haplotypes of a pair of individuals minus the differences in their non transmitted haplotypes
// it only counts
int *p1T=haplotypeTable->getPositions(pos1T);
int *p2T=haplotypeTable->getPositions(pos2T);
int *p1U=haplotypeTable->getPositions(pos1U);
int *p2U=haplotypeTable->getPositions(pos2U);

int resultT=0, resultU=0, maxResultT=0, maxResultU=0;
for (int i=0; i< trioCounters->totalPos; i++)
{
//cout <<"\n" << pos1T[i] <<"-" << pos2T[i] << "-" << pos1U[i] << "-" << pos2U[i];
if (p1T[i]==p2T[i]) {resultT++;} else {if (resultT>maxResultT) maxResultT=resultT; resultT=0;};
if (p1U[i]==p2U[i]) {resultU++;} else {if (resultU>maxResultU) maxResultU=resultU; resultU=0;};
}
if (resultT>maxResultT) maxResultT=resultT; 
if (resultU>maxResultU) maxResultU=resultU; 
zaparr(p1T);
zaparr(p2T);
zaparr(p1U);
zaparr(p2U);
return (maxResultT-maxResultU)/(double)trioCounters->totalPos;
};


/*____________________________________________________________ */

BidimensionalTable<double>* TrioCountersHapUAndT::getMultiallelicFreqs(SNPPos a, SNPPos b, Transmission trans, IndCategory ic)
{
ParentalHaplotypes *parentalHaplotypes=NULL;
BidimensionalTable<double>*result=new BidimensionalTable<double>(trioCounters->genotypeArray->totalAlleles[a], trioCounters->genotypeArray->totalAlleles[b]); 
int pos, *positions, cont=0;
double totalHaplotypes=this->totalMeiosis*2,  SB=0, p;
if (trans!=ut) totalHaplotypes=totalHaplotypes/2;
if (ic!=parent) totalHaplotypes=totalHaplotypes/2;
for (ParentalHaplotypeList::iterator pointer=haplotypeCounts->begin(); pointer!=haplotypeCounts->end(); pointer++)
{
parentalHaplotypes=(ParentalHaplotypes*)haplotypeCounts->getElement(pointer);
for (int i=0; i<2; i++)
if ((i==0 && trans==t) || (i==1 && trans==u) || trans==ut)
for (int parentT=0; parentT<2; parentT++)
if (parentT==(int)ic || ic==parent)
if (parentalHaplotypes->isKnown(1-parentT))
{
if (i==0) if (parentT==0) pos=parentalHaplotypes->fatherT; else pos=parentalHaplotypes->motherT;
else if (parentT==0) pos=parentalHaplotypes->fatherU; else pos=parentalHaplotypes->motherU;
positions=haplotypeTable->getPositions(pos);
result->addValue(positions[a], positions[b], parentalHaplotypes->freq/totalHaplotypes);
zaparr(positions);
}
cont++;
}
return result;
}

/*____________________________________________________________ */

double TrioCountersHapUAndT::getSquareSB (int type, int hapPosition, Transmission transmissionHapPosition)
{
return getSquareSB(type, t, hapPosition, transmissionHapPosition)-getSquareSB(type, u, hapPosition, transmissionHapPosition);
}
/*____________________________________________________________ */

double TrioCountersHapUAndT::getEntropySB (bool df)
{
return getEntropySB(df, u)-getEntropySB(df, t);
}
/*____________________________________________________________ */

double TrioCountersHapUAndT::getMultimarkerDPrime (int type, bool df)
{
//cout << "\ndprime for t:" << getMultimarkerDPrime(type, df, t) <<", and dprime for u:" << getMultimarkerDPrime(type, df, u);
return getMultimarkerDPrime(type, df, t)-getMultimarkerDPrime(type, df, u);
}


/*____________________________________________________________ */

double TrioCountersHapUAndT::getLinearSB (bool df, Transmission trans)
{
// S_B=-sum_{foreach n hap presents in the sample} p_i 
double totalHaplotypes=this->totalMeiosis*2, total=0;
if (trans!=ut) totalHaplotypes=totalHaplotypes/2;
double SB=0, tCounts, uCounts, counts;


for (long long int key=0; key<haplotypeTable->getSize(); key++)
{
counts=0;
tCounts=getTotalMeiosis(key, t, parent);
uCounts=getTotalMeiosis(key, u, parent);
total=total+tCounts+uCounts;
for (int i=0; i<2; i++)
if ((i==0 && trans==t) || (i==1 && trans==u) || trans==ut)
if (!df || !haplotypeTable->inferredFrequency(key))
{
if (i==0) counts=counts+tCounts;
if (i==1) counts=counts+uCounts;
SB=SB+(counts/totalHaplotypes);
}
}
if (total==0) return -1;
//cout << "\ntransmission:" << this->transmission <<" linearSB:" << SB;
return SB;
}

/*____________________________________________________________ */

void TrioCountersHapUAndT::setHapByFreqs ()
{
hapByFreqs=new FreqAndKeyVector();
hapByFreqsT=new FreqAndKeyVector();
hapByFreqsU=new FreqAndKeyVector();
FreqAndKey* fv;
double total;
for (long long int key=0; key<haplotypeTable->getSize(); key++)
for (int tr=0; tr<3; tr++)
{
total=getTotalHaplotypes(key, (Transmission)tr, parent);
if (total>0)
{
fv=new FreqAndKey();
fv->First=total;
fv->Second=key;
switch ((Transmission)tr)
{
case t: hapByFreqsT->insertElement(fv); break;
case u: hapByFreqsU->insertElement(fv); break;
case ut: hapByFreqs->insertElement(fv); break;
}
}
}
order(hapByFreqs, false);
order(hapByFreqsT, false);
order(hapByFreqsU, false);
}
/*____________________________________________________________ */

long long int TrioCountersHapUAndT::getHapAtPosition (int hapPosition, Transmission transmissionHapPosition)
{
FreqAndKeyVector* values;
switch (transmissionHapPosition)
{
case t: values=hapByFreqsT; break;
case u: values=hapByFreqsU; break;
case ut: values=hapByFreqs; break;
}
return (long long int) values->getElement(hapPosition-1)->Second;
}
/*____________________________________________________________ */

int TrioCountersHapUAndT::getPositionForHap (long long int hap, Transmission transmissionHapPosition)
{
FreqAndKeyVector* values;
switch (transmissionHapPosition)
{
case t: values=hapByFreqsT; break;
case u: values=hapByFreqsU; break;
case ut: values=hapByFreqs; break;
}
bool found=false;
int pos=0;
for (FreqAndKeyVector::iterator it=values->begin(); it<values->end(); it++)
{
if (values->getElement(it)->Second==hap)
return pos;
pos++;
}
return -1;
}
/*____________________________________________________________ */
/*
int TrioCountersHapUAndT::getTotalHapsMinFreq (Transmission transmissionHapPosition, int minFreq)
{
// it returns -1 if hap code not found
int total=0;
FreqAndKeyVector* values;
switch (transmissionHapPosition)
{
case t: values=hapByFreqsT; break;
case u: values=hapByFreqsU; break;
case ut: values=hapByFreqs; break;
}
for (FreqAndKeyVector::iterator it=values->begin(); it!=values->end(); it++)
if (values->getElement(it)->First>=minFreq) total++;else return total; 

return total;
}

/*____________________________________________________________ */

int TrioCountersHapUAndT::getHapPositionByFreq (long long int hapCode, Transmission transmissionHapPosition)
{
// it returns -1 if hap code not found
FreqAndKeyVector* values;
switch (transmissionHapPosition)
{
case t: values=hapByFreqsT; break;
case u: values=hapByFreqsU; break;
case ut: values=hapByFreqs; break;
}
int position=0;
for (FreqAndKeyVector::iterator it=values->begin(); it!=values->end(); it++)
{
if (values->getElement(it)->Second==hapCode) return position;
position++;
}
return -1;
}

/*____________________________________________________________ */

double TrioCountersHapUAndT::getSquareSB (int type, Transmission trans, int hapPosition, Transmission transmissionHapPosition)
{
//type 0: mean of the squares (differences in variance even with same mean)
//type 1: differences in LD
//type 2: differences in hap freqs (LD assuming same allele frequencies between t and u) : equivalent to 0 when used as a test  
//type 3: total LD
// useMaxHap, only for type=3 (if false, second most frequent hap is used)
double totalHaplotypes=this->totalMeiosis*2,  SB=0, tCounts, uCounts, counts, alleleFreq=1, counts2, total=0;
int*hap;
if (trans!=ut) totalHaplotypes=totalHaplotypes/2; 
//cout <<"haps:\n:" << *haplotypeCounts <<"\n";
double maxFreq=0, freq;
long long int maxHap=0;
if (type==3) // Total LD
maxHap=getHapAtPosition(hapPosition, transmissionHapPosition);

for (long long int key=0; key<haplotypeTable->getSize(); key++)
{
alleleFreq=1;
hap=haplotypeTable->getPositions(key);
counts=0;
tCounts=getTotalMeiosis(key, t, parent);
uCounts=getTotalMeiosis(key, u, parent);
total=total+tCounts+uCounts;
for (int a=0; a<trioCounters->totalPos;a++)
{
if (trans==t || trans==ut) alleleFreq=alleleFreq*(SNPAbsFreqsFatherT[a][hap[a]]+SNPAbsFreqsMotherT[a][hap[a]])/totalHaplotypes;
if (trans==u || trans==ut) alleleFreq=alleleFreq*(SNPAbsFreqsFatherU[a][hap[a]]+SNPAbsFreqsMotherU[a][hap[a]])/totalHaplotypes;
}
counts2=tCounts+uCounts;
for (int i=0; i<2; i++)
if ((i==0 && trans==t) || (i==1 && trans==u) || trans==ut)
{
if (i==0) counts=counts+tCounts;
if (i==1) counts=counts+uCounts;
switch (type) 
{
case 0: SB=SB+std::pow(counts,2)/totalHaplotypes; 
break;
case 1: SB=SB+(counts2/(totalHaplotypes*2))*(counts/(totalHaplotypes)-alleleFreq); break;
case 2: SB=SB+(counts2/(totalHaplotypes*2))*(counts/totalHaplotypes); // it is proportional to case 0 (so equivalent when used as a test)
case 3: if (key==maxHap) SB=counts/totalHaplotypes; break;
}
}
zaparr(hap);
}
if (total==0) return -1;
return SB;
}
/*____________________________________________________________ */

double TrioCountersHapUAndT::getEntropySB (bool df, Transmission trans)
{
// S_B=-sum_{foreach n hap presents in the sample} p_i log p_i
double totalHaplotypes=this->totalMeiosis*2,  SB=0, tCounts, uCounts, counts, counts2;
if (trans!=ut) totalHaplotypes=totalHaplotypes/2;
double total=0;
for (long long int key=0; key<haplotypeTable->getSize(); key++)
{
counts=0;
tCounts=getTotalMeiosis(key, t, parent);
uCounts=getTotalMeiosis(key, u, parent);
counts2=tCounts+uCounts;
total=total+tCounts+uCounts;
//totalMeiosis=tCounts+uCounts;
for (int i=0; i<2; i++)
if ((i==0 && trans==t) || (i==1 && trans==u) || trans==ut)
if (!df || !haplotypeTable->inferredFrequency(key))
{
if (i==0) counts=counts+tCounts;
if (i==1) counts=counts+uCounts;
if (counts>0) SB=SB-(counts/totalHaplotypes)*log(counts/totalHaplotypes);
}
}
if ((total)==0) return -1;
//cout <<"SB is:" << SB;
return SB;
}
/*____________________________________________________________ */


double TrioCountersHapUAndT::getEntropySE(bool df)
{
//entropy in equilibrium
double SE=0, p;
int* hap;
double counts;
for (long long int i=0; i<haplotypeTable->getSize(); i++)
{
hap=haplotypeTable->getPositions(i);
if (!df || !haplotypeTable->inferredFrequency(i))
{
p=1;
for (int j=0; j<trioCounters->totalPos;j++)
{
 p=p*(trioCounters->SNPAbsFreqsFather[j][hap[j]]+trioCounters->SNPAbsFreqsMother[j][hap[j]])/(trioCounters->totalGenotypes*2);
//cout <<"\nfreq is:" << this->SNPAbsFreqs[j][hap[j]] <<" and totalgens is:" << this->totalGenotypes*2;
}
//cout << "totalhaps:" << totalMeiosis <<" vesus :" << this->totalGenotypes*2;
if (p>0) SE=SE-p*log(p);
}
zaparr(hap);
}
//cout <<"entropySEis: " << SE <<", entropy SB is: " << SB;
//end();
return SE;

}



/*____________________________________________________________ */



double TrioCountersHapUAndT::getEntropyBasedLD (bool df, Transmission trans)
{
// it computes Entropy-based LD (Nothnage et al. 2002) defined as S_E-S_B (deviation between entropy S_B and entropy in the equilibrium case S_E)
// S_E=-sum_{foreach haplotype configuration} q_i log q_i
// q_i=prod_{foreach SNP k} p_k^I(k=1) (1-p_k)^I(k=2)
// with I being the identity function, so for each position we use the allele frequency for the allele in the current haplotype
// S_B=-sum_{foreach n haps present in the sample} p_i log p_i
return getEntropySE(df)-getEntropySB(df, trans);
}

/*____________________________________________________________ */

double TrioCountersHapUAndT::getDPrime(BidimensionalTable<double> * multiallelicFreqs, int measure, bool df)
{
double dPrime;
MultiallelicPairwiseMeasure* multiallelicPairwiseMeasure=new MultiallelicPairwiseMeasure(multiallelicFreqs);
dPrime=multiallelicPairwiseMeasure->getDPrime();
zap(multiallelicPairwiseMeasure);
return dPrime;
}

/*____________________________________________________________ */

double TrioCountersHapUAndT::getMultimarkerDPrime (int measure, bool df, Transmission trans)
{
double DPrime=0, partialDPrime, totalCounts=0;
try
{
longLongList::iterator pointer;
int *positions=NULL, cont;
BidimensionalTable<double> * multiallelicFreqs=NULL;
//MultimarkerMeasureHap<TrioSample> *haps=multimarkerMeasureTransmitted;
for (int i=0; i<trioCounters->totalPos; i++)
for (int j=i+1; j<trioCounters->totalPos; j++)
{
multiallelicFreqs=getMultiallelicFreqs(i, j, trans);
partialDPrime=getDPrime(multiallelicFreqs, measure, df);
zap(multiallelicFreqs);
DPrime=DPrime+partialDPrime;
totalCounts++;
}
}
catch (ZeroValue zv){zv.PrintMessage("in MultimarkerMeasureUnknownHaplotypes<T>::getMultimarkerDPrime");};
if (totalCounts==0) throw ZeroValue("TrioCountersHapUAndT::getMultimarkerDPrime");
return DPrime/totalCounts;
}
/*____________________________________________________________ */

double TrioCountersHapUAndT::getSquareHapProbs (bool df, Transmission trans)
{
return getMultimarkerDPrime(2, df, trans);
}


/*____________________________________________________________ */


double TrioCountersHapUAndT::getTDT (IndCategory ic)
{
return getGenericTDT(0, ic, false, 1, t, 0.0);
}

/*____________________________________________________________ */


double TrioCountersHapUAndT::getSimpleTDT (IndCategory ic, int hapPosition, Transmission transmissionHapPosition)
{
long long int hap;
if (hapPosition==-1)
{
hap=getMaxTDTDiff(transmissionHapPosition);
if (hap==-1) return 0;
hapPosition=getPositionForHap(hap, transmissionHapPosition)+1;
transmissionHapPosition=ut;
}
return getGenericTDT(0, ic, true, hapPosition, transmissionHapPosition);
}

/*____________________________________________________________ */


double TrioCountersHapUAndT::getSimpleEntropyTDT (IndCategory ic, int hapPosition, Transmission transmissionHapPosition)
{
long long int hap;
if (hapPosition==-1)
{
hap=getMaxTDTDiff(transmissionHapPosition);
if (hap==-1) return 0;
hapPosition=getPositionForHap(hap, transmissionHapPosition)+1;
transmissionHapPosition=ut;
}
return getGenericTDT(1, ic, true, hapPosition, transmissionHapPosition);
}
/*____________________________________________________________ */


double TrioCountersHapUAndT::getTTDT (IndCategory ic)
{
return getGenericTDT(9, ic);
}
/*____________________________________________________________ */


double TrioCountersHapUAndT::getUTDT (IndCategory ic)
{
return getGenericTDT(10, ic);
}

/*____________________________________________________________ */


double TrioCountersHapUAndT::getYateTDT (double alpha, bool basicYate, IndCategory ic)
{
if (basicYate) return getGenericTDT(11, ic, false, 1, t, alpha);
else return getGenericTDT(14, ic, false, 1, t, alpha);
}
/*____________________________________________________________ */


double TrioCountersHapUAndT::getLaplaceTDT (double alpha, IndCategory ic)
{
return getGenericTDT(12, ic, false, 1, t, alpha);
}
/*____________________________________________________________ */


double TrioCountersHapUAndT::getGrouping (IndCategory ic)
{
return getGenericTDT(13, ic);
}

/*____________________________________________________________ */


double TrioCountersHapUAndT::getScoreTDT (IndCategory ic)
{
/*
doublevec *vectorT=new doublevec(totalUsedDifferentHaplotypes), *vectorU=new doublevec(totalUsedDifferentHaplotypes), *diff=NULL;
getGenericTDT(4, ic, true, 0, ut, 0, vectorT, vectorU);
diff=vectorT-vectorU;
dv2d *sigmaP=new dv2d();
*/
return 0.0;
}

/*____________________________________________________________ */


double TrioCountersHapUAndT::getScoreEntropyTDT (IndCategory ic)
{
return 0.0;
//return getGenericTDT(5, ic);
}

/*____________________________________________________________ */


double TrioCountersHapUAndT::getSNPAbsVarTDT (IndCategory ic)
{
return getGenericTDT(6, ic);
}

/*____________________________________________________________ */


double TrioCountersHapUAndT::getSNPSquareVarTDT (IndCategory ic)
{
return getGenericTDT(7, ic);
}

/*____________________________________________________________ */


double TrioCountersHapUAndT::getSNPSquareCorrectedVarTDT (IndCategory ic)
{
return getGenericTDT(8, ic);
}
/*____________________________________________________________ */


double TrioCountersHapUAndT::getNTDT (IndCategory ic)
{
return getGenericTDT(3, ic);
}
/*____________________________________________________________ */


double TrioCountersHapUAndT::getWTDT (IndCategory ic) throw (NonDefined)
{
//if (onlyHetero) throw NonDefined("TrioCountersHapUAndT::getWTDT");
//else 
return getGenericTDT(15, ic);
}
/*____________________________________________________________ */


double TrioCountersHapUAndT::getWWTDT (IndCategory ic) throw (NonDefined)
{
//if (onlyHetero) throw NonDefined("TrioCountersHapUAndT::getWWTDT");else 
return getGenericTDT(16, ic);
}
/*____________________________________________________________ */


double TrioCountersHapUAndT::getNTDTExternalWeights (IndCategory ic, doubleList* externalWeights) throw (NullValue)
{
return getGenericTDT(17, ic, false, 1, t, 0.0, externalWeights);
}

/*____________________________________________________________ */


double TrioCountersHapUAndT::getEntropyTDT (IndCategory ic)
{
return getGenericTDT(1, ic);
}
/*____________________________________________________________ */


double TrioCountersHapUAndT::getNEntropyTDT (IndCategory ic)
{
return getGenericTDT(2, ic);
}
/*____________________________________________________________ */
/*
int TrioCountersHapUAndT::getTotalDifferentPhasing (int trioCount)
{
int cont=0;
ParentalHaplotypes parentalHaplotypes;
for (ParentalHaplotypeList::iterator it=haplotypeCounts->begin(); it<haplotypeCounts->end(); it++)
{
parentalHaplotypes=haplotypeCounts->getElement(it);
if (parentalHaplotypes.trioCount==trioCount)
cont++;
}
return cont;
}
/*____________________________________________________________ */

double TrioCountersHapUAndT::getTest (int testType, IndCategory ic) throw (BadFormat)
{
if (ic==offspring || ic==everybody) throw BadFormat(string("TrioCountersHapUAndT::getTotalMeiosis"));

// testType=0: length contrast test
// testType=1: standardized length contrast test (standardized similarity measure)
// testType=2: wilcoxon signed rank test
// testType=3: Yu signed rank test (described in Yu et al. 2005, based on Randles and Hoggs 1973)
double total=0, totalCounts=0, D, freqs, freqs2;
Container<vector<Pair<double>*>, Pair<double> *>* DList=NULL;
Pair<double> *DPair;
long long int parentsT, parentsU, parentsT2, parentsU2;
ParentalHaplotypes *parentalHaplotypes, *parentalHaplotypes2;
if (testType==2 || testType==3) DList=new Container<vector<Pair<double>*>, Pair<double> *>(); 
int *pos, ind;
for (int i=0; i<haplotypeCounts->size(); i++)
{
parentalHaplotypes=(ParentalHaplotypes*)haplotypeCounts->getElement(i);
for (int parentC=0; parentC<2; parentC++) // for each parent it computes length measure within parents
if (ic==parent || (parentC==0 && ic==father) || (parentC==1 && ic==mother))
{
if (parentC==0) {parentsT=parentalHaplotypes->fatherT; parentsU=parentalHaplotypes->fatherU;}
 else  {parentsT=parentalHaplotypes->motherT; parentsU=parentalHaplotypes->motherU;}
if (parentsT!=parentsU || !onlyHetero) 
for (int i2=i+1; i2<haplotypeCounts->size(); i2++)
{
parentalHaplotypes2=(ParentalHaplotypes*)haplotypeCounts->getElement(i2);
freqs=parentalHaplotypes->freq*parentalHaplotypes2->freq;
if (parentalHaplotypes2->trioCount!=parentalHaplotypes->trioCount)
{
for (int parent2=0; parent2<2; parent2++)
if (parentalHaplotypes->isKnown(1-parent))
if (ic==parent || (parent2==0 && ic==father) || (parent2==1 && ic==mother))
{
if (parent2==0) {parentsT2=parentalHaplotypes2->fatherT; parentsU2=parentalHaplotypes2->fatherU;}
 else  {parentsT2=parentalHaplotypes2->motherT; parentsU2=parentalHaplotypes2->motherU;}
if (parentsT2!=parentsU2 || !onlyHetero) 
{
D=getLengthMeasure(parentsT, parentsT2, parentsU, parentsU2);
if (testType==0 || testType==1) total=total+D*freqs;
else  {DPair=new Pair<double>(fabs(D*freqs), D*freqs); DList->insertElement(DPair);};
totalCounts=totalCounts+freqs;
}
}
}
}
}
}
if (testType==1) total=total/(double)totalCounts; // standardized length contrast test (standardized disimilarity measure)
if (testType<2) return total;
return getSignedRank(DList, totalCounts, testType);
};
/*____________________________________________________________ */

double TrioCountersHapUAndT::getSignedRank (Container<vector<Pair<double>*>, Pair<double> *>* DList, double totalCounts, int testType)
{
bool onlyOne, end;
double total=0, rank=1, D;
DList->sort(false);
Container<vector<Pair<double>*>, Pair<double> *>::iterator p=DList->getFirst(), pIni, p3;
int sameD=0;
double avRank=0, sigma, alpha, absD, halfComparisons=(totalCounts+1)/(double)2;
rank=1;
while (p!=DList->end())
{
absD=DList->getElement(p)->getFirst();
D=DList->getElement(p)->getSecond();
p=DList->getNext(p);
sameD=1;
avRank=rank;
pIni=p;
onlyOne=true;
while (p!=DList->end() && DList->getElement(p)->getFirst()==absD)
{
onlyOne=false;
end=false;
sameD++;
p=DList->getNext(p);
avRank=avRank+rank;
}
avRank=avRank/(double)sameD;
p3=pIni;
sigma=0;
if (testType==2) alpha=avRank;// Wilcoxon
else if (avRank<=halfComparisons) alpha=0; else alpha=avRank-halfComparisons;

//cout <<"\navrank is " << avRank <<" totalCounts is:" << totalCounts <<"\n";
while ((p3!=p && !onlyOne) || (onlyOne && !end))
{
if (sameD==1) end=true;
sigma=0;
if (!onlyOne) D=DList->getElement(p3)->getSecond();
if (D>0) sigma=1; else if (D==0) sigma=0.5; 
//if (avRank>(totalCounts+1)/2) total=total+(avRank-(totalCounts+1)/2)*sigma;
total=total+alpha*sigma;
p3=DList->getNext(p3);
}
rank++;
}
zap(DList);
return total;
}


/*____________________________________________________________ */

double TrioCountersHapUAndT::getTotalMeiosis (long long int hap, long long int hap2, IndCategory ic) throw (BadFormat)
{
if (ic==offspring || ic==everybody) throw BadFormat(string("TrioCountersHapUAndT::getTotalMeiosis"));
ParentalHaplotypes* parentalHaplotypes;
double total=0;
long long int parentT, parentU, chosenParent;


for (ParentalHaplotypeList::iterator it=haplotypeCounts->begin(); it<haplotypeCounts->end(); it++)
{
parentalHaplotypes=(ParentalHaplotypes*)haplotypeCounts->getElement(it);
for (int parentC=0; parentC<2; parentC++)
if (ic==parent || parentC==0 && ic==father || parentC==1 && ic==mother)
{
if (parentC==0) {parentT=parentalHaplotypes->fatherT; parentU=parentalHaplotypes->fatherU;}
else {parentT=parentalHaplotypes->motherT; parentU=parentalHaplotypes->motherU;}
if (parentT==hap && parentU==hap2)
if (parentT!=parentU || !onlyHetero)
total=total+parentalHaplotypes->freq;
}
}

return total;
}
/*____________________________________________________________ */

double TrioCountersHapUAndT::getTotalHeteroGenotypes (long long int hap, IndCategory ic) throw (BadFormat)
{
if (ic==offspring || ic==everybody) throw BadFormat(string("TrioCountersHapUAndT::getTotalMeiosis"));
ParentalHaplotypes* parentalHaplotypes;
double total=0;
long long int parentT, parentU, chosenParent;


for (ParentalHaplotypeList::iterator it=haplotypeCounts->begin(); it<haplotypeCounts->end(); it++)
{
parentalHaplotypes=(ParentalHaplotypes*)haplotypeCounts->getElement(it);
for (int parentC=0; parentC<2; parentC++)
if (ic==parent || parentC==0 && ic==father || parentC==1 && ic==mother)
{
if (parentC==0) {parentT=parentalHaplotypes->fatherT; parentU=parentalHaplotypes->fatherU;}
else {parentT=parentalHaplotypes->motherT; parentU=parentalHaplotypes->motherU;}
if ((parentT==hap && parentU!=hap) || (parentT!=hap && parentU==hap))
total=total+parentalHaplotypes->freq;
}
}
return total;
}


/*____________________________________________________________ */

double TrioCountersHapUAndT::getTotalHomoGenotypes (long long int hap, IndCategory ic) throw (BadFormat)
{
if (ic==offspring || ic==everybody) throw BadFormat(string("TrioCountersHapUAndT::getTotalMeiosis"));
ParentalHaplotypes* parentalHaplotypes;
double total=0;
long long int parentT, parentU, chosenParent;


for (ParentalHaplotypeList::iterator it=haplotypeCounts->begin(); it<haplotypeCounts->end(); it++)
{
parentalHaplotypes=(ParentalHaplotypes*)haplotypeCounts->getElement(it);
for (int parentC=0; parentC<2; parentC++)
if (ic==parent || parentC==0 && ic==father || parentC==1 && ic==mother)
{
if (parentC==0) {parentT=parentalHaplotypes->fatherT; parentU=parentalHaplotypes->fatherU;}
else {parentT=parentalHaplotypes->motherT; parentU=parentalHaplotypes->motherU;}
if (parentT==hap && parentU==hap)
total=total+parentalHaplotypes->freq;
}
}

return total;
}

/*____________________________________________________________ */

double TrioCountersHapUAndT::getTotalHeteroGenotypes (IndCategory ic)
{
if (ic==offspring || ic==everybody) throw BadFormat(string("TrioCountersHapUAndT::getTotalMeiosis"));
ParentalHaplotypes* parentalHaplotypes;
double total=0;
long long int parentT, parentU, chosenParent;


for (ParentalHaplotypeList::iterator it=haplotypeCounts->begin(); it<haplotypeCounts->end(); it++)
{
parentalHaplotypes=(ParentalHaplotypes*)haplotypeCounts->getElement(it);
for (int parentC=0; parentC<2; parentC++)
if (ic==parent || parentC==0 && ic==father || parentC==1 && ic==mother)
{
if (parentC==0) {parentT=parentalHaplotypes->fatherT; parentU=parentalHaplotypes->fatherU;}
else {parentT=parentalHaplotypes->motherT; parentU=parentalHaplotypes->motherU;}
if (parentT!=parentU)
total=total+parentalHaplotypes->freq;
}
}
return total;
}

/*____________________________________________________________ */

double TrioCountersHapUAndT::getTotalHaplotypes (long long int hap, Transmission trans, IndCategory ic) throw (BadFormat)
{
if (ic==offspring || ic==everybody) throw BadFormat(string("TrioCountersHapUAndT::getTotalMeiosis"));
ParentalHaplotypes* parentalHaplotypes;
double total=0;
long long int parentT, parentU, chosenParent;


for (ParentalHaplotypeList::iterator it=haplotypeCounts->begin(); it<haplotypeCounts->end(); it++)
{
parentalHaplotypes=(ParentalHaplotypes*)haplotypeCounts->getElement(it);
for (int parentC=0; parentC<2; parentC++)
if (ic==parent || parentC==0 && ic==father || parentC==1 && ic==mother)
{
if (parentC==0) {parentT=parentalHaplotypes->fatherT; parentU=parentalHaplotypes->fatherU;}
else {parentT=parentalHaplotypes->motherT; parentU=parentalHaplotypes->motherU;}
for (int tr=1; tr<3; tr++)
if ((int)trans==tr || trans==ut)
if ((parentT==hap && tr==1) || (parentU==hap && tr==2))
if (parentT!=parentU || !onlyHetero)
total=total+parentalHaplotypes->freq;
}
}
return total;
}
/*____________________________________________________________ */

double TrioCountersHapUAndT::getIndependentLociFrequency (long long int key)
{
int* position=haplotypeTable->getPositions(key);
double value=1;
 for (int j=0; j<trioCounters->totalPos; j++)
  value=value*(trioCounters->SNPAbsFreqsFather[j][position[j]]+trioCounters->SNPAbsFreqsMother[j][position[j]])/(trioCounters->totalGenotypes*2);
zaparr(position);
return value;
}
/*____________________________________________________________ */

long long int TrioCountersHapUAndT::getMaxTDTDiff (Transmission trans)
{
double maxDiff=-1, tCounts, uCounts, diff=0;
long long int maxPos=-1;


//cout << *haplotypeCounts <<"\n";

for (long long int key=0; key<haplotypeTable->getSize(); key++)
{
tCounts=getTotalHaplotypes(key, t);
uCounts=getTotalHaplotypes(key, u);
if ((tCounts+uCounts)>=minFreq && (tCounts+uCounts)>0)
{
diff=std::pow(tCounts-uCounts,2)/(tCounts+uCounts)+std::pow(tCounts-uCounts,2)/(totalUsedHaplotypes-tCounts-uCounts);
if (diff>maxDiff && ((trans==t && tCounts>uCounts) || (trans==u && tCounts<uCounts) || trans==ut))
{
 maxPos=key;
 maxDiff=diff;
}
}
}
return maxPos;
}
/*____________________________________________________________ */

double TrioCountersHapUAndT::getGenericTDT (int test, IndCategory ic, bool oneHap, int hapPosition, Transmission transmissionHapPosition, double alpha, doubleList* externalWeights, doublevec* dT, doublevec* dU) throw (NullValue)
{
double totalHetero;
totalHetero=getTotalHeteroGenotypes(ic)*2;
if (totalHetero==0) return 0;// no association

if (ic==offspring || ic==everybody) throw BadFormat(string("TrioCountersHapUAndT::getTotalMeiosis"));
// test 0: TDT, test 1: entropy TDT; 2: p entropy TDT 3: p TDT,  4: score TDT 5: score entropy TDT, 6: abs var SNP TDT, 7: square SNP var TDT, 8: square corrected SNP TDT, 9: transmitted TDT, 10: non transmitted TDT, 11: Yate's correction, 12: Laplace correction, 13: G2; 14: prop Yate's correction; 
// 15: weighted TDT by prop of heterogotic parents in this haplotype: p(het/h_i)
// 16: weighted TDT by prop of heterogotic parents and prop of the hap: p(h_i and g_jk,j<>k),
// 17: weighted TDT by prop of haplotypes provided in externalWeights 

long long int key, maxHap=0;
int i=0;
double tCounts, uCounts, measure=0, measure2=0, condT, condU, ni, niHomo, margT, margU, freq, total=0, total2=0;
doubleList *weights=NULL;
if (oneHap) // one hap TDT
maxHap=getHapAtPosition(hapPosition, transmissionHapPosition);
if ((test==15 || test==16))
if (totalHetero==0) weights=getWeightsInWTDT(parent, 0);
else  if (test==15) weights=getWeightsInWTDT(parent, 1);
else weights=getWeightsInWTDT(parent, 2);

for (long long int key=0; key<haplotypeTable->getSize(); key++)
//if (!oneHap || key==maxHap)
{
tCounts=getTotalHaplotypes(key, t, ic);
uCounts=getTotalHaplotypes(key, u, ic);
ni=tCounts+uCounts;
if (ni>=minFreq && ni>0)
{
		condT=tCounts/(double)ni; condU=uCounts/(double)ni;  
  margT=tCounts/totalUsedHaplotypes; margU=uCounts/totalUsedHaplotypes;
		switch (test)
		{
		case 0: 
if (oneHap) //measure=measure+std::pow(tCounts-uCounts, 2)/ni; //same as
// measure=measure+ni*std::pow(condT-q, 2); 

if (key==maxHap)
{
	measure=measure+(tCounts-uCounts); 
  total=total+ni;
}
else 
{
measure2=measure2+tCounts-uCounts; // not needed, as measure2 = -measure
total2=total2+ni;
}
else measure=measure+((totalUsedDifferentHaplotypes-1)/totalUsedDifferentHaplotypes)*(std::pow(tCounts-uCounts, 2)/ni);
break;
		case 1: // entropy TDT
		if (condT!=0 && condU!=0)
if (oneHap) measure=measure+ni*std::pow(condT*log(condT)-condU*log(condU), 2)/(condT*condU*std::pow(2+log(condT)+log(condU),2)); //same as
else  measure=measure+((totalUsedDifferentHaplotypes-1)/totalUsedDifferentHaplotypes)*ni*std::pow(condT*log(condT)-condU*log(condU), 2)/(condT*condU*std::pow(2+log(condT)+log(condU),2));
else  //
if (oneHap) measure=measure+ni;
else measure=measure+ni*(totalUsedDifferentHaplotypes-1)/totalUsedDifferentHaplotypes;
//else if (q!=0) measure=measure+n*std::pow(q*log(q),2);
 break;//(p*q*std::pow(2+log(p)+log(q), 2)); break;
	case 2: 
	if (condT!=0 && condU!=0) measure=measure+ni*ni*std::pow(condT*log(condT)-condU*log(condU),2)/(condT*condU*std::pow(2+log(condT)+log(condU),2)); 
//	if (p!=0) measure=measure-(tCounts*log(tCounts));
// if (q!=0) measure=measure+(uCounts*log(uCounts));
 // /(p*q*(2+log(p)+log(q))); 
break;
 case 3:  //pTDT
measure=measure+
//((totalUsedDifferentHaplotypes-1)/totalUsedDifferentHaplotypes)*
std::pow(tCounts-uCounts, 2)/(totalUsedHaplotypes); //totalUsedDifferentHaplotypes); // same as measure=measure+((totalDifferentHaplotypes-1)/totalDifferentHaplotypes)*std::pow(tCounts-uCounts,2)/totalMeiosis
// equivalent to std::pow(ni,2)*std::pow(p-q, 2);
break;
 case 4:  		// score TDT 
case 5: // score entropy TDT
dT->setValueAtPos(i,tCounts/totalUsedHaplotypes); 
dU->setValueAtPos(i,uCounts/totalUsedHaplotypes); 
break;
  case 6:  			// abs SNP var TDT
 measure=measure+((totalUsedDifferentHaplotypes-1)/totalUsedDifferentHaplotypes)*getIndependentLociFrequency(key)*fabs(tCounts-uCounts); //propto 
break;
  case 7:  		// square SNP var TDT
 measure=measure+((totalUsedDifferentHaplotypes-1)/totalUsedDifferentHaplotypes)*std::pow(tCounts-uCounts,2)/(totalUsedHaplotypes*getIndependentLociFrequency(key)); 
//propto 
//cout << "\nfor key " << key <<" tcounts is: " << tCounts << ", ucounts is: " << uCounts << " and ind is:" << getIndependentLociFrequency(key);
break;
  case 8:  		// square corrected SNP var TDT
 measure=measure+((totalUsedDifferentHaplotypes-1)/totalUsedDifferentHaplotypes)*getIndependentLociFrequency(key)*getIndependentLociFrequency(key)*std::pow(tCounts-uCounts,2); //propto 
break;
		case 9: 
    if (condT>condU)
 measure=measure+std::pow(tCounts-uCounts, 2)/ni; //same as measure=measure+ni*std::pow(condT-q, 2); 
 break;//(p*q*std::pow(2+log(p)+log(q), 2)); break;
		case 10: 
    if (condT<condU)
	measure=measure+std::pow(tCounts-uCounts, 2)/ni; //same as measure=measure+ni*std::pow(condT-q, 2); 

 break;//(p*q*std::pow(2+log(p)+log(q), 2)); break;
case 11: // Yate
measure=measure+((totalUsedDifferentHaplotypes-1)/totalUsedDifferentHaplotypes)*std::pow(fabs(tCounts-uCounts)-alpha/2, 2)/ni; //same as measure=measure+ni*std::pow(condT-q, 2); 
break;
case 12: // Laplace
measure=measure+((totalUsedDifferentHaplotypes-1)/totalUsedDifferentHaplotypes)*(std::pow(tCounts-uCounts, 2)/(ni+alpha)); 
break;
case 13: // grouping
if (tCounts>uCounts)
{
	measure=measure+(tCounts-uCounts); 
  total=total+ni;
}
else 
{
measure2=measure2+tCounts-uCounts; // not needed, as measure2 = -measure
total2=total2+ni;
}
break;
case 14: // prop Yate's
measure=measure+((totalUsedDifferentHaplotypes-1)/totalUsedDifferentHaplotypes)*std::pow(fabs(tCounts-uCounts)-alpha*(1/(ni)), 2)/ni; 
break;
case 15:// getWTDT: weighted TDT by prop of heterogotic parents in this haplotype: p(het/h_i)
case 16:// getWWTDT: weighted TDT by prop of heterogotic parents and prop of the hap: p(h_i and g_jk,j<>k),
//onlyhtero are used for each summand 
if (i>=totalUsedDifferentHaplotypes)
{
cout<<"errornocincpde, i is: " << i <<"taotaldif:"<< totalUsedDifferentHaplotypes <<"\n";
exit(0);
}
measure=weights->getElement(i)*std::pow(tCounts-uCounts, 2)/ni; 
break;
case 17:// getNTDTAlsoHomo: weighted TDT by prop of haplotypes using also homo
if (i>=totalUsedDifferentHaplotypes)
{
cout<<"errornocincpde, i is: " << i <<"taotaldif:"<< totalUsedDifferentHaplotypes <<"\n";
exit(0);
}
if (externalWeights==NULL)
throw NullValue("TrioCountersHapUAndT::getGenericTDT");
//cout <<"\ni is:" << i <<"\nwhile total size is:" << externalWeights->size() <<"\n",
measure=externalWeights->getElement(i)*std::pow(tCounts-uCounts, 2)/ni; 
break;
}
  i++;
}
}
if (!oneHap && i!=totalUsedDifferentHaplotypes && minFreq==0) 
{
cout<<"errornocincpdebb, i is: " << i <<"taotaldif:"<< totalUsedDifferentHaplotypes <<"\n";
cout <<"test is:" << test <<"\n";
exit(0);
}

if (test==13 || (test==0 && oneHap))//grouping
{
if (total>0) measure=0.5*(std::pow(measure,2)/total);
if (total2>0) measure=measure+0.5*(std::pow(measure2,2)/total2);
}
zap(weights);
//return (i-1)*measure/i;
return measure;
}

/*________________________________________________________________________________________________________*/

doubleList* TrioCountersHapUAndT::getWeightsInWTDT(IndCategory ic, int type)
{
// type:0 for pTDT, 1 for WTDT and WTDTHet (proportion of heterozygotic parents for each haplotype), 2 for WWTDT and WWTDTHet (proportion of each haplotype being heterozygous)
double tCounts, uCounts, ni, totalHetero, totalHeteroHap;
doubleList* weights=new doubleList();
double weightsTable[(int)totalUsedDifferentHaplotypes];
int i=0;
totalHetero=getTotalHeteroGenotypes(ic)*2;
int minPos=0;
//double minFreqInSet=MAXDOUBLE;
double minFreqInSet=DBL_MAX;

for (long long int key=0; key<haplotypeTable->getSize(); key++)
{
tCounts=getTotalHaplotypes(key, t, ic);
uCounts=getTotalHaplotypes(key, u, ic);
ni=tCounts+uCounts;
if (ni>=minFreq && ni>0)
{
if ((type!=0 && totalHetero==0)) 
{
weights->insertElement(ni/totalUsedHaplotypes);
cout <<"no heteros at trioCountersHapUAndT::getWeightsInWTDT(IndCategory ic, int type) \n";
}
if (type==0)
{
if (totalHetero==0) 
cout <<"no heteros when computing weights of pTDT at trioCountersHapUAndT::getWeightsInWTDT(IndCategory ic, int type) \n";
weights->insertElement(ni/totalUsedHaplotypes);
if (ni<minFreqInSet)
{
minFreqInSet=ni;
minPos=i;
}
}

//else if (type==0) weights->insertElement(totalUsedDifferentHaplotypes*ni/totalUsedHaplotypes);
else 
{
if (i>=totalUsedHaplotypes)
{
cout<<"errornocincpdwqqqqe, i is: " << i <<"taotaldif:"<< totalUsedHaplotypes <<"\n";
exit(0);
}
//cout <<"hap " << key <<" totalheteros:" << getTotalHeteroGenotypes(key, ic);
//cout <<"totalmeio:" << totalUsedMeiosis <<"\n";
//cout <<"totalcounts:" << *haplotypeCounts <<"\n";
totalHeteroHap=getTotalHeteroGenotypes(key, ic);
weightsTable[i]=totalHeteroHap/ni;
if (onlyHetero) weightsTable[i]=totalHeteroHap/(ni+getTotalHomoGenotypes(key, ic)*2);
if (type==2) 
weightsTable[i]=weightsTable[i]*(ni/totalUsedHaplotypes);//n(g(i,j))/n\propto n(g(i,j)/h_het
// equivalent to getTotalHeteroGenotypes(key, ic)/totalHetero; which is already normalized
}
i++;
}
}
if (1==0)
if (type==0) 
{
weights->removeNode(minPos);
for (int i=0; i<weights->size(); i++)
weights->changeElementAtPos(weights->getElement(i)/(totalUsedHaplotypes-minFreqInSet), i);
}
if (type>0 && totalHetero>0 && totalUsedHaplotypes>0)
{
normalize(weightsTable, (int)totalUsedDifferentHaplotypes);
for (int i=0; i<totalUsedDifferentHaplotypes; i++)
weights->insertElement(weightsTable[i]);
}
//cout <<"totalMeiosis:" <<totalMeiosis << ", totalUsed:" << totalUsedMeiosis <<"\n";
//cout << "hap:"<< *haplotypeCounts <<"\ngen:\n" << *trioCounters <<"\n";
//if (type==1) cout <<"\ntotal global heteros:" << totalHetero << "\nweight is:" << *weights <<"\n" <<", totalusedhaps: " << totalDifferentHaplotypes <<"\ntotallist:" << *haplotypeCounts;
//cout <<"weights computed are:" << *weights <<"\n";
return weights;
}
/*________________________________________________________________________________________________________*/


double TrioCountersHapUAndT::getLogTDT(IndCategory ic)
{
// this code was copied from lrtdt.cpp in ETDT package (ETDT is a program for performing multiallele TDT analysis. See: Sham and Curtis, 1995. An extended  transmission/disequilibrium test (TDT) for multi-allele marker  loci. Ann Hum Genet, 59: 323-336)

int totalHaplotypesAllowed=10;
int totalRows=(int)totalHaplotypesAllowed*((int)totalHaplotypesAllowed-1)/2, nall=(int)totalHaplotypesAllowed, row=0;
double tCounts, uCounts;
dv2d trials(totalRows,1),successes(totalRows,1),fitted(totalRows,1),design(totalRows,nall-1),
  beta(nall-1,1),SE(nall-1,1),corr(nall-1,nall-1);
double ln_like0,ln_like1;
for (int i=0;i<nall-1;++i) {beta[i][0]=0; trials[i][0]=0;  for (int k=0;k<nall-1;++k) design[i][k]=0;}



int i=0;

for (FreqAndKeyVector::iterator it=hapByFreqs->begin(); it<hapByFreqs->end()-1; it++)
for (FreqAndKeyVector::iterator it2=it+1; it2!=hapByFreqs->end(); it2++)
if (i<totalRows)
{
tCounts=getTotalMeiosis(hapByFreqs->getElement(it)->Second, hapByFreqs->getElement(it2)->Second, ic);
uCounts=getTotalMeiosis(hapByFreqs->getElement(it2)->Second, hapByFreqs->getElement(it)->Second, ic);
  trials[i][0]+=tCounts+uCounts; //trial_array[i];
  successes[i][0]+=tCounts;
  for (int k=0;k<nall-1;++k)
      if (k==i) design[i][k]=1; 
if ((tCounts+uCounts)>0) i++;
  }



bool ok=solve_logreg_tdt(trials,successes,design,beta,SE,corr,fitted,&ln_like0,   &ln_like1,0.001);
if (!ok || isNAN(ln_like1) || isNAN(ln_like0)) return -1;
else return 2*(ln_like1-ln_like0);

}

/*________________________________________________________________________________________________________*/



int TrioCountersHapUAndT::solve_logreg_tdt(dv2d &trials,dv2d &successes,dv2d &design,dv2d &beta,
  dv2d &SE,dv2d &corr,dv2d &fitted,double *ln_like0,double *ln_like1,double tol)
{
// this is the source code of lrtdt.cpp in ETDT package (ETDT is a program for performing multiallele TDT analysis. See: Sham and Curtis, 1995. An extended  transmission/disequilibrium test (TDT) for multi-allele marker  loci. Ann Hum Genet, 59: 323-336)

#ifndef MAXITER
#define MAXITER 50
#endif
int i,j,npars,nobs;
double xb,test1,test2,test3;
// having these as floats produced NaN errors with some data - 10/7/97
double old_like=0.0001,like,diff_like;
int iter=0;
npars=beta.get_height();
nobs=design.get_height();
//cout <<"npars:" << npars <<" and nobs:" << nobs <<"\n";
dv2d pi(nobs,1);
dv2d W(nobs,nobs);
dv2d Z(nobs,1);
dv2d mu(nobs,1);
dv2d XT=design.transpose();
dv2d XTWX(1,1),XTWXinv(1,1);

for (i=0;i<nobs;++i)
  for (j=0;j<nobs;++j)
    W[i][j]=0;
do {
//cout <<" iter" << iter <<"\n";
   if (++iter>MAXITER)
     {
     cerr << "Could not find solution for logistic regression";
     return 0;
     }
   for (i=0;i<nobs;++i)
     {
     xb=0;
     for (j=0;j<npars;++j)
       xb+=design[i][j]*beta[j][0];
     pi[i][0]=test2=(test1=exp(xb))/(test3=(1+exp(xb))); // compiler bug? or my gross stupidity?
     }
   for (i=0;i<nobs;++i)
      W[i][i]=trials[i][0]*pi[i][0]*(1-pi[i][0]);
   for (i=0;i<nobs;++i)
     {
     Z[i][0]=(successes[i][0]-trials[i][0]*pi[i][0]) /
               (trials[i][0]*pi[i][0]*(1-pi[i][0]));
     for (j=0;j<npars;++j)
       Z[i][0]+=design[i][j]*beta[j][0];
     }
   XTWX=XT*W*design;
   XTWXinv=XTWX.inv();
   beta=XTWXinv*XT*W*Z;
   for (i=0;i<nobs;++i)
     mu[i][0]=pi[i][0]*trials[i][0];
   like=0;
   for (i=0;i<nobs;++i)
     like+=successes[i][0]*log(pi[i][0]/(1-pi[i][0]))+
             trials[i][0]*log(1-pi[i][0]);
   if (old_like>0) // first time
     *ln_like0=like;
   diff_like=fabs((like-old_like)/old_like);
   old_like=like;
   } while (diff_like>tol);
*ln_like1=like;
// XTWXinv is covariance matrix
for (i=0;i<npars;++i) SE[i][0]=sqrt(XTWXinv[i][i]);
for (i=0;i<npars;++i)
  for (j=0;j<npars;++j)
    corr[i][j]=XTWXinv[i][j]/(SE[i][0]*SE[j][0]);
for (i=0;i<nobs;++i) fitted[i][0]=trials[i][0]*pi[i][0];



return 1;


}


HaplotypeVector* TrioCountersHapUAndT::getHaplotypeVector(FreqAndKeyVector* hapList)
{
	HaplotypeVector * hv = new HaplotypeVector(); // New vector we are going to fill

	int haplotypeKey1;
	float haplotype_freq_1;
	intList * haplotypeAsIntList;


	for(int i=0; i < hapList->size() ; i++){ // for each haplotype in hapList

		// Get the haplotype information
		haplotypeKey1 = hapList->getElement(i)->getSecond();
		haplotype_freq_1 = hapList->getElement(i)->getFirst();
		haplotypeAsIntList = haplotypeTable->getPosList(haplotypeKey1);

		// Insert info into a haplotype 
		Haplotype * h1 = new Haplotype();
		h1->frequency = haplotype_freq_1;
		
		for(int m=0; m<haplotypeAsIntList->size();m++){
			h1->push_back( haplotypeAsIntList->getElement(m) );
		}

		// Insert the haplotype into the vector
		hv->push_back(*h1);
	}

	
	return hv;
}

HaplotypeVector* TrioCountersHapUAndT::getTransmittedHaplotypes()
{
	return getHaplotypeVector(hapByFreqsT);
}

HaplotypeVector* TrioCountersHapUAndT::getNonTransmittedHaplotypes()
{
	return getHaplotypeVector(hapByFreqsU);
}

HaplotypeVector* TrioCountersHapUAndT::getTransmittedHaplotypesG1()
{
	return getHaplotypeVector( this->getUsedHaplotypesInG(true, t) );
}

HaplotypeVector* TrioCountersHapUAndT::getTransmittedHaplotypesG2()
{
	return getHaplotypeVector( this->getUsedHaplotypesInG(true, u) );
}

HaplotypeVector* TrioCountersHapUAndT::getNonTransmittedHaplotypesG1()
{
	return getHaplotypeVector( this->getUsedHaplotypesInG(false, t) );
}

HaplotypeVector* TrioCountersHapUAndT::getNonTransmittedHaplotypesG2()
{
	return getHaplotypeVector( this->getUsedHaplotypesInG(false, u) );
}

};  // End of Namespace

#endif

/* End of file: MultimarkerMeasure.h */






