/* File: MultimarkerMeasure.h */


#ifndef __TrioCountersHapUAndTUnknownHaps_cpp__
#define __TrioCountersHapUAndTUnknownHaps_cpp__





//using namespace stats;

namespace BIOS {


/**********************************/
/* DEFINITIONS OF THE FUNCTIONS */
/**********************************/



///////////////////
//// public ////////
///////////////////

/*____________________________________________________________ */

TrioCountersHapUAndTUnknownHaps* TrioCountersHapUAndTUnknownHaps::clone()
{
return new TrioCountersHapUAndTUnknownHaps(*this);
} 
/*_________________________________________________________________*/

void TrioCountersHapUAndTUnknownHaps::set(TrioCountersHapUAndTUnknownHaps& source)
{
}
/*_________________________________________________________________*/
/*
TrioCountersHapUAndTUnknownHaps::TrioCountersHapUAndTUnknownHaps(TrioCountersHapUAndTUnknownHaps& source):TrioCountersHapUAndT(source)
{
set(source);
}
/*_________________________________________________________________*/

TrioCountersHapUAndTUnknownHaps::TrioCountersHapUAndTUnknownHaps(TrioCounters* source, PhaseAlg phaseAlg, EMDistributions emDistributions, EMRestriction emRestriction):TrioCountersHapUAndT(source)
{
this->phaseAlg=phaseAlg;
this->emDistributions=emDistributions;
this->emRestriction=emRestriction;
setHaplotypeFreqs();
setSNPFreqs();
};
/*_________________________________________________________________*/
/*
TrioCountersHapUAndTUnknownHaps::TrioCountersHapUAndTUnknownHaps(TrioCountersHapUAndT& source):TrioCountersHapUAndT(source)
{
setHaplotypeFreqsTab();
setHaplotypeFreqs();
}
/*_________________________________________________________________*/

TrioCountersHapUAndTUnknownHaps::TrioCountersHapUAndTUnknownHaps(SNPPos Pos[], SNPPos totalPos, TrioSample * samp, int affectation, PhaseAlg phaseAlg, EMDistributions emDistributions, EMRestriction emRestriction, bool tdt, bool includeMissing):TrioCountersHapUAndT(Pos,  totalPos, samp, affectation, tdt, includeMissing)
{
this->phaseAlg=phaseAlg;
this->emDistributions=emDistributions;
this->emRestriction=emRestriction;
setHaplotypeFreqs();
setSNPFreqs();
}

/*_________________________________________________________________*/

TrioCountersHapUAndTUnknownHaps::~TrioCountersHapUAndTUnknownHaps()
{
};
/*_______________________________________________________________*/

MultidimensionalTable<double>* TrioCountersHapUAndTUnknownHaps::getInitialEstimation(int type)
{
double value;
int *position;
intList* dimList=new intList();
for (int i=0; i<trioCounters->totalPos;i++) dimList->insertElement(trioCounters->totalAlleles[i]);
MultidimensionalTable<double>* currentEstimation=new MultidimensionalTable<double>(dimList);
zap(dimList);
double total=0;
for (int i=0; i<currentEstimation->getSize();i++) 
{
 position=currentEstimation->getPositions(i);
 switch(type)
{
case 0: //independent loci
 value=1;
 for (int j=0; j<trioCounters->totalPos; j++)
  value=value*trioCounters->SNPAbsFreqs[j][position[j]]/(trioCounters->totalGenotypes*2);
break;
case 1://uniform
 value=1/(double)currentEstimation->getSize();
break;
case 2: // father transmitted
 value=trioCounters
}
 currentEstimation->setValue(i, value);
 zap(position);
 total=total+value;
}
return currentEstimation;
}

/*_______________________________________________________________*/

ParentalHaplotypes* TrioCountersHapUAndTUnknownHaps::getParentalHaplotypes(long long int ambiguousConfFather, long long int ambiguousConfMother, int binaryKnownConfiguration)
{
ParentalHaplotypes *parentalHaplotype=new ParentalHaplotypes();
parentalHaplotype->fatherT=trioCounters->tableGenotypes->getSolvedConf(ambiguousConfFather, binaryKnownConfiguration, true,  this->haplotypeTable);
parentalHaplotype->fatherU=trioCounters->tableGenotypes->getSolvedConf(ambiguousConfFather, binaryKnownConfiguration, false,  this->haplotypeTable);
parentalHaplotype->motherT=trioCounters->tableGenotypes->getPartnerSolvedConf(binaryKnownConfiguration, ambiguousConfFather, ambiguousConfMother, true, this->haplotypeTable);
parentalHaplotype->motherU=trioCounters->tableGenotypes->getPartnerSolvedConf(binaryKnownConfiguration, ambiguousConfFather, ambiguousConfMother, false, this->haplotypeTable);
return parentalHaplotype;
}
/*_______________________________________________________________*/

double TrioCountersHapUAndTUnknownHaps::getCurrentFrequency(Pair<MultidimensionalTable<double>*>* haplotypeFreqsTabPairFather,
Pair<MultidimensionalTable<double>*>* haplotypeFreqsTabPairMother, ParentalHaplotypes *parentalHaplotype)
{
return haplotypeFreqsTabPairFather->First->getValue(parentalHaplotype->fatherT)*haplotypeFreqsTabPairMother->First->getValue(parentalHaplotype->motherT)*haplotypeFreqsTabPairFather->Second->getValue(parentalHaplotype->fatherU)*haplotypeFreqsTabPairMother->Second->getValue(parentalHaplotype->motherU);
}
/*_______________________________________________________________*/

double TrioCountersHapUAndTUnknownHaps::getNormalizationValue(int totalConfigurations, long long int ambiguousPosFather, long long int ambiguousPosMother, Pair<MultidimensionalTable<double>*>* haplotypeFreqsTabPairFather,
Pair<MultidimensionalTable<double>*>* haplotypeFreqsTabPairMother)
{
double result=0, currentFrequency;
ParentalHaplotypes *parentalHaplotype;
for (int j=0; j<totalConfigurations; j++)
{
parentalHaplotype=getParentalHaplotypes(ambiguousPosFather, ambiguousPosMother, j);
currentFrequency=getCurrentFrequency(haplotypeFreqsTabPairFather, haplotypeFreqsTabPairMother, parentalHaplotype);
zap(parentalHaplotype);
result=result+currentFrequency/totalConfigurations;
}
return result;
}
/*_______________________________________________________________*/

void TrioCountersHapUAndTUnknownHaps::setHaplotypeFreqs()
{
Pair<MultidimensionalTable<double>*>* haplotypeFreqsTabPairFather=getHaplotypeFreqsTab();
ParentalHaplotypes *parentalHaplotypes, *chosenParentalHaplotypes;
this->haplotypeCounts=new ParentalHaplotypeList();
int totalConfigurations;
double maxFrequency=0, currentFrequency, total=0;
long long int ambiguousPosFather, ambiguousPosMother;
for (long long int i=0; i<trioCounters->genotypeCountsFather->size(); i++)
{ 
maxFrequency=-1;
ambiguousPosFather=trioCounters->genotypeCountsFather->getElement(i);
ambiguousPosMother=trioCounters->genotypeCountsMother->getElement(i);
totalConfigurations=trioCounters->tableGenotypes->getTotalSolvedConfs(ambiguousPosFather);
if (phaseAlg==weighted) total=getNormalizationValue(totalConfigurations, ambiguousPosFather, ambiguousPosMother, haplotypeFreqsTabPairFather, haplotypeFreqsTabPairMother);
for (int j=0; j<totalConfigurations; j++)
{
parentalHaplotypes=getParentalHaplotypes(ambiguousPosFather, ambiguousPosMother, j);
currentFrequency=getCurrentFrequency(haplotypeFreqsTabPair, parentalHaplotypes);
parentalHaplotypes->trioCount=i;
parentalHaplotypes->freq=currentFrequency;
if (phaseAlg==maxFreq)
{
if (maxFrequency<=currentFrequency) 
{
maxFrequency=currentFrequency; 
chosenParentalHaplotypes=parentalHaplotypes;
}
}
else
{
if (total>zero) parentalHaplotypes->freq=(currentFrequency/total)/totalConfigurations;
else parentalHaplotypes->freq=currentFrequency/totalConfigurations;
if (parentalHaplotypes->freq>zero)
this->haplotypeCounts->insertElement(parentalHaplotypes);
}
}
if (phaseAlg==maxFreq)
{
chosenParentalHaplotypes->freq=1;
this->haplotypeCounts->insertElement(chosenParentalHaplotypes);
//cout << "\nchosen hap:" << chosenParentalHaplotypes;
}
}
if (totalHaplotypes==0) this->~TrioCountersHapUAndTUnknownHaps();
zap(haplotypeFreqsTabPair->First);
zap(haplotypeFreqsTabPair->Second);
zap(haplotypeFreqsTabPair);
}

/*_______________________________________________________________*/

Pair<Pair<MultidimensionalTable<double>*>*>* TrioCountersHapUAndTUnknownHaps::getHaplotypeFreqsTab(int type, MultidimensionalTable<double>* genotypeAbsFreqsTab, MultidimensionalTable<longLongList*>* pointersToPartnerGenotypes)
{
Pair<Pair<MultidimensionalTable<double>*>*>* result=new Pair<Pair<MultidimensionalTable<double>*>*>*();
result->First=new Pair<MultidimensionalTable<double>*>();
result->Second=new Pair<MultidimensionalTable<double>*>();

if (phaseAlg==onlyKnown) 
{
result->First->First=this->getInitialEstimation(2);//father transmitted
result->First->Second=this->getInitialEstimation(3);//father untransmitted
result->Second->First=this->getInitialEstimation(4);//mother transmitted
result->Second->Second=this->getInitialEstimation(5);//mother untransmitted
return result;
}

result->First->First=this->getInitialEstimation(type);
result->First->Second=NULL;
int totalHaps=this->totalHaplotypes;
if (emDistributions==UTDistributions) 
{
result->First->Second=new MultidimensionalTable<double>(*result->First->First);
totalHaps=totalHaps/2;
}
if (emRestriction==triosBasedRestriction)
{
totalHaps=totalHaps/2;
result->Second->First=new MultidimensionalTable<double>(*result->First->First);
if (emDistributions==UTDistributions) result->Second->Second=new MultidimensionalTable<double>(*result->First->First);
}
//cout <<"\nbefore:"<< *result->First <<"\n"<< *result->Second <<"\n";


this->trioCounters->tableGenotypes->estimateMLE(result->First->First, genotypeAbsFreqsTab, pointersToPartnerGenotypes,totalHaps, 1000, result->First->Second, result->Second->First, result->Second->Second, this->haplotypeTable);

if (emDistributions==oneDistribution) 
result->First->Second=new MultidimensionalTable<double>(*result->First->First);

if (emRestriction==noRestriction)
{
result->Second->First=new MultidimensionalTable<double>(*result->First->First);
result->Second->Second=new MultidimensionalTable<double>(*result->First->Second);
}


return result;
}
/*_______________________________________________________________*/

Pair<Pair<MultidimensionalTable<double>*>*>* TrioCountersHapUAndTUnknownHaps::getHaplotypeFreqsTab()
{
MultidimensionalTable<double>* genotypeAbsFreqsTab;
MultidimensionalTable<longLongList*>* pointersToPartnerGenotypes=NULL;
if (emRestriction==noRestriction) 
{
genotypeAbsFreqsTab=trioCounters->getGenotypeAbsFreqs(parent);
this->totalHaplotypes=genotypeAbsFreqsTab->getTotalCounts()*2;
}
else // triosBased restriction
{
genotypeAbsFreqsTab=trioCounters->getGenotypeAbsFreqs(father);
pointersToPartnerGenotypes=trioCounters->getPointersToPartnerGenotypes(mother);
this->totalHaplotypes=genotypeAbsFreqsTab->getTotalCounts()*4;
}
Pair<Pair<MultidimensionalTable<double>*>*>*result=getHaplotypeFreqsTab(0, genotypeAbsFreqsTab, pointersToPartnerGenotypes);
if (result->First==NULL) result=getHaplotypeFreqsTab(1, genotypeAbsFreqsTab, pointersToPartnerGenotypes);
if (result->First==NULL)
throw NullValue(" at TrioCountersHapUAndTUnknownHaps::getHaplotypeFreqsTab");


if (emRestriction==triosBasedRestriction) zap(pointersToPartnerGenotypes);



zap(genotypeAbsFreqsTab);

return result;
}


/*_________________________________________________________________*/

TrioCountersHapUAndTUnknownHaps::TrioCountersHapUAndTUnknownHaps():TrioCountersHapUAndT()
{
//haplotypeFreqsTab=NULL;
//haplotypeFreqsTabU=NULL;
}

/*_________________________________________________________________*/

TrioCountersHapUAndTUnknownHaps * TrioCountersHapUAndTUnknownHaps::getPermutation ()
{
TrioCounters *tempResult=this->trioCounters->getPermutation();
TrioCountersHapUAndTUnknownHaps* result=new TrioCountersHapUAndTUnknownHaps(tempResult, phaseAlg, emDistributions, emRestriction);
return result;
//zap (tempResult);
}


};  // End of Namespace

#endif

/* End of file: MultimarkerMeasure.h */




