/* File: MultimarkerMeasure.h */

#ifndef __TrioCountersHapUAndTUnknownHaps_h__
#define __TrioCountersHapUAndTUnknownHaps_h__

//using namespace stats;

namespace BIOS {


/************************/
/* SNP'S MultimarkerMeasure DEFINITION */
/************************/


/**
        @memo MultimarkerMeasure for SNPs

	@doc
        Definition:
        A unordered pair of SNPs values for an individual and a genetic position.
        One has been transmitted from the father, one for the mother. Who transmits
        each one of them does not matter.

        Memory space: O(1). 

        @author Maria M. Abad
	@version 1.0
*/


 
class	TrioCountersHapUAndTUnknownHaps: public TrioCountersHapUAndT {

private:

PhaseAlg phaseAlg;
EMDistributions emDistributions;
EMRestriction emRestriction;

public:


//MultidimensionalTable<double>* haplotypeFreqsTab, * haplotypeFreqsTabU, *hapFreqsTab;



       
/*********************************************************************/
/***     ASSOCIATED FUNCTIONS     ***/
/*********************************************************************/


      public:


	TrioCountersHapUAndTUnknownHaps(SNPPos Pos[], SNPPos totalPos, TrioSample * samp, int affectation=allAffectation, PhaseAlg=weighted, EMDistributions emDistributions=UTDistributions, EMRestriction emRestriction=triosBasedRestriction, bool tdt=false, bool includeMissing=false);
	
 //TrioCountersHapUAndTUnknownHaps(TrioCountersHapUAndTUnknownHaps& source);
 TrioCountersHapUAndTUnknownHaps();

 ~TrioCountersHapUAndTUnknownHaps();

 void set(TrioCountersHapUAndTUnknownHaps& source);

//TrioCountersHapUAndTUnknownHaps(TrioCountersHapUAndT& source);

TrioCountersHapUAndTUnknownHaps(TrioCounters* source, PhaseAlg phaseAlg=weighted, EMDistributions emDistributions=UTDistributions, EMRestriction emRestriction=triosBasedRestriction);

TrioCountersHapUAndTKnownHaps* convertToTrioCountersHapUAndTKnownHaps();

void setHaplotypeFreqs();

//void setHaplotypeFreqs();

 void setHaplotypeFreqsTab();

ParentalHaplotypes* getParentalHaplotypes(long long int ambiguousPosFather, long long int ambiguousPosMother, int hapConfiguration);

double getCurrentFrequency(Pair<MultidimensionalTable<double>*>* haplotypeFreqsTabPairFather,
Pair<MultidimensionalTable<double>*>* haplotypeFreqsTabPairMother, ParentalHaplotypes* parentalHaplotype);




double getNormalizationValue(int totalConfigurations, long long int ambiguousPosFather, long long int ambiguousPosMother, Pair<MultidimensionalTable<double>*>* haplotypeFreqsTabPairFather,
Pair<MultidimensionalTable<double>*>* haplotypeFreqsTabPairMother);



 TrioCountersHapUAndTUnknownHaps* clone();

Pair<Pair<MultidimensionalTable<double>*>*>* getHaplotypeFreqsTab(int type, MultidimensionalTable<double>* genotypeAbsFreqsTab,  MultidimensionalTable<longLongList*>* pointersToPartnerGenotypes);

Pair<Pair<MultidimensionalTable<double>*>*>* getHaplotypeFreqsTab();


 //MultidimensionalTable<double>* setInitialEstimation(int type);

MultidimensionalTable<double>* getInitialEstimation(int type);

 TrioCountersHapUAndTUnknownHaps* getPermutation();


//Pair<BidimensionalTable<double>*>* getMultiallelicFreqs(SNPPos a, SNPPos b);


};  // End of class MultimarkerMeasure
/*
ostream& operator<<(ostream& out, TrioCountersHapUAndTUnknownHaps& pm)
       {
cout << (TrioCountersHapUAndT&)pm;
if (pm.haplotypeFreqs!=NULL)
   out << *pm.haplotypeFreqs <<"\n";

if (pm.haplotypeFreqsU!=NULL)
   out << *pm.haplotypeFreqsU << "\n";


return out;
};
*/


};  // End of Namespace

#endif

/* End of file: MultimarkerMeasure.h */




