/* File: TrioGenotype.h */


#ifndef __TrioGenotype_h__
#define __TrioGenotype_h__





namespace BIOS {


/************************/
/* SNP'S GENOTYPE DEFINITION */
/************************/


/**
        @memo GenotypePointer for SNPs

	@doc
        Definition:
        A unordered pair of SNPs values for an individual and a genetic position.
        One has been transmitted from the father, one for the mother. Who transmits
        each one of them does not matter.

        Memory space: O(1). 

        @author Maria M. Abad
	@version 1.0
*/

//class TrioSNPGenotype;
 
class TrioGenotype {


public:
    /** @name Implementation of class GenotypePointer
        @memo Private part.
    */
	

	Genotype* fatherGenotype, *motherGenotype, *childGenotype;
	GenotypePointer FatherGenotype, MotherGenotype, ChildGenotype;
	GenotypeSample* genotypeSample;

	char line[100];	
   
/**
   @memo Pointer to the array of snps. It's NULL if snps has not been assigned yet.
*/


/*********************************************************************/
/***     ASSOCIATED FUNCTIONS     ***/
/*********************************************************************/

/* Head */


		/* PUBLIC FUNCTIONS (INTERFACE) */

      public:



      /** @name Operations on GenotypePointer 
        @memo Operations on a GenotypePointer 
    */

      /**
         @memo Constructor 
         @doc
          Allocate memory an initialize to null.
          Complexity O(1).

      */


		TrioGenotype(GenotypeSample * genotypeSample);

		TrioGenotype (GenotypeSample * genotypeSample, GenotypePointer FatherGenotype, GenotypePointer MotherGenotype, GenotypePointer ChildGenotype);


      /**
	 @memo Destructor
	 @doc
           Deallocate memory used by snps.
           Time complexity O(1).

      */
      ~TrioGenotype (){};

//	  bool IsComplete (SNPPos SNP1, SNPPos SNP2);

//	  bool IsHeterozygous (SNPPos SNP1, SNPPos SNP2, allele * MajorAllele);      

	  GenotypePointer GetFatherGenotype ();

	  GenotypePointer GetMotherGenotype ();

	  GenotypePointer GetChildGenotype ();

	  GenotypePointer getGenotype (IndCategory ic);


	  void SetFatherGenotype (GenotypePointer genotype);

	  void SetMotherGenotype (GenotypePointer genotype);

	  void SetChildGenotype (GenotypePointer genotype);

	  int getInconsistencies(SNPPos SNP, IndCategory ic=parent);

   PairGenotype* getPairGenotype(IndCategory ic); 

//	  TrioSNPGenotype getSNPGenotype(SNPPos SNP);

    void solveMIUsingChild(SNPPos SNP);

    bool isMissing(SNPPos SNP);

    void completeMissing(SNPPos SNP);

void removeMI(SNPPos SNP);

	//  string PrintGenotype(SNPPos SNP);

};  // End of class GenotypePointer

ostream& operator<<(ostream& out,TrioGenotype& trio);
/*
ostream& operator<<(ostream& out,TrioGenotype& trio, SNPPos SNP)
{

out << *trio.genotypeSample->getElement(trio.FatherGenotype)<<"\n";
out << *trio.genotypeSample->getElement(trio.MotherGenotype) <<"\n";
out << *trio.genotypeSample->getElement(trio.ChildGenotype) <<"\n";
return out;
  }
*/

//template<> ostream& operator<<(ostream& out, Container<vector,TrioGenotype>& l){};







};  // End of Namespace

#endif

/* End of file: GenotypePointer.h */




