/* File: TrioSample.h */


#ifndef __TrioSample_h__
#define __TrioSample_h__

//#include <string.h>
//#include <cstdio>


//#include "GenomaSample.cpp"

//#include "CoupleGenotype.h"
namespace BIOS {


/************************/
/* SNP'S GENOTYPE DEFINITION */
/************************/


/**
        @memo Genotype for SNPs

	@doc
        Definition:
        A unordered pair of SNPs values for an individual and a genetic position.
        One has been transmitted from the father, one for the mother. Who transmits
        each one of them does not matter.

        Memory space: O(1). 

        @author Maria M. Abad
	@version 1.0
*/

class TUCounts;
class HapExtractionConfiguration;
 
	class TrioSample: public GenomaSample {

	public:
   	Container<vector<Trio*>, Trio*> *TrioList;
	int* inconsistencies, *nonHeteroParents, *parentsNotInHWE, *childrenNotInHWE, *fatherInconsistencies, *motherInconsistencies;

	protected:
    /** @name Implementation of class TrioSample
        @memo Private part.
    */
    	//IndCategory ic;
	bool CompleteMissing;	
    	bool allowRecombination, solveMIUsingChildren;

/*********************************************************************/
/***     ASSOCIATED FUNCTIONS     ***/
/*********************************************************************/

	     void CreateTrioList ();
             void InitializeTrioSample();

		/* PUBLIC FUNCTIONS (INTERFACE) */
      public:

      /** @name Operations on TrioSample 
        @memo Operations on a TrioSample 
    */

		  TrioSample (TrioSample& source, Container<set<SNPPos>, SNPPos> *Sampling=NULL, bool selectInds=false);
		  TrioSample (TrioSample& source, Container<set<string>, string> *Sampling, char* filePos) throw (Inconsistent&);
		  TrioSample(char* filename, int*pos, int size, AlleleOrderType AlleleOrderMode=MajorFirst, bool CompleteMiss=true, bool allowRecombination=false, bool solveMIUsingChildren=false); 
		  virtual ~TrioSample ();


TrioSample* clone();

void importFromBeagle ( char* filename );

void copy(TrioSample& source);
void init();
//void setWithSelection(TrioSample& source, Container<set<IndPos>, IndPos>* Sampling);
TrioSample* permute();

int size();

void setAffectationRandomly();
//		  TrioSample (PhenotypeSample& SourceP, GenotypeSample& SourceG);

intList* getPedigreeID(IndCategory ic);
//TrioSample (GenomaSample& Source, bool CompleteMis=true);
Trio* GetTrioMembers (PhenotypeSample::iterator IndPhenotype, GenotypeSample::iterator IndGenotype);

double getChildrenHWETest (SNPPos SNP);
int getNonHeteroParents (SNPPos SNP);
int getInconsistenciesFromParents (SNPPos SNP, IndCategory ind=parent);

SNPPos getTotalSNPs();

	/**
	* Create a VectorOfParentalGenotypes from the sample
	* @param absolutePositions Vector of absolute positions from the input file
	* @param totalPos Length of the pos vector. The number of positions
	* @return VectorOfParentalGenotypes
	*/


     // TrioSample (TrioSample& source, Container<vector<IndPos>, IndPos>* Sampling);
		  allele getMajorAllele (SNPPos SNP, IndCategory ic, int gender=everyGender, int affectation=allAffectation);
		  allele getMinorAllele (SNPPos SNP, IndCategory ic, int gender=everyGender, int affectation=allAffectation);
	//	void PrintTrios (char* filename);
		void CheckInconsistenciesFromParents ();
  TrioSample* shuffleTransmissions ();
		void completeMissing();
		SNPPos getTotalType (SNPPos SNP, IndCategory ic, int genotypePos, int gender=everyGender, int affectation=allAffectation);
		SNPPos GetTotalHomozygous1 (SNPPos SNP, IndCategory ic, int gender=everyGender, int affectation=allAffectation);
		SNPPos GetTotalHomozygous2 (SNPPos SNP, IndCategory ic, int gender=everyGender, int affectation=allAffectation);
		SNPPos GetTotalHeterozygous (SNPPos SNP, IndCategory ic, int gender=everyGender, int affectation=allAffectation);
		SNPPos GetTotalMissing (SNPPos SNP, IndCategory ic, int gender=everyGender, int affectation=allAffectation);
		SNPPos GetTotalNonMissing (SNPPos SNP, IndCategory ic, int gender=everyGender, int affectation=allAffectation);
//		SNPPos GetDoubleHeterozygous (SNPPos FirstSNP, SNPPos LastSNP, MultiallelicHetero i, MultiallelicHetero j, IndCategory ic, int gender=everyGender, int affectation=allAffectation);
//		SNPPos GetUnsolvedDoubleHeterozygous (SNPPos FirstSNP, SNPPos LastSNP, MultiallelicHetero i, MultiallelicHetero j, IndCategory ic, bool IsPartiallySolved, int gender=everyGender, int affectation=allAffectation);
		SNPPos GetTotalAllele (SNPPos SNP, allele allele1, IndCategory ic, int gender=everyGender, int affectation=allAffectation);

		SNPPos GetAllelePair(SNPPos SNP1, SNPPos SNP2, IndCategory ic, int gender=everyGender, int affectation=allAffectation);
		int CountAlleles (SNPPos SNP, unsigned int Basis[5], IndCategory ic, int gender=everyGender, int affectation=allAffectation);
		IndPos getTotalTrios();
		void OrderLeftRight ();

		TrioSample* solvePhase (EMDistributions emDistributions=UTDistributions, EMRestriction emRestriction=triosBasedRestriction, int windowSize=10);

		void CheckParentsHWE ();
		void CheckChildrenHWE ();

void solveMendelianInconsistenciesUsingChildren ();

longLongList* getGenotypeCounts (const SNPPos *pos, int totalPos, IndCategory ic, int gender, int affectation, AmbiguousArray* tableGenotypes, bool onlyHetero=false, bool includeMissing=false);

	VectorOfParentalGenotypes* getGenotypeCounts (const SNPPos *absolutePositions, int totalPos, bool includeMissing=false);  


Genotype* getGenotype(Container<vector<Trio*>, Trio*>::iterator TrioPos, IndCategory ind);
//TUCounts* getTUCounts(int *pos, int length, bool onlyHetero=true, int totalPermutations=100, AlleleOrderType alleleOrderType=LeftRight, PhaseAlg phaseAlg=onlyKnown, EMDistributions emDistributions=UTDistributions, EMRestriction emRestriction=triosBasedRestriction);
//	void completeMissing ();

	void removeMendelianInconsistencies ();

void completeMissing (SNPPos SNP);

void addPartner (PhenotypeSample::iterator IndPhenotype, GenotypeSample::iterator IndGenotype, PhenotypeSample::iterator partnerPhenotype, GenotypeSample::iterator partnerGenotype);

TUCounts * getTUCounts (int *pos, int length, HapExtractionConfiguration* hapExtractionConfiguration, int totalPermutations=100, bool rincludeMissing=false);

virtual void print(ostream&);

virtual stringSample* ExportToBeagle (stringList* Pos);

//TrioSample* copyElementsWithPositionsIn(intSet* positions, bool inThis=true);

};  // End of class TrioSample

};
// End of Namespace

#endif

/* End of file: TrioSample.h */





