/* File: ParentalGenotypesUsingPointers.h */

#ifndef __VectorOfParentalHaplotypes_h__
#define __VectorOfParentalHaplotypes_h__

//using namespace stats;

namespace BIOS {


/************************/
/* SNP'S MultimarkerMeasure DEFINITION */
/************************/


/**
        @memo __ParentalGenotypes 
	@doc
        Definition:

       Class used mainly to compute multimarker tdt or its many variants. In order to similarity measures to can be applied, haplotype counters (or freqs if EM-freq is used) for each couple must be independently kept. One trio may have more than one parentalHaplotype (freqs must sum 1). For this reason, attribute trioCount is required. 

       With this purpose, the class required is:
 

        @author Maria M. Abad Grau
	@version 1.0
*/


struct HapCounts
{
double left;
double right;
double homo;
HapCounts(double left, double right, double homo)
{this->left=left; this->right=right; this->homo=homo;}
HapCounts* fromString(string s){throw NonImplemented("HapCounts* fromString");};
HapCounts* clone() {throw NonImplemented("HapCounts* clone");};
friend ostream& operator<<(ostream& out, HapCounts& lista){out << "["<< lista.left <<":"<<lista.right <<":"<<lista.homo<<"]"; return out;};
bool operator==(HapCounts& other) {throw NonImplemented("HapCounts::operator==(HapCounts& other)");};
};

	class VectorOfParentalHaplotypes: public ParentalHaplotypesUsingPointersList
{
private:

int* pos;
int length;

public:
VectorOfParentalHaplotypes(int* pos, int length);
VectorOfParentalHaplotypes(VectorOfParentalHaplotypes& other);
HaplotypeTUCountsVector* getHaplotypeCountsVector(bool includeMissing=false);
~VectorOfParentalHaplotypes();
int getLength();
int* getPositions();
void setPositions(int * positions);
void setLength(int length);
virtual VectorOfParentalHaplotypes* clone();
//HaplotypeTUCountsVector* getHaplotypeCountsVector();//int* relativePos, int size);

friend ostream& operator<<(ostream& out, VectorOfParentalHaplotypes& lista);

void print();
};
	


   ostream& operator<<(ostream& out, VectorOfParentalHaplotypes& lista);
	
	
  


};  // End of Namespace

#endif

/* End of file: MultimarkerMeasure.h */




