/* File: UnorderedRepeatedPositions.h */

#ifndef __UnorderedRepeatedPositions_h__
#define __UnorderedRepeatedPositions_h__

//#include <string>
//#include <math.h>
//#include <cassert>

//#include "fstream.h"

//#include <iostream>//
//#include <cassert>//
//#include <cstring>//
//#include <cstdio>//
//#include <cstdlib>//
//#include <cmath>//
//#include <ctime>//
//#include <malloc.h>//
//#include <fstream>//




//using namespace std;
//using namespace string;

//#include "VirtualPositions.cpp"

using namespace std;


namespace BIOS {


/************************/
/* UnorderedRepeatedPositions DEFINITION */
/************************/


/**
        @memo UnorderedRepeatedPositions for SNPs

	@doc
        Definition:
        A set of phenotype's features and genotypes for an UnorderedRepeatedPositions

        Memory space: O(TotalSNPs), which TotalSNPs being the number of SNPs in the sample
        Each UnorderedRepeatedPositions in a sample has been genotyped for the same TotalSNPs SNPs.

        @author Maria M. Abad
	@version 1.0
*/
	
	
class UnorderedRepeatedPositions: public VirtualPositions
	 {

  private:
    /** @name Implementation of class UnorderedRepeatedPositions
        @memo Private part.
    */
  

/***************************************************************/
/***     ASSOCIATED FUNCTIONS     ***/
/*********************************************************************/

/* Head */



//	void OrderUnorderedRepeatedPositions();

	void CheckFilename(char* filename);


  protected:

  	PosS ReadElement (ifstream * is);

	
	void PrintUnorderedRepeatedPositions ();

	void SetFilePos ();


      /* PUBLIC FUNCTIONS (INTERFACE) */




      public:



 /**
         @memo Constructor 
         @doc
          Allocate memory an initialize to null.
          Complexity O(1).

      */

		UnorderedRepeatedPositions(char* filename); 

		  
	  /**
         @memo Creates a new UnorderedRepeatedPositions object with the phase resolved.
         @param Origen: the origianl UnorderedRepeatedPositions object 
         Time complexity O(TotalSNPs*Size*Size)

      */
        void PrintRepeatedPositions();

		SNPPos GetTotalSNPs();

		void CheckRangeSNP(SNPPos SNP);


};  // End of class UnorderedRepeatedPositions




};  // Fin del Namespace

#endif

/* Fin Fichero: UnorderedRepeatedPositions.h */
