/*
 * Decompiled with CFR 0.152.
 */
package BMap3D.universe;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.image.BufferedImage;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.GraphicsContext3D;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.Raster;
import javax.vecmath.Point3f;

public class CapturingCanvas3D
extends Canvas3D {
    private boolean writeTo = false;
    private int swapCount = 0;
    private int resX = 512;
    private int resY = 512;
    private String name;
    private static final long serialVersionUID = -5819966878098803176L;

    public CapturingCanvas3D(GraphicsConfiguration gc) {
        super(gc);
    }

    public void capture(String fileName) {
        this.writeTo = true;
        Dimension actualDim = this.getSize();
        this.resX = actualDim.width;
        this.resY = actualDim.height;
        this.name = fileName;
        this.repaint();
    }

    public void postSwap() {
        if (this.writeTo) {
            System.out.println("Writing to JPEG: " + this.name + " (count=" + this.swapCount + ")");
            GraphicsContext3D graphics = this.getGraphicsContext3D();
            Raster ras = new Raster(new Point3f(1.0f, 1.0f, 1.0f), 1, 0, 0, this.resX, this.resY, new ImageComponent2D(1, new BufferedImage(this.resX, this.resY, 1)), null);
            graphics.readRaster(ras);
            BufferedImage img = ras.getImage().getImage();
            try {
                FileOutputStream out = new FileOutputStream(this.name);
                JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)out);
                JPEGEncodeParam param = encoder.getDefaultJPEGEncodeParam(img);
                param.setQuality(0.9f, false);
                encoder.setJPEGEncodeParam(param);
                encoder.encode(img);
                this.writeTo = false;
                out.close();
            }
            catch (IOException e) {
                System.out.println("I/O exception!");
            }
            ++this.swapCount;
        }
    }
}

