/*
 * Decompiled with CFR 0.152.
 */
package BMap3D.universe;

import BMap3D.universe.AppearanceChangeProcessor;
import BMap3D.universe.ProcessNodeInterface;
import BMap3D.universe.TreeScan;
import BMap3D.universe.UserData;
import javax.media.j3d.Appearance;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TransparencyAttributes;

public class ChangeTransparencyAttributes {
    public static void setTransparency(Node treeRoot, final int mode) {
        AppearanceChangeProcessor processor = new AppearanceChangeProcessor(){

            public void changeAppearance(Shape3D shape, Appearance app) {
                if (app == null) {
                    return;
                }
                UserData ud = (UserData)shape.getUserData();
                if (ud == null) {
                    return;
                }
                if (!ud.isBlock3D()) {
                    return;
                }
                float value = 1.0f;
                if (mode == 2) {
                    value = ud.getTransparency();
                }
                TransparencyAttributes transattributes = new TransparencyAttributes(mode, value);
                app.setTransparencyAttributes(transattributes);
            }
        };
        ChangeTransparencyAttributes.scanTree(treeRoot, processor);
    }

    private static void scanTree(Node treeRoot, AppearanceChangeProcessor processor) {
        try {
            Class<?> shapeClass = Class.forName("javax.media.j3d.Shape3D");
            TreeScan.findNode(treeRoot, shapeClass, (ProcessNodeInterface)processor, false, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("ERROR ChangeTransparencyAttributes, SceneGraph contains Live or compiled nodes, without correct capabilities");
        }
    }
}

