/*
 * Decompiled with CFR 0.152.
 */
package BMap3D.universe;

import java.util.ArrayList;
import java.util.Iterator;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.HiResCoord;
import javax.media.j3d.Locale;
import javax.media.j3d.VirtualUniverse;
import javax.swing.JOptionPane;

public class DevelopmentLocale
extends Locale {
    public ArrayList branchGraphs = new ArrayList();
    private BranchGroup[] branchGraphArray = new BranchGroup[0];
    private BranchGroup hiddenBranchGraph = null;
    private boolean isLive = true;

    public DevelopmentLocale(VirtualUniverse universe) {
        super(universe);
        this.init();
    }

    public DevelopmentLocale(VirtualUniverse universe, HiResCoord hiRes) {
        super(universe, hiRes);
        this.init();
    }

    public DevelopmentLocale(VirtualUniverse universe, int[] x, int[] y, int[] z) {
        super(universe, x, y, z);
        this.init();
    }

    private void init() {
        this.isLive = true;
    }

    public void setHiddenBranchGraph(BranchGroup hiddenBranchGraph) {
        this.hiddenBranchGraph = hiddenBranchGraph;
        hiddenBranchGraph.setCapability(17);
        if (this.isLive) {
            super.addBranchGraph(hiddenBranchGraph);
        }
    }

    public BranchGroup getHiddenBranchGraph() {
        return this.hiddenBranchGraph;
    }

    public void addBranchGraph(BranchGroup branchGroup) {
        boolean wasLive = this.isLive;
        if (this.isLive) {
            this.setLive(false);
        }
        if (branchGroup.isCompiled()) {
            JOptionPane.showMessageDialog(null, "Compiled Branch Group's can not be viewed, remove the .compile() from your source code.", "Compiled Branch Group", 2);
        } else {
            branchGroup.setCapability(17);
            this.branchGraphs.add(branchGroup);
        }
        this.updateBranchGraphArray();
        if (this.isLive) {
            super.addBranchGraph(branchGroup);
        }
        if (wasLive) {
            this.setLive(true);
        }
    }

    public void removeBranchGraph(BranchGroup branchGroup) {
        this.branchGraphs.remove(this.branchGraphs.indexOf(branchGroup));
        this.updateBranchGraphArray();
        if (this.isLive) {
            super.removeBranchGraph(branchGroup);
        }
    }

    public void replaceBranchGraph(BranchGroup oldGroup, BranchGroup newGroup) {
        newGroup.setCapability(17);
        this.branchGraphs.set(this.branchGraphs.indexOf(oldGroup), newGroup);
        this.updateBranchGraphArray();
        if (this.isLive) {
            super.replaceBranchGraph(oldGroup, newGroup);
        }
    }

    public int numBranchGraphs() {
        return this.branchGraphs.size();
    }

    public synchronized void setLive(boolean live) {
        if (this.isLive == live) {
            return;
        }
        Iterator it = this.branchGraphs.iterator();
        while (it.hasNext()) {
            BranchGroup bg = (BranchGroup)it.next();
            if (live) {
                super.addBranchGraph(bg);
                continue;
            }
            bg.detach();
        }
        if (this.hiddenBranchGraph != null) {
            if (live) {
                super.addBranchGraph(this.hiddenBranchGraph);
            } else {
                this.hiddenBranchGraph.detach();
            }
        }
        this.isLive = live;
    }

    public boolean getLive() {
        return this.isLive;
    }

    public BranchGroup[] getBranchGraphs() {
        return this.branchGraphArray;
    }

    public void updateBranchGraphArray() {
        this.branchGraphs.trimToSize();
        if (this.branchGraphs.size() != this.branchGraphArray.length) {
            this.branchGraphArray = new BranchGroup[this.branchGraphs.size()];
        }
        this.branchGraphArray = this.branchGraphs.toArray(this.branchGraphArray);
    }
}

