/*
 * Decompiled with CFR 0.152.
 */
package BMap3D.universe;

import BMap3D.universe.ViewerBehavior;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.WakeupOnElapsedFrames;

public class ExamineViewerBehavior
extends ViewerBehavior {
    protected int previousX = 0;
    protected int previousY = 0;
    protected double curRotationX = 0.0;
    protected double PIMED = 1.5707963267948966;
    protected Cursor savedCursor = null;

    public ExamineViewerBehavior() {
    }

    public ExamineViewerBehavior(Component parent) {
        super(parent);
    }

    public ExamineViewerBehavior(TransformGroup transformGroup) {
        this.subjectTransformGroup = transformGroup;
    }

    public ExamineViewerBehavior(TransformGroup transformGroup, Component parent) {
        super(parent);
        this.subjectTransformGroup = transformGroup;
    }

    public void onButton1(MouseEvent mev) {
        if (this.subjectTransformGroup == null) {
            return;
        }
        int x = mev.getX();
        int y = mev.getY();
        if (mev.getID() == 501) {
            this.previousX = x;
            this.previousY = y;
            if (this.parentComponent != null) {
                this.savedCursor = this.parentComponent.getCursor();
                this.parentComponent.setCursor(Cursor.getPredefinedCursor(12));
            }
            return;
        }
        if (mev.getID() == 502) {
            if (this.parentComponent != null) {
                this.parentComponent.setCursor(this.savedCursor);
            }
            return;
        }
        int deltaX = x - this.previousX;
        int deltaY = y - this.previousY;
        if (deltaX > 400 || deltaX < -400 || deltaY > 400 || deltaY < -400) {
            return;
        }
        double xRotationAngle = (double)deltaY * this.XRotationFactor;
        this.curRotationX += xRotationAngle;
        if (this.curRotationX < 0.0 || this.curRotationX > this.PIMED) {
            this.curRotationX -= xRotationAngle;
            xRotationAngle = 0.0;
        }
        this.transform1.rotX(xRotationAngle);
        this.subjectTransformGroup.getTransform(this.currentTransform);
        this.currentTransform.get(this.matrix);
        this.translate.set(this.matrix.m03, this.matrix.m13, this.matrix.m23);
        this.currentTransform.setTranslation(this.origin);
        this.currentTransform.mul(this.transform1, this.currentTransform);
        this.currentTransform.setTranslation(this.translate);
        this.subjectTransformGroup.setTransform(this.currentTransform);
        this.previousX = x;
        this.previousY = y;
    }

    public void onButton2(MouseEvent mev) {
        if (this.subjectTransformGroup == null) {
            return;
        }
        int x = mev.getX();
        int y = mev.getY();
        if (mev.getID() == 501) {
            this.previousX = x;
            this.previousY = y;
            if (this.parentComponent != null) {
                this.savedCursor = this.parentComponent.getCursor();
                this.parentComponent.setCursor(Cursor.getPredefinedCursor(13));
            }
            return;
        }
        if (mev.getID() == 502) {
            if (this.parentComponent != null) {
                this.parentComponent.setCursor(this.savedCursor);
            }
            return;
        }
        int deltaY = y - this.previousY;
        if (deltaY > 400 || deltaY < -400) {
            return;
        }
        double zTranslationDistance = (double)deltaY * this.ZTranslationFactor;
        this.translate.set(0.0, 0.0, zTranslationDistance);
        this.transform1.set(this.translate);
        this.subjectTransformGroup.getTransform(this.currentTransform);
        this.currentTransform.mul(this.transform1, this.currentTransform);
        this.subjectTransformGroup.setTransform(this.currentTransform);
        this.previousX = x;
        this.previousY = y;
    }

    public void onButton3(MouseEvent mev) {
        if (this.subjectTransformGroup == null) {
            return;
        }
        int x = mev.getX();
        int y = mev.getY();
        if (mev.getID() == 501) {
            this.previousX = x;
            this.previousY = y;
            if (this.parentComponent != null) {
                this.savedCursor = this.parentComponent.getCursor();
                this.parentComponent.setCursor(Cursor.getPredefinedCursor(13));
            }
            return;
        }
        if (mev.getID() == 502) {
            if (this.parentComponent != null) {
                this.parentComponent.setCursor(this.savedCursor);
            }
            return;
        }
        int deltaX = x - this.previousX;
        int deltaY = y - this.previousY;
        if (deltaX > 400 || deltaX < -400 || deltaY > 400 || deltaY < -400) {
            return;
        }
        double xTranslationDistance = (double)deltaX * this.XTranslationFactor;
        double yTranslationDistance = (double)(-deltaY) * this.YTranslationFactor;
        this.translate.set(xTranslationDistance, yTranslationDistance, 0.0);
        this.transform1.set(this.translate);
        this.subjectTransformGroup.getTransform(this.currentTransform);
        this.currentTransform.mul(this.transform1, this.currentTransform);
        this.subjectTransformGroup.setTransform(this.currentTransform);
        this.previousX = x;
        this.previousY = y;
    }

    public void onElapsedFrames(WakeupOnElapsedFrames timeEvent) {
    }
}

