/*
 * Decompiled with CFR 0.152.
 */
package GUI;

import GUI.MAFPanel;
import file.MyFile;
import file.TextFile;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;

public class CompletePanel
extends MAFPanel {
    private static final long serialVersionUID = 1L;
    int Type1;
    int Type2;
    JLabel lType1;
    JLabel lType2;
    JTextField tType1;
    JTextField tType2;
    JComboBox cType1;
    JComboBox cType2;
    FileActionListener fileActionListener3;
    JButton hType1;
    JButton hType2;

    public CompletePanel(String text, String text2, String text3, int r, int c) {
        super(text, text2, text3, r, c);
        this.Type1 = 3;
        this.Type2 = 4;
        this.SNP1A = -1;
        this.SNP2A = -1;
        this.printPanel();
    }

    public CompletePanel(String text, String text2, String text3, CompletePanel cP) {
        super(text, text2, text3, cP.getSNP1(), cP.getSNP2(), cP.getSNP1A(), cP.getSNP2A(), cP.getEstimatorColumn(), cP.getColumns(), cP.getHasHeading(), cP.getMAF1(), cP.getMAF2(), cP.getFileName(), cP.getAnnotationFileName(), cP.getAnnotation2FileName(), cP.getRows(), cP.getCols());
        this.Type1 = cP.getType1();
        this.Type2 = cP.getType2();
        this.printPanel();
    }

    public CompletePanel(String text, String text2, String text3, int SNP1, int SNP2, int SNP1A, int SNP2A, int estimatorColumn, ArrayList columns, boolean hasHeading, int MAF1, int MAF2, int Type1, int Type2, String fileName, String rsFileName, String rs2FileName, int r, int c) {
        super(text, text2, text3, SNP1, SNP2, SNP1A, SNP2A, estimatorColumn, columns, hasHeading, MAF1, MAF2, fileName, rsFileName, rs2FileName, r, c);
        this.Type1 = Type1;
        this.Type2 = Type2;
        this.printPanel();
    }

    public void printPanel() {
        this.lType1 = new JLabel(" SNP1 type column:");
        this.lType2 = new JLabel(" SNP2 type column:");
        this.lType1.setSize(this.w, this.h);
        this.lType2.setSize(this.w, this.h);
        this.tType1 = new JTextField("");
        this.tType2 = new JTextField("");
        this.tType1.setEditable(false);
        this.tType2.setEditable(false);
        this.tType1.setSize(this.w, this.h);
        this.tType2.setSize(this.w, this.h);
        this.cType1 = new JComboBox();
        this.cType2 = new JComboBox();
        this.cType1.setSize(this.w, this.h);
        this.cType2.setSize(this.w, this.h);
        URL imageURL = this.getClass().getClassLoader().getResource("helpSmall.png");
        ImageIcon icon = new ImageIcon(imageURL, "help icon");
        this.hType1 = new JButton(icon);
        this.hType2 = new JButton(icon);
        this.tType1.setText("" + (this.Type1 + 1));
        this.tType2.setText("" + (this.Type2 + 1));
        if (this.columns.size() > 0) {
            if (this.Type1 == -1) {
                this.tType1.setText("-");
            } else {
                this.tType1.setText(this.Type1 + 1 + ": " + (String)this.columns.get(this.Type1));
            }
            if (this.Type2 == -1) {
                this.tType2.setText("-");
            } else {
                this.tType2.setText(this.Type2 + 1 + ": " + (String)this.columns.get(this.Type2));
            }
        }
        if (!this.fileName.equals("")) {
            this.removeAllItems();
            this.addItems(this.columns);
        } else {
            this.cType1.setEnabled(false);
            this.cType2.setEnabled(false);
        }
        if (this.cSNP1.getItemCount() > 0) {
            this.cSNP1.setSelectedIndex(this.SNP1);
            this.cSNP2.setSelectedIndex(this.SNP2);
            this.cEstimatorColumn.setSelectedIndex(this.estimatorColumn);
        }
        if (this.cSNP1A.getItemCount() > 0) {
            this.cSNP1A.setSelectedIndex(this.SNP1A);
            this.cSNP2A.setSelectedIndex(this.SNP2A);
        }
        if (this.cMAF1.getItemCount() > 0) {
            this.cMAF1.setSelectedIndex(this.MAF1 + 1);
            this.cMAF2.setSelectedIndex(this.MAF2 + 1);
        }
        if (this.cType1.getItemCount() > 0) {
            this.cType1.setSelectedIndex(this.Type1 + 1);
            this.cType2.setSelectedIndex(this.Type2 + 1);
        }
        this.tType1.setBackground(Color.orange);
        this.tType2.setBackground(Color.orange);
        this.open.removeActionListener(this.fileActionListener2);
        this.fileActionListener3 = new FileActionListener();
        this.open.addActionListener(this.fileActionListener3);
        HActionListener hActionListener = new HActionListener();
        this.hType1.addActionListener(hActionListener);
        this.hType2.addActionListener(hActionListener);
        this.add(this.lType1);
        this.add(this.hType1);
        this.add(this.cType1);
        this.add(this.tType1);
        this.add(this.lType2);
        this.add(this.hType2);
        this.add(this.cType2);
        this.add(this.tType2);
    }

    public int getType1() {
        return this.Type1;
    }

    public int getType2() {
        return this.Type2;
    }

    protected void removeAllItems() {
        super.removeAllItems();
        if (this.cType1 != null) {
            ActionListener[] l = this.cType1.getActionListeners();
            for (int i = 0; i < l.length; ++i) {
                this.cType1.removeActionListener(l[i]);
            }
            this.cType1.removeAllItems();
            ActionListener[] l2 = this.cType2.getActionListeners();
            for (int i = 0; i < l2.length; ++i) {
                this.cType2.removeActionListener(l2[i]);
            }
            this.cType2.removeAllItems();
        }
    }

    protected void addItems(ArrayList cols) {
        super.addItems(cols);
        if (this.cType1 != null) {
            int i;
            if (cols.size() > 0) {
                this.cType1.addItem(new String("-"));
                this.cType2.addItem(new String("-"));
                this.cType1.addActionListener(new CB5ActionListener());
                this.cType2.addActionListener(new CB6ActionListener());
            }
            for (i = 0; i < cols.size(); ++i) {
                this.cType1.addItem(new String(" " + (i + 1) + ": " + cols.get(i)));
                this.cType1.addActionListener(new CB5ActionListener());
            }
            for (i = 0; i < cols.size(); ++i) {
                this.cType2.addItem(new String(" " + (i + 1) + ": " + cols.get(i)));
                this.cType2.addActionListener(new CB6ActionListener());
            }
        }
    }

    class FileActionListener
    implements ActionListener {
        FileActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            CompletePanel.this.fileName = MyFile.getFileName(true, ((JButton)e.getSource()).getParent());
            if (CompletePanel.this.fileName != null) {
                TextFile tFile = new TextFile(CompletePanel.this.fileName);
                CompletePanel.this.columns = tFile.getWordsInLine(0, ",\t");
                CompletePanel.this.totalColumns = CompletePanel.this.columns.size();
                CompletePanel.this.tFileName.setText(CompletePanel.this.fileName);
                if (!CompletePanel.this.hasHeading) {
                    CompletePanel.this.columns = new ArrayList();
                    for (int i = 0; i < CompletePanel.this.totalColumns; ++i) {
                        CompletePanel.this.columns.add("NA");
                    }
                }
                CompletePanel.this.removeAllItems();
                CompletePanel.this.addItems(CompletePanel.this.columns);
                CompletePanel.this.cSNP1.setEnabled(true);
                CompletePanel.this.cSNP2.setEnabled(true);
                CompletePanel.this.cEstimatorColumn.setEnabled(true);
                CompletePanel.this.cSNP1A.setEnabled(true);
                CompletePanel.this.cSNP2A.setEnabled(true);
                CompletePanel.this.cMAF1.setEnabled(true);
                CompletePanel.this.cMAF2.setEnabled(true);
                CompletePanel.this.cType1.setEnabled(true);
                CompletePanel.this.cType2.setEnabled(true);
                CompletePanel.this.cSNP1A.setEnabled(true);
                CompletePanel.this.cSNP2A.setEnabled(true);
                CompletePanel.this.open2.setBorder(new BevelBorder(0));
                CompletePanel.this.open2.setEnabled(true);
            } else {
                CompletePanel.this.fileName = null;
                CompletePanel.this.tFileName.setText("");
            }
        }
    }

    class HActionListener
    implements ActionListener {
        HActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            JButton r = (JButton)e.getSource();
            if (r == CompletePanel.this.hType1) {
                JOptionPane.showMessageDialog(null, "Optional field: Select a column where the type of SNP is specified for the first SNP.");
            } else {
                JOptionPane.showMessageDialog(null, "Optional field: Select a column where the type of SNP is specified for the second SNP.");
            }
        }
    }

    class CB6ActionListener
    implements ActionListener {
        CB6ActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            String s = ((JComboBox)e.getSource()).getSelectedItem().toString();
            CompletePanel.this.tType2.setText(s);
            CompletePanel.this.Type2 = s.equals("-") ? -1 : Integer.parseInt(s.substring(1, s.indexOf(58, 0))) - 1;
        }
    }

    class CB5ActionListener
    implements ActionListener {
        CB5ActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            String s = ((JComboBox)e.getSource()).getSelectedItem().toString();
            CompletePanel.this.tType1.setText(s);
            CompletePanel.this.Type1 = s.equals("-") ? -1 : Integer.parseInt(s.substring(1, s.indexOf(58, 0))) - 1;
        }
    }
}

