/*
 * Decompiled with CFR 0.152.
 */
package threads;

import BMap2D.Image;
import BMap2D.My2DJInternalFrame;
import BMap3D.My3DJInternalFrame;
import GUI.MainGUI;
import GUI.MyJInternalFrame;
import file.TextLine;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.zip.DataFormatException;
import javax.swing.JOptionPane;
import javax.vecmath.Color3f;
import javax.vecmath.Vector3f;
import threads.GUILongTask;
import threads.SwingWorker;

public class ExtractMap
extends GUILongTask {
    String completeFileNameSource;
    String annotationFile;
    String annotationFile2;
    public int error = 0;
    String argument;
    int SNP1;
    int SNP2;
    int SNP1A;
    int SNP2A;
    int estimatorColumn;
    int MAFColumn;
    int MAFColumn2;
    int resolution;
    int alleles1;
    int alleles2;
    int distance2D;
    int existSelected;
    int existMarked;
    int inCommon;
    long maxDistance;
    long trueMaxDistance;
    float MAF;
    boolean hasHeading;
    boolean useMAF;
    boolean D3;
    int totalPairs;
    int totalSNPs;
    int line = 0;
    int firstPosition;
    int lastPosition;
    Vector3f[] positions;
    MyJInternalFrame myJInternalFrame;
    My3DJInternalFrame my3DJInternalFrame;
    My2DJInternalFrame my2DJInternalFrame;
    int[] SNPPositions;
    Color color;
    boolean rs;
    boolean annotation;
    boolean annotation2;
    Color3f[][] colorCode;
    Color3f[] colorArray;
    MainGUI mainGUI;
    Image im;
    ArrayList markedSNPs;
    ArrayList selectedSNPs;
    ArrayList firstSNPArray;
    ArrayList secondSNPArray;
    ArrayList firstSNPAArray;
    ArrayList secondSNPAArray;
    ArrayList firstMajorArray;
    ArrayList firstMinorArray;
    ArrayList secondMajorArray;
    ArrayList secondMinorArray;
    ArrayList estimationArray;
    boolean[] marked;
    boolean[] selected;

    public ExtractMap(MainGUI mainGUI, MyJInternalFrame myJInternalFrame, int SNP1, int SNP2, int SNP1A, int SNP2A, int estimatorColumn, int MAFColum, int MAFColumn2, boolean hasHeading, float MAF, long maxDistance, int firstPosition, int lastPosition, String completeFileNameSource, String annotationFile1, String annotationFile2, Color color, int resolution) {
        super(myJInternalFrame);
        this.D3 = false;
        this.color = color;
        this.set(mainGUI, myJInternalFrame, SNP1, SNP2, SNP1A, SNP2A, estimatorColumn, MAFColum, MAFColumn2, -1, -1, hasHeading, MAF, maxDistance, firstPosition, lastPosition, resolution, completeFileNameSource, annotationFile1, annotationFile2);
    }

    public ExtractMap(MainGUI mainGUI, MyJInternalFrame myJInternalFrame, int SNP1, int SNP2, int SNP1A, int SNP2A, int estimatorColumn, int MAFColum, int MAFColumn2, int alleles1, int alleles2, boolean hasHeading, float MAF, long maxDistance, int firstPosition, int lastPosition, String completeFileNameSource, Color3f[][] colorCode) {
        super(myJInternalFrame);
        this.D3 = true;
        this.alleles1 = alleles1;
        this.alleles2 = alleles2;
        this.colorCode = colorCode;
        this.set(mainGUI, myJInternalFrame, SNP1, SNP2, SNP1A, SNP2A, estimatorColumn, MAFColum, MAFColumn2, alleles1, alleles2, hasHeading, MAF, maxDistance, firstPosition, lastPosition, this.resolution, completeFileNameSource, null, null);
    }

    protected void set(MainGUI mainGUI, MyJInternalFrame myJInternalFrame, int SNP1, int SNP2, int SNP1A, int SNP2A, int estimatorColumn, int MAFColumn, int MAFColumn2, int alleles1, int alleles2, boolean hasHeading, float MAF, long maxDistance, int firstPosition, int lastPosition, int resolution, String completeFileNameSource, String annotationFile, String annotationFile2) {
        this.mainGUI = mainGUI;
        this.myJInternalFrame = myJInternalFrame;
        this.resolution = resolution;
        this.completeFileNameSource = completeFileNameSource;
        this.annotationFile = annotationFile;
        this.annotationFile2 = annotationFile2;
        this.SNP1 = SNP1;
        this.SNP2 = SNP2;
        this.SNP1A = SNP1A;
        this.SNP2A = SNP2A;
        this.estimatorColumn = estimatorColumn;
        this.MAFColumn = MAFColumn;
        this.MAFColumn2 = MAFColumn2;
        this.hasHeading = hasHeading;
        this.MAF = MAF;
        this.maxDistance = maxDistance;
        this.firstPosition = firstPosition;
        this.lastPosition = lastPosition;
        this.annotation = annotationFile != null && !annotationFile.equals("");
        this.annotation2 = annotationFile2 != null && !annotationFile2.equals("");
        this.argument = new String("");
        this.go();
    }

    public int getSize() {
        return this.totalPairs;
    }

    public Vector3f[] getPositions() {
        return this.positions;
    }

    public void go() {
        super.go();
        SwingWorker worker = new SwingWorker(){

            public Object construct() {
                ActualTask actualTask = new ActualTask();
                return actualTask.error;
            }

            public void finished() {
                ExtractMap.this.error = (Integer)this.get();
                ExtractMap.this.myJInternalFrame.getContentPane().setCursor(Cursor.getDefaultCursor());
                String title = ExtractMap.this.myJInternalFrame.getTitle();
                switch (ExtractMap.this.error) {
                    case 0: {
                        break;
                    }
                    case -1: {
                        JOptionPane.showMessageDialog(null, "Error: input file " + ExtractMap.this.completeFileNameSource + " has a wrong format");
                        break;
                    }
                    case -2: {
                        JOptionPane.showMessageDialog(null, "Input/output error");
                        break;
                    }
                    case -3: {
                        JOptionPane.showMessageDialog(null, "Error: not enough memory");
                        break;
                    }
                    case -4: {
                        JOptionPane.showMessageDialog(null, "Error: estimator value is not a number in the interval [0,1] at line" + ExtractMap.this.line + ", value is " + ExtractMap.this.argument);
                        break;
                    }
                    case -5: {
                        JOptionPane.showMessageDialog(null, "Error: Illegal Type1 or Type2 values at line " + ExtractMap.this.line + ". Legal values are \"[a]/[b]\", with [a] and [b] values in the set {A,C,G,T}");
                        break;
                    }
                    case -6: {
                        JOptionPane.showMessageDialog(null, "Error: no SNPs have been selected");
                        break;
                    }
                    case -7: {
                        JOptionPane.showMessageDialog(null, "Error: annotation file has a wrong format");
                        break;
                    }
                    case -8: {
                        JOptionPane.showMessageDialog(null, "Error: general exception in getSNPs");
                        break;
                    }
                    case -9: {
                        JOptionPane.showMessageDialog(null, "Error: general exception in ExtractMap::readFile");
                        break;
                    }
                    case -10: {
                        JOptionPane.showMessageDialog(null, "Error: ArrayIndexOutOfBounds in ExtractMap::readFile");
                        break;
                    }
                    case -11: {
                        JOptionPane.showMessageDialog(null, "Error: Not a number ExtractMap::getSNPs when reading line " + ExtractMap.this.line + " in annotation file , value is " + ExtractMap.this.argument);
                        break;
                    }
                    default: {
                        JOptionPane.showMessageDialog(null, "Unsupported error at line" + ExtractMap.this.line);
                    }
                }
                ExtractMap.this.myJInternalFrame.close();
                if (ExtractMap.this.error == 0) {
                    if (!ExtractMap.this.D3) {
                        ExtractMap.this.my2DJInternalFrame = new My2DJInternalFrame(ExtractMap.this.mainGUI, ExtractMap.this.myJInternalFrame.getTitle(), true, true, true, true, ExtractMap.this.im);
                        ExtractMap.this.im.show(ExtractMap.this.my2DJInternalFrame);
                        ExtractMap.this.my2DJInternalFrame.updateUI();
                    } else {
                        if (ExtractMap.this.trueMaxDistance < ExtractMap.this.maxDistance) {
                            ExtractMap.this.maxDistance = ExtractMap.this.trueMaxDistance;
                        }
                        ExtractMap.this.my3DJInternalFrame = new My3DJInternalFrame(ExtractMap.this.mainGUI, ExtractMap.this.myJInternalFrame.getTitle(), true, true, true, true, ExtractMap.this.positions, ExtractMap.this.resolution, ExtractMap.this.maxDistance, ExtractMap.this.colorArray, ExtractMap.this.SNPPositions);
                    }
                }
            }
        };
        worker.start();
    }

    class ActualTask {
        protected Integer error = new Integer(0);
        ArrayList firstSNPList = new ArrayList();
        ArrayList secondSNPList = new ArrayList();
        ArrayList estimationList = new ArrayList();
        ArrayList firstMajorList = new ArrayList();
        ArrayList firstMinorList = new ArrayList();
        ArrayList secondMajorList = new ArrayList();
        ArrayList secondMinorList = new ArrayList();
        TreeSet foundSNP = new TreeSet();

        ActualTask() {
            this.init();
            this.readFile();
            if (this.error == 0) {
                this.orderingSNPs();
            }
            if (this.error == 0 && ExtractMap.this.D3) {
                this.filtering3D();
            }
            if (ExtractMap.this.annotation) {
                this.getSNPs(false);
            }
            if (ExtractMap.this.annotation2) {
                this.getSNPs(true);
            }
            if (this.error == 0) {
                this.convertArrays();
            }
            if (this.error == 0 && !ExtractMap.this.D3) {
                this.create2DMap();
            }
        }

        public boolean isProb(float num) {
            return num >= 0.0f && num <= 1.0f;
        }

        int getAllele(String val, boolean major) throws DataFormatException {
            int pos = 2;
            if (major) {
                pos = 0;
            }
            if (val.charAt(pos) == 'A') {
                return 0;
            }
            if (val.charAt(pos) == 'C') {
                return 1;
            }
            if (val.charAt(pos) == 'G') {
                return 2;
            }
            if (val.charAt(pos) == 'T') {
                return 3;
            }
            throw new DataFormatException();
        }

        public void init() {
            ExtractMap.this.useMAF = false;
            if (ExtractMap.this.MAFColumn != -1 && ExtractMap.this.MAFColumn2 != -1 && ExtractMap.this.MAF > 0.0f) {
                ExtractMap.this.useMAF = true;
            }
            ExtractMap.this.firstSNPArray = new ArrayList();
            ExtractMap.this.secondSNPArray = new ArrayList();
            ExtractMap.this.estimationArray = new ArrayList();
            if (ExtractMap.this.alleles1 >= 0 && ExtractMap.this.alleles2 >= 0 && ExtractMap.this.D3) {
                ExtractMap.this.firstMajorArray = new ArrayList();
                ExtractMap.this.firstMinorArray = new ArrayList();
                ExtractMap.this.secondMajorArray = new ArrayList();
                ExtractMap.this.secondMinorArray = new ArrayList();
            } else {
                ExtractMap.this.firstMajorArray = null;
                ExtractMap.this.firstMinorArray = null;
                ExtractMap.this.secondMajorArray = null;
                ExtractMap.this.secondMinorArray = null;
            }
            if (ExtractMap.this.annotation || ExtractMap.this.annotation2) {
                ExtractMap.this.firstSNPAArray = new ArrayList();
                ExtractMap.this.secondSNPAArray = new ArrayList();
            } else {
                ExtractMap.this.firstSNPAArray = null;
                ExtractMap.this.secondSNPAArray = null;
            }
        }

        public void readFile() {
            ArrayList head = new ArrayList();
            ExtractMap.this.line = 0;
            try {
                int approxSize = 0;
                File file = new File(ExtractMap.this.completeFileNameSource);
                approxSize = Math.round(file.length());
                BufferedReader bufferedReader = new BufferedReader(new FileReader(ExtractMap.this.completeFileNameSource));
                TextLine textLine = new TextLine(bufferedReader, ",\t\n ");
                int res = 0;
                if (ExtractMap.this.hasHeading) {
                    res = textLine.readLine();
                }
                ExtractMap.this.iniBar(approxSize /= textLine.getLineSize(), "reading input file");
                int currentSize = 0;
                float est = 0.0f;
                float MAF1 = 0.0f;
                float MAF2 = 0.0f;
                ExtractMap.this.totalPairs = 0;
                int i = 0;
                int snp1a = 0;
                int snp2a = 0;
                String s = new String("");
                ExtractMap.this.rs = false;
                while (res == 0) {
                    if (i % 1000 == 0) {
                        ExtractMap.this.updateStatus(i);
                    }
                    head = textLine.getWordsInLine();
                    if (i == 0) {
                        currentSize = head.size();
                    } else if (head.size() != currentSize) {
                        throw new FileNotFoundException();
                    }
                    if (ExtractMap.this.annotation || ExtractMap.this.annotation2) {
                        s = (String)head.get(ExtractMap.this.SNP1A);
                        if (i == 0 && s.charAt(0) == 'r' && s.charAt(1) == 's') {
                            ExtractMap.this.rs = true;
                        }
                        if (ExtractMap.this.rs) {
                            s = s.substring(2);
                        }
                        snp1a = (int)Float.parseFloat(s);
                        s = (String)head.get(ExtractMap.this.SNP2A);
                        if (ExtractMap.this.rs) {
                            s = s.substring(2);
                        }
                        snp2a = (int)Float.parseFloat(s);
                    }
                    int snp1 = Integer.parseInt((String)head.get(ExtractMap.this.SNP1));
                    int snp2 = Integer.parseInt((String)head.get(ExtractMap.this.SNP2));
                    est = Float.parseFloat((String)head.get(ExtractMap.this.estimatorColumn));
                    if (ExtractMap.this.useMAF) {
                        MAF1 = Float.parseFloat((String)head.get(ExtractMap.this.MAFColumn));
                        MAF2 = Float.parseFloat((String)head.get(ExtractMap.this.MAFColumn2));
                    }
                    if (snp1 >= ExtractMap.this.firstPosition && snp1 <= ExtractMap.this.lastPosition && snp2 >= ExtractMap.this.firstPosition && snp2 <= ExtractMap.this.lastPosition && (long)Math.abs(snp1 - snp2) < ExtractMap.this.maxDistance && (!ExtractMap.this.useMAF || MAF1 < 1.0f - ExtractMap.this.MAF && MAF2 < 1.0f - ExtractMap.this.MAF)) {
                        if (ExtractMap.this.annotation || ExtractMap.this.annotation2) {
                            ExtractMap.this.firstSNPAArray.add(new Integer(snp1a));
                            ExtractMap.this.secondSNPAArray.add(new Integer(snp2a));
                        }
                        ExtractMap.this.firstSNPArray.add(new Integer(snp1));
                        ExtractMap.this.secondSNPArray.add(new Integer(snp2));
                        ExtractMap.this.estimationArray.add(new Float(est));
                        if (!this.isProb(est)) {
                            throw new IllegalArgumentException();
                        }
                        if (!(!ExtractMap.this.useMAF || this.isProb(MAF1) && this.isProb(MAF2))) {
                            throw new IllegalArgumentException();
                        }
                        if (ExtractMap.this.alleles1 >= 0 && ExtractMap.this.alleles2 >= 0 && ExtractMap.this.D3) {
                            ExtractMap.this.firstMajorArray.add(new Integer(this.getAllele((String)head.get(ExtractMap.this.alleles1), true)));
                            ExtractMap.this.firstMinorArray.add(new Integer(this.getAllele((String)head.get(ExtractMap.this.alleles1), false)));
                            ExtractMap.this.secondMajorArray.add(new Integer(this.getAllele((String)head.get(ExtractMap.this.alleles2), true)));
                            ExtractMap.this.secondMinorArray.add(new Integer(this.getAllele((String)head.get(ExtractMap.this.alleles2), false)));
                        }
                        ++ExtractMap.this.totalPairs;
                    }
                    ++i;
                    head.clear();
                    head = null;
                    ++ExtractMap.this.line;
                    res = textLine.readLine();
                }
            }
            catch (FileNotFoundException e) {
                this.error = new Integer(-1);
            }
            catch (IOException e) {
                this.error = new Integer(-2);
            }
            catch (OutOfMemoryError e) {
                this.error = new Integer(-3);
            }
            catch (IllegalArgumentException e) {
                this.error = new Integer(-4);
                ExtractMap.this.argument = ExtractMap.this.argument + "\"" + head.get(ExtractMap.this.estimatorColumn) + "\"";
            }
            catch (DataFormatException e) {
                this.error = new Integer(-5);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.error = new Integer(-10);
            }
            catch (Exception e) {
                this.error = new Integer(-9);
            }
        }

        void orderingSNPs() {
            try {
                ExtractMap.this.iniBar(ExtractMap.this.totalPairs, "ordering SNPs");
                for (int i = 0; i < ExtractMap.this.totalPairs; ++i) {
                    if (i % 1000 == 0) {
                        ExtractMap.this.updateStatus(i);
                    }
                    this.foundSNP.add(new Integer((Integer)ExtractMap.this.firstSNPArray.get(i)));
                    this.foundSNP.add(new Integer((Integer)ExtractMap.this.secondSNPArray.get(i)));
                }
                ExtractMap.this.totalSNPs = this.foundSNP.size();
                if (ExtractMap.this.totalSNPs == 0) {
                    this.error = new Integer(-6);
                }
            }
            catch (OutOfMemoryError e) {
                this.error = new Integer(-3);
            }
        }

        void filtering3D() {
            try {
                int filter = 50;
                int lastSNP = Integer.MAX_VALUE;
                if (filter > ExtractMap.this.totalSNPs) {
                    filter = ExtractMap.this.totalSNPs;
                }
                ExtractMap.this.iniBar(ExtractMap.this.totalSNPs - filter, "filtering SNPs for 3D");
                for (int i = filter; i < ExtractMap.this.totalSNPs; ++i) {
                    if (i % 100 == 0) {
                        ExtractMap.this.updateStatus(i);
                    }
                    this.foundSNP.remove(this.foundSNP.last());
                }
                ExtractMap.this.totalSNPs = this.foundSNP.size();
                lastSNP = (Integer)this.foundSNP.last();
                if (ExtractMap.this.totalSNPs == 0) {
                    this.error = new Integer(-6);
                }
                ExtractMap.this.iniBar(ExtractMap.this.totalPairs, "filtering pairs for 3D");
                boolean c = false;
                for (int i = ExtractMap.this.totalPairs - 1; i >= 0; --i) {
                    if (i % 1000 == 0) {
                        ExtractMap.this.updateStatus(ExtractMap.this.totalPairs - i);
                    }
                    if ((Integer)ExtractMap.this.firstSNPArray.get(i) <= lastSNP && (Integer)ExtractMap.this.secondSNPArray.get(i) <= lastSNP) continue;
                    ExtractMap.this.firstSNPArray.remove(i);
                    ExtractMap.this.secondSNPArray.remove(i);
                    ExtractMap.this.estimationArray.remove(i);
                    if (ExtractMap.this.annotation || ExtractMap.this.annotation2) {
                        ExtractMap.this.firstSNPAArray.remove(i);
                        ExtractMap.this.secondSNPAArray.remove(i);
                    }
                    if (ExtractMap.this.alleles1 < 0 || ExtractMap.this.alleles2 < 0) continue;
                    ExtractMap.this.firstMajorArray.remove(i);
                    ExtractMap.this.firstMinorArray.remove(i);
                    ExtractMap.this.secondMajorArray.remove(i);
                    ExtractMap.this.secondMinorArray.remove(i);
                }
                ExtractMap.this.totalPairs = ExtractMap.this.firstSNPArray.size();
            }
            catch (OutOfMemoryError e) {
                this.error = new Integer(-3);
            }
        }

        public void convertArrays() {
            try {
                int i;
                HashMap hashSNPPos = new HashMap();
                Iterator it = this.foundSNP.iterator();
                ExtractMap.this.SNPPositions = new int[ExtractMap.this.totalSNPs];
                ExtractMap.this.iniBar(ExtractMap.this.totalSNPs, "computing coordinates");
                for (int i2 = 0; i2 < ExtractMap.this.totalSNPs; ++i2) {
                    Object v = it.next();
                    hashSNPPos.put(v, new Integer(i2));
                    if (i2 % 1000 == 0) {
                        ExtractMap.this.updateStatus(i2);
                    }
                    ExtractMap.this.SNPPositions[i2] = (Integer)v;
                }
                ExtractMap.this.trueMaxDistance = 0L;
                ExtractMap.this.distance2D = 0;
                ExtractMap.this.positions = new Vector3f[ExtractMap.this.totalPairs];
                ExtractMap.this.iniBar(ExtractMap.this.totalPairs, "reformating");
                ExtractMap.this.colorArray = ExtractMap.this.alleles1 >= 0 && ExtractMap.this.alleles2 >= 0 && ExtractMap.this.D3 ? new Color3f[ExtractMap.this.totalPairs] : null;
                for (i = 0; i < ExtractMap.this.totalPairs; ++i) {
                    Integer in = new Integer((Integer)ExtractMap.this.firstSNPArray.get(i));
                    float x = ((Integer)hashSNPPos.get(in)).intValue();
                    in = new Integer((Integer)ExtractMap.this.secondSNPArray.get(i));
                    float y = ((Integer)hashSNPPos.get(in)).intValue();
                    float z = ((Float)ExtractMap.this.estimationArray.get(i)).floatValue();
                    ExtractMap.this.positions[i] = new Vector3f(x, y, z);
                    if ((float)ExtractMap.this.distance2D < y - x) {
                        ExtractMap.this.distance2D = (int)y - (int)x;
                    }
                    if (ExtractMap.this.trueMaxDistance < (long)(ExtractMap.this.SNPPositions[(int)y] - ExtractMap.this.SNPPositions[(int)x] + 1)) {
                        ExtractMap.this.trueMaxDistance = ExtractMap.this.SNPPositions[(int)y] - ExtractMap.this.SNPPositions[(int)x] + 1;
                    }
                    if (ExtractMap.this.alleles1 >= 0 && ExtractMap.this.alleles2 >= 0 && ExtractMap.this.D3) {
                        ExtractMap.this.colorArray[i] = this.setColor(this.getPosColor((Integer)ExtractMap.this.firstMajorArray.get(i), (Integer)ExtractMap.this.firstMinorArray.get(i)), this.getPosColor((Integer)ExtractMap.this.secondMajorArray.get(i), (Integer)ExtractMap.this.secondMinorArray.get(i)));
                    }
                    if (i % 1000 != 0) continue;
                    ExtractMap.this.updateStatus(ExtractMap.this.totalPairs + i);
                }
                if (ExtractMap.this.annotation || ExtractMap.this.annotation2) {
                    ExtractMap.this.iniBar(ExtractMap.this.totalSNPs, "indexing markers for annotation");
                    if (ExtractMap.this.annotation) {
                        ExtractMap.this.iniBar(ExtractMap.this.totalSNPs, "processing selected SNPs");
                        ExtractMap.this.selected = new boolean[ExtractMap.this.totalSNPs];
                        for (i = 0; i < ExtractMap.this.totalSNPs; ++i) {
                            ExtractMap.this.selected[i] = false;
                        }
                        int totalSelected = ExtractMap.this.selectedSNPs.size();
                        ExtractMap.this.existSelected = 0;
                        ExtractMap.this.existMarked = 0;
                        for (int i3 = 0; i3 < totalSelected; ++i3) {
                            if (i3 % 1000 == 0) {
                                ExtractMap.this.updateStatus(i3);
                            }
                            if (hashSNPPos.get(ExtractMap.this.selectedSNPs.get(i3)) == null) continue;
                            ExtractMap.this.selected[((Integer)hashSNPPos.get(ExtractMap.this.selectedSNPs.get((int)i3))).intValue()] = true;
                            ++ExtractMap.this.existSelected;
                        }
                        ExtractMap.this.selectedSNPs.clear();
                        ExtractMap.this.selectedSNPs = null;
                    }
                    if (ExtractMap.this.annotation2) {
                        ExtractMap.this.iniBar(ExtractMap.this.totalSNPs, "processing marked SNPs");
                        ExtractMap.this.marked = new boolean[ExtractMap.this.totalSNPs];
                        for (i = 0; i < ExtractMap.this.totalSNPs; ++i) {
                            ExtractMap.this.marked[i] = false;
                        }
                        int totalMarked = ExtractMap.this.markedSNPs.size();
                        for (int i4 = 0; i4 < totalMarked; ++i4) {
                            if (i4 % 1000 == 0) {
                                ExtractMap.this.updateStatus(i4);
                            }
                            if (hashSNPPos.get(ExtractMap.this.markedSNPs.get(i4)) == null) continue;
                            ++ExtractMap.this.existMarked;
                            ExtractMap.this.marked[((Integer)hashSNPPos.get(ExtractMap.this.markedSNPs.get((int)i4))).intValue()] = true;
                            if (!ExtractMap.this.selected[(Integer)hashSNPPos.get(ExtractMap.this.markedSNPs.get(i4))]) continue;
                            ++ExtractMap.this.inCommon;
                        }
                        ExtractMap.this.markedSNPs.clear();
                        ExtractMap.this.markedSNPs = null;
                    }
                }
                hashSNPPos.clear();
                hashSNPPos = null;
                this.foundSNP.clear();
                this.foundSNP = null;
                ExtractMap.this.firstSNPArray.clear();
                ExtractMap.this.secondSNPArray.clear();
                ExtractMap.this.estimationArray.clear();
                ExtractMap.this.firstSNPArray = null;
                ExtractMap.this.secondSNPArray = null;
                ExtractMap.this.estimationArray = null;
                if (ExtractMap.this.alleles1 >= 0 && ExtractMap.this.alleles2 >= 0 && ExtractMap.this.D3) {
                    ExtractMap.this.firstMajorArray.clear();
                    ExtractMap.this.firstMinorArray.clear();
                    ExtractMap.this.secondMajorArray.clear();
                    ExtractMap.this.secondMinorArray.clear();
                    ExtractMap.this.firstMajorArray = null;
                    ExtractMap.this.firstMinorArray = null;
                    ExtractMap.this.secondMajorArray = null;
                    ExtractMap.this.secondMinorArray = null;
                }
            }
            catch (OutOfMemoryError e) {
                this.error = new Integer(-3);
            }
            System.gc();
        }

        public void getSNPs(boolean isMarked) {
            ExtractMap.this.line = 0;
            ArrayList head = null;
            String s1 = new String("");
            if (isMarked) {
                ExtractMap.this.markedSNPs = new ArrayList();
            } else {
                ExtractMap.this.selectedSNPs = new ArrayList();
            }
            try {
                File file = isMarked ? new File(ExtractMap.this.annotationFile2) : new File(ExtractMap.this.annotationFile2);
                int approxSize = Math.round(file.length());
                BufferedReader bufferedReader = isMarked ? new BufferedReader(new FileReader(ExtractMap.this.annotationFile2)) : new BufferedReader(new FileReader(ExtractMap.this.annotationFile));
                TextLine textLine = new TextLine(bufferedReader, ",\t ");
                approxSize /= textLine.getLineSize();
                if (isMarked) {
                    ExtractMap.this.iniBar(approxSize, "reading annotation file 2");
                } else {
                    ExtractMap.this.iniBar(approxSize, "reading annotation file");
                }
                int c = 0;
                do {
                    if (c % 100 == 0) {
                        ExtractMap.this.updateStatus(c);
                    }
                    head = textLine.getWordsInLine();
                    s1 = (String)head.get(0);
                    if (ExtractMap.this.rs) {
                        s1 = s1.substring(2);
                    }
                    if (isMarked) {
                        ExtractMap.this.markedSNPs.add(Integer.valueOf(s1));
                    } else {
                        ExtractMap.this.selectedSNPs.add(Integer.valueOf(s1));
                    }
                    ++c;
                    ++ExtractMap.this.line;
                } while (textLine.readLine() == 0);
            }
            catch (FileNotFoundException e) {
                this.error = new Integer(-7);
            }
            catch (IOException e) {
                this.error = new Integer(-2);
            }
            catch (OutOfMemoryError e) {
                this.error = new Integer(-3);
            }
            catch (NumberFormatException e) {
                this.error = new Integer(-11);
                ExtractMap.this.argument = "\"" + s1 + "\"";
            }
        }

        Color3f setColor(int val1, int val2) {
            return ExtractMap.this.colorCode[val1][val2];
        }

        int getPosColor(int a1, int a2) {
            return a1 * 4 + a2;
        }

        public void create2DMap() {
            try {
                int width = 1;
                if (ExtractMap.this.resolution > 1 && (width = (int)Math.round(Math.sqrt(ExtractMap.this.resolution * ExtractMap.this.resolution * 2))) % 2 != 0) {
                    ++width;
                }
                int horizontalSize = ExtractMap.this.totalSNPs * width;
                int verticalSize = ExtractMap.this.distance2D * width;
                ExtractMap.this.im = new Image();
                int[] xvals = new int[4];
                int[] yvals = new int[4];
                int vertDesp = 20;
                int head = 80;
                int horDesp = 20;
                ExtractMap.this.im.image = new BufferedImage(horizontalSize + horDesp * 2, verticalSize + vertDesp + head, 1);
                Graphics2D g2d = ExtractMap.this.im.image.createGraphics();
                g2d.setColor(ExtractMap.this.jInternalFrame.getBackground());
                g2d.fillRect(0, 0, horizontalSize + horDesp * 2, verticalSize + vertDesp + head);
                g2d.setFont(g2d.getFont().deriveFont(12.0f - (float)(20 / (ExtractMap.this.resolution + 3))));
                String st = new String();
                ExtractMap.this.iniBar(ExtractMap.this.totalPairs, "loading map");
                for (int c = 0; c < ExtractMap.this.totalPairs; ++c) {
                    if (c % 1000 == 0) {
                        ExtractMap.this.updateStatus(c);
                    }
                    int SNP = (int)ExtractMap.this.positions[c].x;
                    int SNP2 = (int)ExtractMap.this.positions[c].y;
                    int distance = SNP2 - SNP;
                    int leftx = SNP * width + horDesp;
                    int lefty = head + vertDesp / 2;
                    if (!ExtractMap.this.annotation && !ExtractMap.this.annotation2 && SNP % (20 / ExtractMap.this.resolution) == 0 || ExtractMap.this.annotation2 && ExtractMap.this.marked[SNP] || ExtractMap.this.annotation && ExtractMap.this.selected[SNP]) {
                        g2d.setColor(Color.black);
                        if (ExtractMap.this.annotation2 && ExtractMap.this.marked[SNP]) {
                            if (ExtractMap.this.annotation && !ExtractMap.this.selected[SNP]) {
                                g2d.setColor(Color.red);
                            } else {
                                g2d.setColor(Color.green);
                            }
                        }
                        st = ExtractMap.this.rs ? "rs" + ExtractMap.this.SNPPositions[SNP] : "" + ExtractMap.this.SNPPositions[SNP];
                        g2d.translate(horDesp, head + vertDesp / 2);
                        g2d.rotate(5.497787143782138);
                        int yRot = (int)Math.ceil((double)(SNP * width) * Math.sin(0.7853981633974483));
                        int xRot = (int)Math.ceil((double)(SNP * width) * Math.cos(0.7853981633974483));
                        g2d.drawString("" + st, xRot, yRot);
                        g2d.rotate(0.7853981633974483);
                        g2d.translate(-horDesp, -head - vertDesp / 2);
                        g2d.drawLine(leftx, lefty, leftx, lefty + vertDesp / 2 + width / 2);
                    }
                    int scale = Math.round((float)Math.ceil(ExtractMap.this.positions[c].z * 10.0f));
                    int R = ExtractMap.this.im.GetColorLevel(scale);
                    int G = ExtractMap.this.im.GetColorLevel(scale);
                    int B = ExtractMap.this.im.GetColorLevel(scale);
                    Color cfr_ignored_0 = ExtractMap.this.color;
                    if (ExtractMap.this.color == Color.red) {
                        R = 255;
                    }
                    Color cfr_ignored_1 = ExtractMap.this.color;
                    if (ExtractMap.this.color == Color.green) {
                        G = 255;
                    }
                    Color cfr_ignored_2 = ExtractMap.this.color;
                    if (ExtractMap.this.color == Color.blue) {
                        B = 255;
                    }
                    g2d.setColor(new Color(R, G, B));
                    leftx = SNP * width + distance * width / 2 - width / 2 + horDesp;
                    lefty = distance * width / 2 + head + vertDesp;
                    if (width > 1) {
                        xvals[0] = leftx;
                        xvals[1] = leftx + width / 2;
                        xvals[2] = leftx + width;
                        xvals[3] = leftx + width / 2;
                        yvals[0] = lefty;
                        yvals[1] = lefty - width / 2;
                        yvals[2] = lefty;
                        yvals[3] = lefty + width / 2;
                        g2d.fillPolygon(xvals, yvals, 4);
                        continue;
                    }
                    g2d.drawLine(leftx, lefty, leftx, lefty);
                }
                if (ExtractMap.this.annotation) {
                    JOptionPane.showMessageDialog(null, "" + (ExtractMap.this.existSelected - ExtractMap.this.inCommon) + " SNPs in file " + ExtractMap.this.annotationFile + " have been marked in black.");
                }
                if (ExtractMap.this.annotation2) {
                    JOptionPane.showMessageDialog(null, "" + (ExtractMap.this.existMarked - ExtractMap.this.inCommon) + " SNPs in file " + ExtractMap.this.annotationFile2 + " have been marked in red.");
                }
                if (ExtractMap.this.annotation2 && ExtractMap.this.annotation) {
                    JOptionPane.showMessageDialog(null, "" + ExtractMap.this.inCommon + " SNPs in common in files " + ExtractMap.this.annotationFile + " and " + ExtractMap.this.annotationFile2 + " have been marked in green.");
                }
            }
            catch (OutOfMemoryError e) {
                this.error = new Integer(-3);
            }
        }
    }
}

