/*
 * Decompiled with CFR 0.152.
 */
package BMap2D;

import BMap2D.Image;
import BMap2D.My2DJInternalFrame;
import GUI.MainGUI;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.swing.JOptionPane;
import javax.vecmath.Vector3f;
import threads.GUILongTask;
import threads.SwingWorker;

public class Build2D
extends GUILongTask {
    My2DJInternalFrame jInternalFrame;
    int totalPairs;
    int resolution;
    int totalSNPs;
    int maxSNPDistance;
    int[] SNPPositions;
    Vector3f[] positions;
    Color color;
    Image im;
    MainGUI mainGUI;

    public Build2D(MainGUI mainGUI, My2DJInternalFrame jInternalFrame, Vector3f[] positions, int resolution, Color color, int maxSNPDistance, int[] SNPPositions) {
        super(jInternalFrame);
        this.mainGUI = mainGUI;
        this.jInternalFrame = jInternalFrame;
        this.totalPairs = positions.length;
        this.totalSNPs = SNPPositions.length;
        this.resolution = resolution;
        this.jInternalFrame = jInternalFrame;
        this.positions = positions;
        this.color = color;
        this.maxSNPDistance = maxSNPDistance;
        this.SNPPositions = SNPPositions;
        this.go();
    }

    public void go() {
        SwingWorker worker = new SwingWorker(){
            int error;

            public Object construct() {
                ActualTask actualTask = new ActualTask();
                return actualTask.error;
            }

            public void finished() {
                this.error = (Integer)this.get();
                if (this.error != 0) {
                    if (this.error == 3) {
                        JOptionPane.showMessageDialog(null, "Error: not enough memory");
                    } else if (this.error != 0) {
                        JOptionPane.showMessageDialog(null, "Error: map could not be generated");
                    }
                    Build2D.this.jInternalFrame.getContentPane().setCursor(Cursor.getDefaultCursor());
                }
                if (this.error == 0) {
                    Build2D.this.jInternalFrame.setImage(Build2D.this.im);
                    Build2D.this.mainGUI.updateMainFrame();
                    Build2D.this.jInternalFrame.getContentPane().setCursor(Cursor.getDefaultCursor());
                }
            }
        };
        worker.start();
    }

    class ActualTask {
        protected Integer error = new Integer(0);

        ActualTask() {
            this.createMap();
        }

        void createMap() {
            int width = 1;
            if (Build2D.this.resolution > 1) {
                width = (int)Math.sqrt(Build2D.this.resolution * Build2D.this.resolution * 2);
            }
            int horizontalSize = Build2D.this.totalSNPs * width;
            int verticalSize = Build2D.this.maxSNPDistance * width;
            Build2D.this.im = new Image();
            int[] xvals = new int[4];
            int[] yvals = new int[4];
            int desp = 20;
            Build2D.this.im.image = new BufferedImage(horizontalSize, verticalSize + desp, 1);
            Graphics2D g2d = Build2D.this.im.image.createGraphics();
            g2d.setColor(Build2D.this.jInternalFrame.getBackground());
            g2d.fillRect(0, 0, horizontalSize, verticalSize + desp);
            g2d.setFont(g2d.getFont().deriveFont(8.0f));
            String st = new String();
            Build2D.this.iniBar(Build2D.this.totalPairs, "Loading map");
            for (int c = 0; c < Build2D.this.totalPairs; ++c) {
                int SNP;
                int SNP2;
                int distance;
                if (c % 1000 == 0) {
                    Build2D.this.updateStatus(c);
                }
                if ((distance = (SNP2 = (int)Build2D.this.positions[c].y) - (SNP = (int)Build2D.this.positions[c].x)) == 1) {
                    st = "" + Build2D.this.SNPPositions[SNP];
                }
                if ((SNP + 1) % verticalSize == 0 && horizontalSize / width - SNP > verticalSize / width) {
                    g2d.setColor(Color.black);
                    g2d.drawString("" + st, SNP * width - Math.round(0.0f * (float)st.length() / 2.0f), desp / 2);
                    g2d.drawLine(SNP * width, desp * 3 / 4 - 1, SNP * width, desp - 1);
                }
                int scale = Math.round((float)Math.ceil(Build2D.this.positions[c].z * 10.0f));
                int R = Build2D.this.im.GetColorLevel(scale);
                int G = Build2D.this.im.GetColorLevel(scale);
                int B = Build2D.this.im.GetColorLevel(scale);
                Color cfr_ignored_0 = Build2D.this.color;
                if (Build2D.this.color == Color.red) {
                    R = 255;
                }
                Color cfr_ignored_1 = Build2D.this.color;
                if (Build2D.this.color == Color.green) {
                    G = 255;
                }
                Color cfr_ignored_2 = Build2D.this.color;
                if (Build2D.this.color == Color.blue) {
                    B = 255;
                }
                g2d.setColor(new Color(R, G, B));
                int leftx = SNP * width + distance * width / 2 - width / 2;
                int lefty = distance * width / 2 + desp;
                if (width > 1) {
                    xvals[0] = leftx;
                    xvals[1] = leftx + width / 2;
                    xvals[2] = leftx + width;
                    xvals[3] = leftx + width / 2;
                    yvals[0] = lefty;
                    yvals[1] = lefty - width / 2;
                    yvals[2] = lefty;
                    yvals[3] = lefty + width / 2;
                    g2d.fillPolygon(xvals, yvals, 4);
                    continue;
                }
                g2d.drawLine(leftx, lefty, leftx, lefty);
            }
            Build2D.this.im.show(Build2D.this.jInternalFrame);
        }
    }
}

