/*
 * Decompiled with CFR 0.152.
 */
package BMap3D;

import BMap3D.universe.UserData;
import java.awt.Font;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Font3D;
import javax.media.j3d.FontExtrusion;
import javax.media.j3d.Geometry;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Text3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Color3f;
import javax.vecmath.Vector3f;

public class Labels3D
extends BranchGroup {
    Font3D textAspect;
    private TransformGroup globalRotation;
    private BranchGroup grid;

    Labels3D() {
        Font font = new Font("Arial", 0, 1);
        FontExtrusion fe = new FontExtrusion();
        this.textAspect = new Font3D(font, fe);
        this.grid = new BranchGroup();
        for (float z = 0.0f; z < 1.0f; z += 0.1f) {
            String t = "a" + z;
            this.createTextOnGrid(t, -1.2f, 2.2f, z * 10.0f);
        }
    }

    Labels3D(int[] values) {
        float delta = (float)values.length / 100.0f;
        this.grid = new BranchGroup();
        Font font = new Font("Arial", 0, 1);
        FontExtrusion fe = new FontExtrusion();
        this.textAspect = new Font3D(font, fe);
        for (float d = 0.0f; d < (float)values.length; d += delta) {
            int i = (int)d;
            String txt = new Float(values[i]).toString();
            this.createTextOnGrid(txt, d + 1.0f, 10.0f, d);
        }
    }

    void createTextOnGrid(String s, float x, float y, float z) {
        BranchGroup element = new BranchGroup();
        Text3D text = new Text3D(this.textAspect, s);
        TransformGroup alignOnGrid = new TransformGroup();
        Transform3D t = new Transform3D();
        t.setTranslation(new Vector3f(x, y, z));
        Appearance sameApp = new Appearance();
        Material sameMat = new Material();
        sameMat.setAmbientColor(0.6f, 0.6f, 0.6f);
        sameMat.setDiffuseColor(this.randomColor());
        sameMat.setSpecularColor(0.0f, 0.0f, 0.0f);
        sameMat.setLightingEnable(true);
        sameApp.setMaterial(sameMat);
        Shape3D sh = new Shape3D();
        sh.setGeometry((Geometry)text);
        sh.setAppearance(sameApp);
        UserData ud = new UserData("Label3D", 1.0f);
        sh.setUserData((Object)ud);
        alignOnGrid.addChild((Node)sh);
        element.addChild((Node)alignOnGrid);
        this.grid.addChild((Node)element);
    }

    private void twist() {
        this.globalRotation = new TransformGroup();
        Transform3D t = new Transform3D();
        t.setRotation(new AxisAngle4f(0.0f, 1.0f, 0.0f, 2.3561945f));
        this.globalRotation.setTransform(t);
        this.globalRotation.addChild((Node)this.grid);
        this.addChild((Node)this.globalRotation);
    }

    public Color3f randomColor() {
        float mr = (float)(0.9 + 0.2 * Math.random());
        float mg = (float)(0.8 + 0.1 * Math.random());
        float mb = (float)(0.8 + 0.2 * Math.random());
        return new Color3f(mr, mg, mb);
    }
}

