/*
 * Decompiled with CFR 0.152.
 */
package BMap3D;

import GUI.SpringUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.vecmath.Color3f;

public class Panel3D
extends JPanel {
    private static final long serialVersionUID = -2690516768173087721L;
    JColorChooser cColor;
    JLabel lColor;
    JLabel lResolution;
    JButton[][] tColor;
    JPanel palette;
    Color3f[][] colorCode;
    Color c;
    int resolution;
    int x;
    int y;

    public Panel3D(Color3f[][] colorCode) {
        this.setColorCode(colorCode);
        this.printPanel();
    }

    public Panel3D(Panel3D p3) {
        this.setColorCode(p3.getColorCode());
        this.printPanel();
    }

    public Panel3D() {
        this.colorCode = new Color3f[16][16];
        int[] a = new int[4];
        int c = 0;
        for (int i = 0; i < 16; ++i) {
            String s = this.printAlleles(i);
            if (s.charAt(0) != s.charAt(1)) continue;
            a[c] = i;
            ++c;
        }
        this.setSize(1000, 1000);
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                this.colorCode[i][j] = new Color3f(Color.black);
                this.colorCode[i][j] = i == a[0] || i == a[1] || i == a[2] || i == a[3] || j == a[0] || j == a[1] || j == a[2] || j == a[3] ? new Color3f(Color.white) : new Color3f(Color.orange);
            }
        }
        this.printPanel();
    }

    protected void printPanel() {
        this.setLayout(new BorderLayout());
        this.cColor = new JColorChooser(Color.red);
        this.cColor.getSelectionModel().addChangeListener(new changeListener());
        this.palette = new JPanel();
        this.palette.setLayout(new SpringLayout());
        int rows = 17;
        int cols = 17;
        Font DEFAULT_FONT = new Font("Arial", 0, 10);
        this.tColor = new JButton[17][17];
        for (int i = 0; i < 17; ++i) {
            for (int j = 0; j < 17; ++j) {
                if (i == 0 || j == 0) {
                    if (i == 0 && j == 0) {
                        this.tColor[i][j] = new JButton("");
                    } else {
                        this.tColor[i][j] = new JButton(this.printAlleles(i + j - 1));
                        this.tColor[i][j].setFont(DEFAULT_FONT);
                    }
                } else {
                    this.tColor[i][j] = new JButton("");
                    this.tColor[i][j].setBackground(this.colorCode[i - 1][j - 1].get());
                }
                this.palette.add(this.tColor[i][j]);
                this.tColor[i][j].setBorder(new LineBorder(Color.gray));
                this.tColor[i][j].addActionListener(new PaletteActionListener());
            }
        }
        SpringUtilities.makeCompactGrid(this.palette, rows, cols, 0, 0, 0, 0);
        JPanel a = new JPanel(new FlowLayout());
        JPanel left = new JPanel();
        JPanel right = new JPanel();
        a.add(left);
        a.add(this.palette);
        a.add(right);
        JPanel text = new JPanel(new BorderLayout());
        this.lColor = new JLabel("  Choose a color for each combination of alleles:");
        JLabel helpColor = new JLabel("  Selecting on headings will change whole columns, rows or table");
        text.add((Component)this.lColor, "North");
        text.add((Component)helpColor, "South");
        this.cColor.setPreviewPanel(new JPanel());
        this.add((Component)a, "Center");
        this.add((Component)text, "North");
        this.add((Component)this.cColor, "Last");
    }

    public Color3f[][] getColorCode() {
        return this.colorCode;
    }

    public void setColorCode(Color3f[][] colorCodeSource) {
        this.colorCode = new Color3f[16][16];
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                this.colorCode[i][j] = colorCodeSource[i][j];
            }
        }
    }

    String printAlleles(int pos) {
        String s = new String();
        s = s + this.getAllele(pos / 4);
        s = s + this.getAllele(pos % 4);
        return s;
    }

    char getAllele(int a) {
        switch (a) {
            case 0: {
                return 'A';
            }
            case 1: {
                return 'C';
            }
            case 2: {
                return 'G';
            }
            case 3: {
                return 'T';
            }
        }
        return '-';
    }

    class PaletteActionListener
    implements ActionListener {
        PaletteActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            JButton jB = (JButton)e.getSource();
            Panel3D.this.x = 0;
            Panel3D.this.y = 0;
            for (int i = 0; i < 17; ++i) {
                for (int j = 0; j < 17; ++j) {
                    if (jB == Panel3D.this.tColor[i][j]) {
                        Panel3D.this.x = i;
                        Panel3D.this.y = j;
                        Panel3D.this.tColor[i][j].setBorder(new LineBorder(Color.black, 3));
                        continue;
                    }
                    Panel3D.this.tColor[i][j].setBorder(new LineBorder(Color.gray, 1));
                }
            }
        }
    }

    class changeListener
    implements ChangeListener {
        changeListener() {
        }

        public void stateChanged(ChangeEvent e) {
            Color newColor = Panel3D.this.cColor.getColor();
            for (int i = 0; i < 16; ++i) {
                for (int j = 0; j < 16; ++j) {
                    if (Panel3D.this.x != 0 && Panel3D.this.x != i + 1 || Panel3D.this.y != 0 && Panel3D.this.y != j + 1) continue;
                    Panel3D.this.colorCode[i][j] = new Color3f(newColor);
                    Panel3D.this.tColor[i + 1][j + 1].setBackground(newColor);
                }
            }
        }
    }
}

