/*
 * Decompiled with CFR 0.152.
 */
package BMap3D;

import BMap3D.Blocks3D;
import BMap3D.Labels3D;
import BMap3D.My3DJInternalFrame;
import BMap3D.geometry.AnnotationAxes;
import BMap3D.universe.CapturingCanvas3D;
import BMap3D.universe.ChangePolygonAttributes;
import BMap3D.universe.ChangeTransparencyAttributes;
import BMap3D.universe.DevelopmentSimpleUniverse;
import BMap3D.universe.ExamineViewerBehavior;
import com.sun.j3d.utils.universe.PlatformGeometry;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GraphicsConfiguration;
import javax.media.j3d.Background;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.Node;
import javax.media.j3d.PointLight;
import javax.media.j3d.Switch;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.View;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

public class Viewer3D
extends JPanel {
    public CapturingCanvas3D canvas;
    public My3DJInternalFrame interfaz;
    public Blocks3D blocks;
    public Labels3D sticsInfo;
    public AnnotationAxes axes;
    private DevelopmentSimpleUniverse u;
    private TransformGroup tgComportamientos;
    private ExamineViewerBehavior examineBehavior;
    private Switch optionalElementsInWorld;
    private JPanel panelViewer;
    private JPanel panelZoom;
    private static int showAllAxis = 0;
    private JSlider axeXViewer;
    private JSlider axeZViewer;
    private JLabel txtSup;
    private JLabel txtLat;
    private Color bgColor;
    private Color3f background;
    private BoundingSphere allBounds;
    private BoundingSphere worldBounds;
    private BoundingSphere minusBound = new BoundingSphere(new Point3d(0.0, 1.0, 0.0), 10.0);
    private BranchGroup bgRoot;
    private Point3d eyePos = new Point3d(0.0, 0.0, 1.0);
    private static final long serialVersionUID = 7028025856256452585L;
    public static final int AXE_X = 0;
    public static final int AXE_Y = 1;
    public static final int AXE_Z = 2;

    public Viewer3D(My3DJInternalFrame inter, Color _bgColor) {
        this.interfaz = inter;
        this.bgColor = _bgColor;
        this.background = new Color3f(this.bgColor);
        this.initTheInterface();
    }

    private void initTheInterface() {
        this.setLayout(new BorderLayout());
        this.panelViewer = new JPanel(new FlowLayout());
        this.panelViewer.setBackground(this.bgColor);
        this.axeXViewer = new JSlider(0, 100, 50);
        this.axeXViewer.setToolTipText("Move observer along X axis");
        this.axeXViewer.setBackground(this.bgColor);
        this.txtSup = new JLabel("Slide viewer");
        this.axeXViewer.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                Viewer3D.this.slideObserver(((JSlider)e.getSource()).getValue());
            }
        });
        this.panelViewer.add(this.txtSup);
        this.panelViewer.add(this.axeXViewer);
        this.add((Component)this.panelViewer, "North");
        GraphicsConfiguration config = DevelopmentSimpleUniverse.getPreferredConfiguration();
        this.canvas = new CapturingCanvas3D(config);
        this.add((Component)((Object)this.canvas), "Center");
        this.panelZoom = new JPanel(new BorderLayout());
        this.panelZoom.setBackground(this.bgColor);
        this.axeZViewer = new JSlider(0, 100, 0);
        this.axeZViewer.setOrientation(1);
        this.axeZViewer.setToolTipText("Move observer along Z axis");
        this.axeZViewer.setBackground(this.bgColor);
        this.txtLat = new JLabel("Zoom");
        this.axeZViewer.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                Viewer3D.this.zoomIntoScene(((JSlider)e.getSource()).getValue());
            }
        });
        this.panelZoom.add((Component)this.axeZViewer, "Center");
        this.panelZoom.add((Component)this.txtLat, "South");
        this.panelZoom.add((Component)this.txtLat, "South");
        this.add((Component)this.panelZoom, "East");
    }

    private void init() {
        this.u = new DevelopmentSimpleUniverse(this.canvas);
        this.bgRoot = new BranchGroup();
        this.bgRoot.setCapability(17);
        this.bgRoot.setCapability(12);
        this.bgRoot.setCapability(13);
        this.bgRoot.setCapability(3);
        this.tgComportamientos = new TransformGroup();
        this.tgComportamientos.setCapability(17);
        this.tgComportamientos.setCapability(18);
        this.tgComportamientos.setCapability(14);
        this.tgComportamientos.setCapability(12);
        this.allBounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 1.0E7);
        this.examineBehavior = new ExamineViewerBehavior(this.tgComportamientos, this);
        this.examineBehavior.setSchedulingBounds((Bounds)this.allBounds);
        this.bgRoot.addChild((Node)this.examineBehavior);
        this.examineBehavior.setEnable(true);
        this.bgRoot.addChild((Node)this.tgComportamientos);
        this.optionalElementsInWorld = new Switch();
        this.optionalElementsInWorld.setCapability(17);
        this.optionalElementsInWorld.setCapability(12);
        this.optionalElementsInWorld.setCapability(13);
        this.optionalElementsInWorld.setCapability(18);
    }

    public void createWorld3D() {
        this.init();
        this.blocks = new Blocks3D();
        this.tgComportamientos.addChild((Node)this.blocks);
        this.sticsInfo = new Labels3D();
        this.optionalElementsInWorld.addChild((Node)this.sticsInfo);
        this.tgComportamientos.addChild((Node)this.optionalElementsInWorld);
        this.visualize();
    }

    public void createWorld3D(Vector3f[] array3f, int resolution, int maxDistance, Color3f[] colors, int[] position) {
        this.blocks = new Blocks3D(array3f, resolution, maxDistance, colors, position);
        this.init();
        this.tgComportamientos.addChild((Node)this.blocks);
        this.visualize();
    }

    private void visualize() {
        Point3d center = new Point3d();
        this.worldBounds = (BoundingSphere)this.bgRoot.getBounds();
        this.worldBounds.getCenter(center);
        float radius = (float)this.worldBounds.getRadius();
        DirectionalLight lightD1 = new DirectionalLight();
        lightD1.setInfluencingBounds((Bounds)new BoundingSphere(center, 1000.0));
        lightD1.setColor(new Color3f(0.3f, 0.3f, 0.3f));
        lightD1.setDirection(10.0f, 1.0f, 0.0f);
        DirectionalLight lightD3 = new DirectionalLight();
        lightD3.setInfluencingBounds((Bounds)new BoundingSphere(center, 1000.0));
        lightD3.setDirection(-10.0f, 1.0f, 0.0f);
        lightD3.setColor(new Color3f(0.3f, 0.3f, 0.3f));
        PointLight lightFront = new PointLight();
        lightFront.setInfluencingBounds((Bounds)new BoundingSphere(center, 1000.0));
        lightFront.setPosition((float)center.x, 0.0f, radius);
        lightFront.setColor(new Color3f(0.5f, 0.5f, 0.5f));
        PointLight lightUp = new PointLight();
        lightUp.setInfluencingBounds((Bounds)new BoundingSphere(center, 1000.0));
        lightUp.setPosition((float)center.x, radius, radius * 0.5f);
        lightUp.setColor(new Color3f(Color.white));
        PlatformGeometry pg = new PlatformGeometry();
        pg.addChild((Node)lightFront);
        pg.addChild((Node)lightUp);
        DirectionalLight headlight = new DirectionalLight();
        headlight.setColor(new Color3f(1.0f, 1.0f, 1.0f));
        headlight.setDirection(new Vector3f(0.0f, 0.0f, -1.0f));
        headlight.setInfluencingBounds((Bounds)this.allBounds);
        headlight.setCapability(13);
        this.u.getViewingPlatform().setPlatformGeometry(pg);
        this.worldBounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 1000000.0);
        DirectionalLight light = new DirectionalLight();
        light.setEnable(true);
        light.setColor(new Color3f(1.0f, 1.0f, 1.0f));
        light.setDirection(new Vector3f(0.5f, -1.0f, -0.5f));
        light.setInfluencingBounds((Bounds)this.worldBounds);
        Background bgNode = new Background(this.background);
        bgNode.setCapability(12);
        bgNode.setApplicationBounds((Bounds)this.worldBounds);
        this.bgRoot.addChild((Node)bgNode);
        this.axes = new AnnotationAxes();
        this.axes.setAxesColor(new Color3f(1.0f, 0.0f, 0.0f), new Color3f(0.0f, 1.0f, 0.0f), new Color3f(0.0f, 0.0f, 1.0f));
        this.bgRoot.addChild((Node)this.axes);
        this.u.addBranchGraph(this.bgRoot);
        this.u.getViewer().getView().setFrontClipDistance(0.001);
        this.u.getViewer().getView().setBackClipDistance(100000.0);
        this.showAll(0);
        this.switchLabelsVisibility();
    }

    public void export(String s) {
        this.canvas.capture(s);
    }

    public void setViewpoint(TransformGroup tg, BoundingSphere sceneBounds, View view) {
        Transform3D viewTrans = new Transform3D();
        this.u.setLive(false);
        tg.setCapability(12);
        this.u.setLive(true);
        Point3d center = new Point3d();
        sceneBounds.getCenter(center);
        double radius = sceneBounds.getRadius();
        Vector3d up = new Vector3d();
        double eyeDist = radius * 4.0;
        switch (showAllAxis) {
            case 0: {
                this.eyePos.x += center.x;
                center.y = this.eyePos.y;
                this.eyePos.z += eyeDist;
                up.y = 1.0;
                break;
            }
            case 1: {
                this.eyePos.z += eyeDist;
                up.y = 1.0;
            }
        }
        viewTrans.lookAt(this.eyePos, center, up);
        viewTrans.invert();
        tg.setTransform(viewTrans);
    }

    protected void slideObserver(int value) {
        TransformGroup tg = this.u.getViewingPlatform().getViewPlatformTransform();
        Transform3D viewTrans = new Transform3D();
        float despl = (float)(this.worldBounds.getRadius() * 2.0 * (double)value / 100.0);
        this.eyePos.x = despl;
        Point3d center = new Point3d(this.eyePos.x, this.eyePos.y, 0.0);
        Vector3d up = new Vector3d(0.0, 1.0, 0.0);
        viewTrans.lookAt(this.eyePos, center, up);
        viewTrans.invert();
        tg.setTransform(viewTrans);
    }

    protected void zoomIntoScene(int value) {
        TransformGroup tg = this.u.getViewingPlatform().getViewPlatformTransform();
        Transform3D viewTrans = new Transform3D();
        float r = (float)this.worldBounds.getRadius();
        float maxDist = r * 4.0f;
        float despl = (float)((double)maxDist - (double)((float)value * maxDist) / 100.0);
        Point3d center = new Point3d(this.eyePos.x, this.eyePos.y, 0.0);
        this.eyePos.z = (double)despl + (double)r * 0.1;
        Vector3d up = new Vector3d(0.0, 1.0, 0.0);
        viewTrans.lookAt(this.eyePos, center, up);
        viewTrans.invert();
        tg.setTransform(viewTrans);
    }

    public void changePolygonMode(int mode) {
        this.u.setLive(false);
        int transp = -1;
        switch (mode) {
            case 0: {
                mode = 2;
                transp = 4;
                break;
            }
            case 1: {
                mode = 1;
                break;
            }
            case 2: {
                mode = 2;
                transp = 2;
                break;
            }
            default: {
                throw new RuntimeException("Unrecognised PolygonMode");
            }
        }
        ChangePolygonAttributes.setPolygonMode((Node)this.bgRoot, mode, true);
        if (transp != -1) {
            ChangeTransparencyAttributes.setTransparency((Node)this.bgRoot, transp);
        }
        this.u.setLive(true);
    }

    public void showOrigin(int axe) {
        showAllAxis = axe;
        this.setViewpoint(this.u.getViewingPlatform().getViewPlatformTransform(), this.minusBound, this.u.getViewer().getView());
    }

    void showAll(int axe) {
        this.worldBounds = (BoundingSphere)this.bgRoot.getBounds();
        showAllAxis = axe;
        this.setViewpoint(this.u.getViewingPlatform().getViewPlatformTransform(), this.worldBounds, this.u.getViewer().getView());
    }

    protected void switchLabelsVisibility() {
        boolean active = true;
        if (active) {
            this.optionalElementsInWorld.setWhichChild(-2);
        } else {
            this.optionalElementsInWorld.setWhichChild(-1);
        }
    }
}

